/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.realizers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.CHighlighting;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.CStyleRunData;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IZyEditableObject;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ZyLineContent {
    private static final FontRenderContext m_fontContext = new FontRenderContext(null, true, true);
    private static final Composite DEFAULT_COMPOSITE = AlphaComposite.getInstance(3, 0.3f);
    private static final Composite NORMAL_COMPOSITE = AlphaComposite.getInstance(3, 1.0f);
    private static final Stroke DEFAULT_BORDER_STROKE = new BasicStroke(1.2f);
    private static final Stroke NORMAL_STROKE = new BasicStroke(1.0f);
    private String m_text;
    private AttributedString m_atext;
    private double m_charWidth;
    private double m_charHeight;
    private TextLayout m_textLayout;
    private final ArrayList<CHighlighting> m_highlighting = new ArrayList();
    private final List<IZyEditableObject> m_lineObjects = new ArrayList<IZyEditableObject>();
    private final IZyEditableObject m_model;
    private Color m_backgroundColor = null;
    private final List<ObjectWrapper> m_objects = new ArrayList<ObjectWrapper>();

    public ZyLineContent(String string, Font font, IZyEditableObject iZyEditableObject) {
        this(string, font, new ArrayList<CStyleRunData>(), iZyEditableObject);
    }

    public ZyLineContent(String string, Font font, List<CStyleRunData> list, IZyEditableObject iZyEditableObject) {
        Preconditions.checkNotNull(string, "Error: Text argument can't be null");
        Preconditions.checkNotNull(list, "Error: Text color style run can't be null.");
        this.m_model = iZyEditableObject;
        this.regenerateLine(string, font, list);
    }

    public ZyLineContent(String string, IZyEditableObject iZyEditableObject) {
        this(string, null, iZyEditableObject);
    }

    private int calculateRealLength(int n2, int n3) {
        return n3 != -1 ? n3 : this.m_text.length() - n2;
    }

    private void drawHighlighting(Graphics2D graphics2D, double d2, double d3, double d4, double d5, Color color) {
        graphics2D.setColor(color);
        int n2 = (int)Math.round(d2);
        int n3 = (int)Math.round(d3);
        int n4 = (int)Math.round(d5);
        int n5 = (int)Math.round(d4);
        graphics2D.setComposite(DEFAULT_COMPOSITE);
        graphics2D.fillRoundRect(n2, n3, n5, n4, 10, 10);
        graphics2D.setColor(color.darker());
        graphics2D.setStroke(DEFAULT_BORDER_STROKE);
        graphics2D.drawRoundRect(n2, n3, n5, n4, 10, 10);
        graphics2D.setComposite(NORMAL_COMPOSITE);
        graphics2D.setStroke(NORMAL_STROKE);
    }

    private void regenerateLine(String string, Font font, List<CStyleRunData> list) {
        this.m_text = Preconditions.checkNotNull(string, "Error: text argument can not be null");
        Preconditions.checkNotNull(list, "Error: textColorStyleRun argument can not be null");
        this.m_atext = new AttributedString(string);
        if (!this.isEmpty()) {
            if (font != null) {
                this.m_atext.addAttribute(TextAttribute.FONT, font);
            }
            for (CStyleRunData cStyleRunData : list) {
                int n2 = cStyleRunData.getStart();
                int n3 = this.calculateRealLength(n2, cStyleRunData.getLength());
                this.validatePartialLineArguments(n2, n3);
                this.m_atext.addAttribute(TextAttribute.FOREGROUND, cStyleRunData.getColor(), n2, n2 + n3);
                if (cStyleRunData.getLineObject() != null) {
                    this.m_lineObjects.add(cStyleRunData.getLineObject());
                }
                if (cStyleRunData.getObject() == null) continue;
                this.setObject(n2, n3, cStyleRunData.getObject());
            }
            this.m_textLayout = new TextLayout(this.m_atext.getIterator(), m_fontContext);
        }
        if (font != null) {
            this.updateCharBounds(font);
        }
    }

    private void updateCharBounds(Font font) {
        this.m_charWidth = font.getStringBounds(this.m_text, m_fontContext).getWidth() / (double)this.getTextLayout().getCharacterCount();
        this.m_charHeight = font.getLineMetrics(this.m_text, m_fontContext).getHeight();
    }

    private void validatePartialLineArguments(int n2, int n3) {
        Preconditions.checkArgument(n2 >= 0 && n2 < this.m_text.length(), "Error: Position argument is out of bounds (Position: %d, Length: %d/%d)", (Object)n2, (Object)n3, (Object)this.m_text.length());
        Preconditions.checkArgument(n3 > 0 || n2 + n3 <= this.m_text.length(), "Error: Length argument is out of bounds (Position: %d, Length: %d)", n2, n3);
    }

    public synchronized boolean clearHighlighting(int n2) {
        if (this.m_highlighting.isEmpty()) {
            return false;
        }
        for (CHighlighting cHighlighting : new ArrayList<CHighlighting>(this.m_highlighting)) {
            if (cHighlighting.getLevel() != n2) continue;
            this.m_highlighting.remove(cHighlighting);
            return true;
        }
        return false;
    }

    public synchronized void draw(Graphics2D graphics2D, float f2, float f3) {
        if (!this.isEmpty()) {
            this.m_textLayout.draw(graphics2D, f2, f3);
            for (CHighlighting cHighlighting : new ArrayList<CHighlighting>(this.m_highlighting)) {
                double d2 = (double)f2 + cHighlighting.getStart() - 2.0;
                double d3 = (double)f3 - this.m_charHeight + 4.0;
                double d4 = cHighlighting.getEnd() + 4.0;
                double d5 = this.m_charHeight - 1.0;
                this.drawHighlighting(graphics2D, d2, d3, d4, d5, cHighlighting.getColor());
            }
        }
    }

    public Color getBackgroundColor() {
        return this.m_backgroundColor;
    }

    public List<CStyleRunData> getBackgroundStyleRunData(int n2, int n3) {
        Preconditions.checkState(n2 >= 0 && n2 <= n3 && n2 < this.m_text.length(), "Illegal start value.");
        Preconditions.checkState(n3 >= 0 && n3 >= n2 && n3 < this.m_text.length(), "Illegal end value.");
        ArrayList<CStyleRunData> arrayList = new ArrayList<CStyleRunData>();
        AttributedCharacterIterator attributedCharacterIterator = this.m_atext.getIterator();
        attributedCharacterIterator.setIndex(n2);
        Color color = null;
        int n4 = n2;
        for (int i2 = n2; i2 <= n3; ++i2) {
            Color color2 = (Color)attributedCharacterIterator.getAttribute(TextAttribute.BACKGROUND);
            if (color2 != null && !color2.equals(color) || color != null && !color.equals(color2)) {
                if (color != null) {
                    CStyleRunData cStyleRunData = new CStyleRunData(n4, i2 - n4 + 1, color);
                    arrayList.add(cStyleRunData);
                }
                color = color2;
                n4 = i2;
            }
            attributedCharacterIterator.next();
        }
        CStyleRunData cStyleRunData = new CStyleRunData(n4, n3 - n4 + 1, color);
        arrayList.add(cStyleRunData);
        return arrayList;
    }

    public Rectangle2D getBounds() {
        if (this.isEmpty()) {
            AttributedString attributedString = new AttributedString(" ");
            TextLayout textLayout = new TextLayout(attributedString.getIterator(), m_fontContext);
            return textLayout.getBounds();
        }
        return new Rectangle2D.Double(0.0, 0.0, this.m_charWidth * (double)this.m_text.length(), this.m_charHeight);
    }

    public double getCharWidth() {
        return this.m_charWidth;
    }

    public IZyEditableObject getLineFragmentObjectAt(int n2) {
        for (IZyEditableObject iZyEditableObject : this.m_lineObjects) {
            if (n2 < iZyEditableObject.getStart() || n2 >= iZyEditableObject.getStart() + iZyEditableObject.getLength()) continue;
            return iZyEditableObject;
        }
        for (IZyEditableObject iZyEditableObject : this.m_lineObjects) {
            if (n2 < iZyEditableObject.getStart() || n2 - 1 >= iZyEditableObject.getStart() + iZyEditableObject.getLength()) continue;
            return iZyEditableObject;
        }
        return null;
    }

    public List<IZyEditableObject> getLineFragmentObjectList() {
        return this.m_lineObjects;
    }

    public IZyEditableObject getLineObject() {
        return this.m_model;
    }

    public Object getObject(int n2) {
        ObjectWrapper objectWrapper = this.getObjectWrapper(n2);
        return objectWrapper == null ? null : objectWrapper.getObject();
    }

    public ObjectWrapper getObjectWrapper(int n2) {
        for (ObjectWrapper objectWrapper : this.m_objects) {
            if (n2 < objectWrapper.getStart() || n2 >= objectWrapper.getStart() + objectWrapper.getLength()) continue;
            return objectWrapper;
        }
        return null;
    }

    public String getText() {
        return this.m_text;
    }

    public String getText(IZyEditableObject iZyEditableObject) {
        Preconditions.checkNotNull(iZyEditableObject, "Error: editabeObject argument can not be null");
        int n2 = iZyEditableObject.getStart();
        int n3 = iZyEditableObject.getEnd();
        if (n2 >= this.m_text.length()) {
            return "";
        }
        if (n3 >= this.m_text.length()) {
            n3 = this.m_text.length();
        }
        return this.m_text.substring(n2, n3);
    }

    public TextLayout getTextLayout() {
        if (this.isEmpty()) {
            AttributedString attributedString = new AttributedString("+");
            return new TextLayout(attributedString.getIterator(), m_fontContext);
        }
        return new TextLayout(this.m_atext.getIterator(), m_fontContext);
    }

    public boolean hasHighlighting(int n2) {
        if (this.isEmpty()) {
            return false;
        }
        if (this.m_highlighting.isEmpty()) {
            return false;
        }
        for (CHighlighting cHighlighting : new ArrayList<CHighlighting>(this.m_highlighting)) {
            if (cHighlighting.getLevel() != n2) continue;
            return true;
        }
        return false;
    }

    public boolean isEditable(int n2) {
        return this.getLineFragmentObjectAt(n2) != null;
    }

    public boolean isEmpty() {
        return "".equals(this.m_text) || this.m_text == null;
    }

    public void setBackgroundColor(Color color) {
        this.m_backgroundColor = Preconditions.checkNotNull(color, "Error: Color argument can't be null");
        if (!this.isEmpty()) {
            this.m_atext.addAttribute(TextAttribute.BACKGROUND, color);
            this.m_textLayout = new TextLayout(this.m_atext.getIterator(), m_fontContext);
        }
    }

    public void setBackgroundColor(int n2, int n3, Color color) {
        if (!this.isEmpty()) {
            int n4 = this.calculateRealLength(n2, n3);
            this.validatePartialLineArguments(n2, n4);
            this.m_atext.addAttribute(TextAttribute.BACKGROUND, color, n2, n2 + n4);
            this.m_textLayout = new TextLayout(this.m_atext.getIterator(), m_fontContext);
        }
    }

    public void setFont(Font font) {
        Preconditions.checkNotNull(font, "Error: Font argument can't be null");
        if (!this.isEmpty()) {
            this.m_atext.addAttribute(TextAttribute.FONT, font);
            this.m_textLayout = new TextLayout(this.m_atext.getIterator(), m_fontContext);
            this.updateCharBounds(font);
        }
    }

    public void setFont(int n2, int n3, Font font) {
        Preconditions.checkNotNull(font, "Error: Font argument can't be null");
        if (!this.isEmpty()) {
            int n4 = this.calculateRealLength(n2, n3);
            this.validatePartialLineArguments(n2, n4);
            Preconditions.checkNotNull(font, "Error: Font argument can't be null");
            this.m_atext.addAttribute(TextAttribute.FONT, font, n2, n2 + n4);
            this.m_textLayout = new TextLayout(this.m_atext.getIterator(), m_fontContext);
            this.updateCharBounds(font);
        }
    }

    public synchronized boolean setHighlighting(int n2, Color color) {
        Preconditions.checkNotNull(color, "Error: Color argument can't be null");
        if (this.isEmpty()) {
            return false;
        }
        for (CHighlighting cHighlighting : new ArrayList<CHighlighting>(this.m_highlighting)) {
            if (cHighlighting.getLevel() != n2) continue;
            if (cHighlighting.getColor().equals(color)) {
                return false;
            }
            this.m_highlighting.remove(cHighlighting);
            break;
        }
        this.m_highlighting.add(new CHighlighting(n2, 0.0, (double)this.m_text.length() * this.m_charWidth, color));
        Collections.sort(this.m_highlighting);
        return true;
    }

    public synchronized void setHighlighting(int n2, int n3, int n4, Color color) {
        Preconditions.checkNotNull(color, "Error: color argument can not be null");
        if (!this.isEmpty()) {
            int n5 = this.calculateRealLength(n2, n3);
            this.validatePartialLineArguments(n2, n5);
            if (this.hasHighlighting(n4)) {
                this.clearHighlighting(n4);
            }
            this.m_highlighting.add(new CHighlighting(n4, (double)n2 * this.m_charWidth, (double)n5 * this.m_charWidth, color));
            Collections.sort(this.m_highlighting);
        }
    }

    public void setObject(int n2, int n3, Object object) {
        Preconditions.checkNotNull(object, "Error: object argument can not be null");
        this.m_objects.add(new ObjectWrapper(n2, n3, object));
    }

    public void setTextColor(Color color) {
        Preconditions.checkNotNull(color, "Error: Color argument can't be null");
        if (!this.isEmpty()) {
            this.m_atext.addAttribute(TextAttribute.FOREGROUND, color);
            this.m_textLayout = new TextLayout(this.m_atext.getIterator(), m_fontContext);
        }
    }

    public void setTextColor(int n2, int n3, Color color) {
        if (!this.isEmpty()) {
            int n4 = this.calculateRealLength(n2, n3);
            this.validatePartialLineArguments(n2, n4);
            this.m_atext.addAttribute(TextAttribute.FOREGROUND, color, n2, n2 + n4);
            this.m_textLayout = new TextLayout(this.m_atext.getIterator(), m_fontContext);
        }
    }

    public String toString() {
        return this.getText();
    }

    public static class ObjectWrapper {
        private final int start;
        private final int length;
        private final Object object;

        public ObjectWrapper(int n2, int n3, Object object) {
            this.start = n2;
            this.length = n3;
            this.object = object;
        }

        public int getLength() {
            return this.length;
        }

        public Object getObject() {
            return this.object;
        }

        public int getStart() {
            return this.start;
        }
    }
}

