/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours;

import com.google.security.zynamics.zylib.general.ClipboardHelpers;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ECommentPlacement;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IZyEditableObject;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.CAbstractKeyBehavior;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.UndoHistroy.CUndoManager;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLineContent;
import java.awt.Point;

public class CDelKeyBehavior
extends CAbstractKeyBehavior {
    private boolean m_wasSelection = false;
    private IZyEditableObject m_editableObject;
    private boolean m_isAboveComment;
    private boolean m_isBehindComment;
    private boolean m_isLabelComment;

    public CDelKeyBehavior(CUndoManager cUndoManager) {
        super(cUndoManager);
    }

    private Point getMultiCommentEndPoint(int n2, int n3) {
        if (this.isComment(n2, n3)) {
            ZyLineContent zyLineContent = this.getLineContent(n3);
            int n4 = zyLineContent.getLineFragmentObjectList().get(zyLineContent.getLineFragmentObjectList().size() - 1).getEnd();
            int n5 = n3;
            for (int i2 = n3 + 1; i2 <= this.getLabelContent().getLastLineIndexOfModelAt(n3); ++i2) {
                ZyLineContent zyLineContent2 = this.getLineContent(i2);
                int n6 = zyLineContent2.getLineFragmentObjectList().size();
                IZyEditableObject iZyEditableObject = zyLineContent2.getLineFragmentObjectAt(0);
                if (iZyEditableObject == null) break;
                if (!iZyEditableObject.isCommentDelimiter()) continue;
                n4 = zyLineContent2.getLineFragmentObjectAt(n6 - 1).getEnd();
                n5 = i2;
            }
            return new Point(n4, n5);
        }
        return null;
    }

    @Override
    protected void initUndoHistory() {
        int n2 = this.getCaretEndPosX();
        int n3 = this.getCaretMouseReleasedY();
        ZyLineContent zyLineContent = this.getLineContent(n3);
        IZyEditableObject iZyEditableObject = zyLineContent.getLineFragmentObjectAt(n2);
        this.m_editableObject = zyLineContent.getLineObject();
        if (iZyEditableObject != null) {
            String string = zyLineContent.getText().substring(iZyEditableObject.getStart(), iZyEditableObject.getEnd());
            this.m_isAboveComment = this.isAboveLineComment(n3);
            this.m_isBehindComment = this.isBehindLineComment(n2, n3);
            this.m_isLabelComment = this.isLabelComment(n3);
            if (this.isComment(n2, n3)) {
                string = this.getMultiLineComment(n3);
            }
            this.udpateUndolist(this.getLabelContent(), zyLineContent.getLineObject().getPersistentModel(), this.m_editableObject, string, this.m_isAboveComment, this.m_isBehindComment, this.m_isLabelComment, this.getCaretStartPosX(), this.getCaretMousePressedX(), this.getCaretMousePressedY(), this.getCaretEndPosX(), this.getCaretMouseReleasedX(), this.getCaretMouseReleasedY());
        }
    }

    @Override
    protected void updateCaret() {
        this.m_wasSelection = false;
    }

    @Override
    protected void updateClipboard() {
        if (this.isShiftPressed() && !this.isCtrlPressed() && !this.isAltPressed()) {
            String string = this.getSelectedText();
            ClipboardHelpers.copyToClipboard(string);
        }
    }

    @Override
    protected void updateLabelContent() {
        if (this.m_wasSelection) {
            return;
        }
        int n2 = this.getCaretEndPosX();
        int n3 = this.getCaretMouseReleasedY();
        ZyLineContent zyLineContent = this.getLineContent(n3);
        IZyEditableObject iZyEditableObject = zyLineContent.getLineFragmentObjectAt(n2);
        if (iZyEditableObject == null) {
            return;
        }
        if (this.isComment(n2, n3)) {
            IZyEditableObject iZyEditableObject2;
            ZyLineContent zyLineContent2;
            String string;
            if (iZyEditableObject.isCommentDelimiter()) {
                return;
            }
            Point point = this.getMultiCommentEndPoint(n2, n3);
            if (n3 == point.y && (n2 == point.x || n2 == point.x - 1 && zyLineContent.getText().endsWith("\n"))) {
                return;
            }
            int n4 = n2 - iZyEditableObject.getStart();
            String string2 = string = zyLineContent.getText().substring(iZyEditableObject.getStart(), iZyEditableObject.getEnd());
            if (n4 < string.length()) {
                string2 = String.format("%s%s", string.substring(0, n4), string.substring(n4 + 1));
            } else if (this.isComment(n2, n3) && n3 < this.getLabelContent().getLineCount() - 1 && (zyLineContent2 = this.getLineContent(n3 + 1)).getLineObject() == zyLineContent.getLineObject() && (iZyEditableObject2 = zyLineContent2.getLineFragmentObjectAt(0)) != null && iZyEditableObject2.isCommentDelimiter()) {
                string2 = string.substring(0, n4 - 1);
            }
            if (this.isComment(n2, n3) && !(string2 = this.getMultilineComment(n3, string2)).endsWith("\r")) {
                string2 = string2 + "\r";
            }
            iZyEditableObject.update(string2);
            if (this.isLabelComment(n3)) {
                zyLineContent.getLineObject().update(string2);
            } else if (this.isAboveLineComment(n3)) {
                zyLineContent.getLineObject().updateComment(string2, ECommentPlacement.ABOVE_LINE);
            } else if (this.isBehindLineComment(n2, n3)) {
                zyLineContent.getLineObject().updateComment(string2, ECommentPlacement.BEHIND_LINE);
            }
        } else {
            throw new RuntimeException("Not implemented yet.");
        }
        this.getLabelContent().getLineEditor().recreateLabelLines(this.getLabelContent(), zyLineContent.getLineObject().getPersistentModel());
    }

    @Override
    protected void updateSelection() {
        this.m_wasSelection = this.isSelection();
        this.deleteSelection();
    }

    @Override
    protected void updateUndoHistory() {
        int n2 = this.getCaretEndPosX();
        int n3 = this.getCaretMouseReleasedY();
        ZyLineContent zyLineContent = this.getLineContent(n3);
        IZyEditableObject iZyEditableObject = zyLineContent.getLineFragmentObjectAt(n2);
        String string = "";
        if (iZyEditableObject != null) {
            string = zyLineContent.getText().substring(iZyEditableObject.getStart(), iZyEditableObject.getEnd());
            if (this.isComment(n2, n3)) {
                string = this.getMultiLineComment(n3);
            }
            this.udpateUndolist(this.getLabelContent(), zyLineContent.getLineObject().getPersistentModel(), this.m_editableObject, string, this.m_isAboveComment, this.m_isBehindComment, this.m_isLabelComment, this.getCaretStartPosX(), this.getCaretMousePressedX(), this.getCaretMousePressedY(), this.getCaretEndPosX(), this.getCaretMouseReleasedX(), this.getCaretMouseReleasedY());
        }
    }
}

