/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.proximity;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.zygraph.IZyGraphSelectionListener;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.GraphHelpers;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.SelectedVisibleFilter;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.AbstractZyGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.util.Collection;
import java.util.List;

public abstract class ProximityUpdater<NodeType extends ZyGraphNode<?>>
implements IZyGraphSelectionListener {
    private Collection<NodeType> m_lastSelectedNodes;
    private final AbstractZyGraph<NodeType, ?> m_graph;

    protected ProximityUpdater(AbstractZyGraph<NodeType, ?> abstractZyGraph) {
        Preconditions.checkNotNull(abstractZyGraph, "Error: Graph argument can not be null");
        this.m_graph = abstractZyGraph;
        this.m_lastSelectedNodes = this.m_graph.getSelectedNodes();
    }

    protected abstract void showNodes(Collection<NodeType> var1, Collection<NodeType> var2);

    @Override
    public void selectionChanged() {
        if (!this.m_graph.getSettings().getProximitySettings().getProximityBrowsing() || this.m_graph.getSettings().getProximitySettings().getProximityBrowsingFrozen()) {
            return;
        }
        Collection<NodeType> collection = SelectedVisibleFilter.filter(this.m_graph.getSelectedNodes());
        if (collection.equals(this.m_lastSelectedNodes)) {
            return;
        }
        this.m_lastSelectedNodes = collection;
        if (!collection.isEmpty()) {
            List list = GraphHelpers.getNodes(this.m_graph);
            list.removeAll(collection);
            this.showNodes(collection, list);
        }
    }
}

