/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.proximity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.GraphConverters;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IGroupNode;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.ITextNode;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNode;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.NodeHelpers;
import com.google.security.zynamics.zylib.gui.zygraph.wrappers.ViewNodeAdapter;
import com.google.security.zynamics.zylib.types.common.CollectionHelpers;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.AbstractZyGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class ProximityRangeCalculator {
    private static Set<ViewNodeAdapter> getGroupMembers(IGroupNode<?, ?> iGroupNode) {
        HashSet<ViewNodeAdapter> hashSet = new HashSet<ViewNodeAdapter>();
        for (IViewNode iViewNode : iGroupNode.getElements()) {
            hashSet.add(new ViewNodeAdapter(iViewNode));
        }
        return hashSet;
    }

    private static <NodeType extends ZyGraphNode<? extends IViewNode<?>>> Set<ViewNodeAdapter> getParentGroups(NodeType NodeType2) {
        HashSet<ViewNodeAdapter> hashSet = new HashSet<ViewNodeAdapter>();
        for (IGroupNode<?, ?> iGroupNode = NodeType2.getRawNode().getParentGroup(); iGroupNode != null; iGroupNode = iGroupNode.getParentGroup()) {
            hashSet.add(new ViewNodeAdapter(iGroupNode));
        }
        return hashSet;
    }

    private static List<ViewNodeAdapter> getPredecessors(Iterable<ViewNodeAdapter> iterable, int n2) {
        ArrayList<ViewNodeAdapter> arrayList = new ArrayList<ViewNodeAdapter>();
        for (ViewNodeAdapter viewNodeAdapter : iterable) {
            arrayList.addAll(ProximityRangeCalculator.getPredecessors(viewNodeAdapter, n2));
        }
        return arrayList;
    }

    private static Set<ViewNodeAdapter> getPredecessors(ViewNodeAdapter viewNodeAdapter, int n2) {
        HashSet<ViewNodeAdapter> hashSet = new HashSet<ViewNodeAdapter>();
        ProximityRangeCalculator.getPredecessorsInternal(viewNodeAdapter, n2, hashSet, new HashSet<ViewNodeAdapter>());
        return hashSet;
    }

    private static void getPredecessorsInternal(ViewNodeAdapter viewNodeAdapter, int n2, Set<ViewNodeAdapter> set, Set<ViewNodeAdapter> set2) {
        for (ViewNodeAdapter viewNodeAdapter2 : viewNodeAdapter.getParents()) {
            if (n2 <= 0 && !(viewNodeAdapter2.getNode() instanceof ITextNode)) continue;
            if (viewNodeAdapter2.getNode().getParentGroup() != null) {
                IGroupNode<?, ?> iGroupNode = viewNodeAdapter2.getNode().getParentGroup();
                while (iGroupNode != null) {
                    if (!ProximityRangeCalculator.visited(set2, iGroupNode)) {
                        ViewNodeAdapter viewNodeAdapter3 = new ViewNodeAdapter(iGroupNode);
                        set2.add(viewNodeAdapter3);
                        set.add(viewNodeAdapter3);
                        iGroupNode = iGroupNode.getParentGroup();
                        continue;
                    }
                    iGroupNode = null;
                }
            }
            set2.add(viewNodeAdapter2);
            set.add(viewNodeAdapter2);
            ProximityRangeCalculator.getSuccessorsInternal(viewNodeAdapter2, -1, set, new HashSet<ViewNodeAdapter>());
            ProximityRangeCalculator.getPredecessorsInternal(viewNodeAdapter2, n2 - 1, set, set2);
        }
    }

    private static int getRealDepth(int n2) {
        return n2 == -1 ? Integer.MAX_VALUE : n2;
    }

    private static List<ViewNodeAdapter> getSuccessors(Iterable<ViewNodeAdapter> iterable, int n2) {
        ArrayList<ViewNodeAdapter> arrayList = new ArrayList<ViewNodeAdapter>();
        for (ViewNodeAdapter viewNodeAdapter : iterable) {
            arrayList.addAll(ProximityRangeCalculator.getSuccessors(viewNodeAdapter, n2));
        }
        return arrayList;
    }

    private static Set<ViewNodeAdapter> getSuccessors(ViewNodeAdapter viewNodeAdapter, int n2) {
        HashSet<ViewNodeAdapter> hashSet = new HashSet<ViewNodeAdapter>();
        ProximityRangeCalculator.getSuccessorsInternal(viewNodeAdapter, n2, hashSet, new HashSet<ViewNodeAdapter>());
        return hashSet;
    }

    private static void getSuccessorsInternal(ViewNodeAdapter viewNodeAdapter, int n2, Set<ViewNodeAdapter> set, HashSet<ViewNodeAdapter> hashSet) {
        for (ViewNodeAdapter viewNodeAdapter2 : viewNodeAdapter.getChildren()) {
            if (n2 <= 0 && !(viewNodeAdapter2.getNode() instanceof ITextNode)) continue;
            if (viewNodeAdapter2.getNode().getParentGroup() != null) {
                IGroupNode<?, ?> iGroupNode = viewNodeAdapter2.getNode().getParentGroup();
                while (iGroupNode != null) {
                    if (!ProximityRangeCalculator.visited(hashSet, iGroupNode)) {
                        ViewNodeAdapter viewNodeAdapter3 = new ViewNodeAdapter(iGroupNode);
                        hashSet.add(viewNodeAdapter3);
                        set.add(viewNodeAdapter3);
                        iGroupNode = iGroupNode.getParentGroup();
                        continue;
                    }
                    iGroupNode = null;
                }
            }
            if (NodeHelpers.getVisibleNode(viewNodeAdapter2.getNode()) != viewNodeAdapter2.getNode()) continue;
            hashSet.add(viewNodeAdapter2);
            set.add(viewNodeAdapter2);
            ProximityRangeCalculator.getPredecessorsInternal(viewNodeAdapter2, -1, set, new HashSet<ViewNodeAdapter>());
            ProximityRangeCalculator.getSuccessorsInternal(viewNodeAdapter2, n2 - 1, set, hashSet);
        }
    }

    private static boolean visited(Set<ViewNodeAdapter> set, final IGroupNode<?, ?> iGroupNode) {
        return CollectionHelpers.any(set, new ICollectionFilter<ViewNodeAdapter>(){

            @Override
            public boolean qualifies(ViewNodeAdapter viewNodeAdapter) {
                return viewNodeAdapter.getNode() == iGroupNode;
            }
        });
    }

    public static <NodeType extends ZyGraphNode<? extends IViewNode<?>>> Set<NodeType> getNeighbors(AbstractZyGraph<NodeType, ?> abstractZyGraph, Collection<NodeType> collection, int n2, int n3) {
        Preconditions.checkNotNull(abstractZyGraph, "Graph argument can not be null");
        Preconditions.checkNotNull(collection, "Nodes argument can not be null");
        LinkedHashSet<NodeType> linkedHashSet = new LinkedHashSet<NodeType>(collection);
        for (ZyGraphNode zyGraphNode : collection) {
            ArrayList<ZyGraphNode> arrayList = new ArrayList<ZyGraphNode>();
            arrayList.add(zyGraphNode);
            List list = GraphConverters.convert(arrayList);
            List<ViewNodeAdapter> list2 = ViewNodeAdapter.wrap(Lists.newArrayList(list));
            List<ViewNodeAdapter> list3 = ProximityRangeCalculator.getPredecessors(list2, ProximityRangeCalculator.getRealDepth(n3));
            List<ViewNodeAdapter> list4 = ProximityRangeCalculator.getSuccessors(list2, ProximityRangeCalculator.getRealDepth(n2));
            linkedHashSet.addAll(ViewNodeAdapter.unwrap(abstractZyGraph, ProximityRangeCalculator.getParentGroups(zyGraphNode)));
            if (zyGraphNode.getRawNode() instanceof IGroupNode && zyGraphNode.isSelected()) {
                linkedHashSet.addAll(ViewNodeAdapter.unwrap(abstractZyGraph, ProximityRangeCalculator.getGroupMembers((IGroupNode)zyGraphNode.getRawNode())));
            }
            linkedHashSet.addAll(ViewNodeAdapter.unwrap(abstractZyGraph, list3));
            linkedHashSet.addAll(ViewNodeAdapter.unwrap(abstractZyGraph, list4));
        }
        return linkedHashSet;
    }
}

