/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.nodes;

import com.google.security.zynamics.zylib.gui.zygraph.edges.IViewEdge;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IGroupNode;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNode;
import com.google.security.zynamics.zylib.types.common.CollectionHelpers;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import java.util.HashSet;

public class NodeHelpers {
    public static <NodeType extends IViewNode<?>> int countInvisibleIndegree(NodeType NodeType2) {
        return CollectionHelpers.countIf(NodeType2.getIncomingEdges(), new ICollectionFilter<IViewEdge<? extends IViewNode<?>>>(){

            @Override
            public boolean qualifies(IViewEdge<? extends IViewNode<?>> iViewEdge) {
                return !NodeHelpers.getVisibleNode((IViewNode)iViewEdge.getSource()).isVisible();
            }
        });
    }

    public static <NodeType extends IViewNode<?>> int countInvisibleIndegreeNeighbours(NodeType NodeType2) {
        HashSet<IViewNode> hashSet = new HashSet<IViewNode>();
        for (IViewEdge iViewEdge : NodeType2.getIncomingEdges()) {
            IViewNode iViewNode = (IViewNode)iViewEdge.getSource();
            if (iViewNode.isVisible()) continue;
            hashSet.add(iViewNode);
        }
        return hashSet.size();
    }

    public static <NodeType extends IViewNode<?>> int countInvisibleOutdegree(NodeType NodeType2) {
        return CollectionHelpers.countIf(NodeType2.getOutgoingEdges(), new ICollectionFilter<IViewEdge<? extends IViewNode<?>>>(){

            @Override
            public boolean qualifies(IViewEdge<? extends IViewNode<?>> iViewEdge) {
                return !NodeHelpers.getVisibleNode((IViewNode)iViewEdge.getTarget()).isVisible();
            }
        });
    }

    public static <NodeType extends IViewNode<?>> int countInvisibleOutdegreeNeighbours(NodeType NodeType2) {
        HashSet<IViewNode> hashSet = new HashSet<IViewNode>();
        for (IViewEdge iViewEdge : NodeType2.getOutgoingEdges()) {
            IViewNode iViewNode = (IViewNode)iViewEdge.getTarget();
            if (iViewNode.isVisible()) continue;
            hashSet.add(iViewNode);
        }
        return hashSet.size();
    }

    public static IViewNode<?> getVisibleNode(IViewNode<?> iViewNode) {
        IViewNode<?> iViewNode2 = iViewNode;
        for (IGroupNode<?, ?> iGroupNode = iViewNode.getParentGroup(); iGroupNode != null && iGroupNode.isCollapsed(); iGroupNode = iGroupNode.getParentGroup()) {
            iViewNode2 = iGroupNode;
        }
        return iViewNode2;
    }
}

