/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.nodes;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.zygraph.edges.IViewEdge;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNode;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNodeListener;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public abstract class CViewNode<EdgeType extends IViewEdge<? extends IViewNode<?>>>
implements IViewNode<EdgeType> {
    private int m_id;
    private double m_x;
    private double m_y;
    private Color m_color;
    private Color m_borderColor;
    private boolean m_selected;
    private boolean m_visible;
    private final List<EdgeType> m_incomingEdges = new ArrayList<EdgeType>();
    private final List<EdgeType> m_outgoingEdges = new ArrayList<EdgeType>();
    private final ListenerProvider<IViewNodeListener> m_listeners = new ListenerProvider();
    private double m_height;
    private double m_width;

    public CViewNode(int n2, double d2, double d3, double d4, double d5, Color color, Color color2, boolean bl2, boolean bl3) {
        Preconditions.checkArgument(n2 >= -1, "Error: Node ID must be positive or -1 for unsaved nodes.");
        Preconditions.checkNotNull(color, "Error: Color argument can't be null");
        Preconditions.checkNotNull(color2, "Error: Border color argument can't be null");
        this.m_id = n2;
        this.m_x = d2;
        this.m_y = d3;
        this.m_height = d5;
        this.m_width = d4;
        this.m_color = color;
        this.m_borderColor = color2;
        this.m_selected = bl2;
        this.m_visible = bl3;
    }

    protected ListenerProvider<IViewNodeListener> getListeners() {
        return this.m_listeners;
    }

    public void addIncomingEdge(EdgeType EdgeType2) {
        Preconditions.checkNotNull(EdgeType2, "Error: Edge argument can't be null");
        this.m_incomingEdges.add(EdgeType2);
    }

    @Override
    public void addListener(IViewNodeListener iViewNodeListener) {
        this.m_listeners.addListener(iViewNodeListener);
    }

    public void addOutgoingEdge(EdgeType EdgeType2) {
        Preconditions.checkNotNull(EdgeType2, "Error: Edge argument can not be null");
        Preconditions.checkArgument(!this.m_outgoingEdges.contains(EdgeType2), "Error: Outgoing edge was added before");
        this.m_outgoingEdges.add(EdgeType2);
    }

    @Override
    public Color getBorderColor() {
        return new Color(this.m_borderColor.getRGB());
    }

    @Override
    public Color getColor() {
        return new Color(this.m_color.getRGB());
    }

    @Override
    public double getHeight() {
        return this.m_height;
    }

    @Override
    public int getId() {
        return this.m_id;
    }

    @Override
    public List<EdgeType> getIncomingEdges() {
        return new ArrayList<EdgeType>(this.m_incomingEdges);
    }

    @Override
    public List<EdgeType> getOutgoingEdges() {
        return new ArrayList<EdgeType>(this.m_outgoingEdges);
    }

    @Override
    public double getWidth() {
        return this.m_width;
    }

    @Override
    public double getX() {
        return this.m_x;
    }

    @Override
    public double getY() {
        return this.m_y;
    }

    @Override
    public boolean isSelected() {
        return this.m_selected;
    }

    @Override
    public boolean isVisible() {
        return this.m_visible;
    }

    public void removeAllListeners() {
        ArrayList<IViewNodeListener> arrayList = new ArrayList<IViewNodeListener>();
        for (IViewNodeListener iViewNodeListener : this.m_listeners) {
            arrayList.add(iViewNodeListener);
        }
        for (IViewNodeListener iViewNodeListener : arrayList) {
            this.m_listeners.removeListener(iViewNodeListener);
        }
    }

    public void removeIncomingEdge(EdgeType EdgeType2) {
        Preconditions.checkNotNull(EdgeType2, "Error: Edge argument can not be null");
        this.m_incomingEdges.remove(EdgeType2);
    }

    @Override
    public void removeListener(IViewNodeListener iViewNodeListener) {
        Preconditions.checkNotNull(iViewNodeListener, "Error: Listener argument can not be null");
        this.m_listeners.removeListener(iViewNodeListener);
    }

    public void removeOutgoingEdge(EdgeType EdgeType2) {
        Preconditions.checkNotNull(EdgeType2, "Error: Edge argument can not be null");
        this.m_outgoingEdges.remove(EdgeType2);
    }

    @Override
    public void setBorderColor(Color color) {
        Preconditions.checkNotNull(color, "Error: Color argument can not be null");
        if (this.m_borderColor.equals(color)) {
            return;
        }
        this.m_borderColor = color;
        for (IViewNodeListener iViewNodeListener : this.m_listeners) {
            try {
                iViewNodeListener.changedBorderColor(this, color);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void setColor(Color color) {
        Preconditions.checkNotNull(color, "Error: Color argument can not be null");
        if (this.m_color.equals(color)) {
            return;
        }
        this.m_color = color;
        for (IViewNodeListener iViewNodeListener : this.m_listeners) {
            try {
                iViewNodeListener.changedColor(this, color);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void setHeight(double d2) {
        if (this.m_height == d2) {
            return;
        }
        this.m_height = d2;
        for (IViewNodeListener iViewNodeListener : this.m_listeners) {
            try {
                iViewNodeListener.heightChanged(this, d2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void setId(int n2) {
        this.m_id = n2;
    }

    @Override
    public void setSelected(boolean bl2) {
        if (bl2 == this.m_selected) {
            return;
        }
        this.m_selected = bl2;
        for (IViewNodeListener iViewNodeListener : this.m_listeners) {
            try {
                iViewNodeListener.changedSelection(this, bl2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void setVisible(boolean bl2) {
        if (bl2 == this.m_visible) {
            return;
        }
        this.m_visible = bl2;
        for (IViewNodeListener iViewNodeListener : this.m_listeners) {
            try {
                iViewNodeListener.changedVisibility(this, this.isVisible());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void setWidth(double d2) {
        if (this.m_width == d2) {
            return;
        }
        this.m_width = d2;
        for (IViewNodeListener iViewNodeListener : this.m_listeners) {
            try {
                iViewNodeListener.widthChanged(this, d2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void setX(double d2) {
        if (this.m_x == d2) {
            return;
        }
        this.m_x = d2;
        for (IViewNodeListener iViewNodeListener : this.m_listeners) {
            try {
                iViewNodeListener.xposChanged(this, d2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void setY(double d2) {
        if (this.m_y == d2) {
            return;
        }
        this.m_y = d2;
        for (IViewNodeListener iViewNodeListener : this.m_listeners) {
            try {
                iViewNodeListener.yposChanged(this, d2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

