/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.helpers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.INodeFilter;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.ISelectableNode;
import com.google.security.zynamics.zylib.gui.zygraph.proximity.CProximityNode;

public class StandardFilters {
    public static <NodeType extends ISelectableNode> INodeFilter<NodeType> getDeselectedFilter() {
        INodeFilter<NodeType> iNodeFilter = StandardFilters.getSelectedFilter();
        return StandardFilters.getNegatedFilter(iNodeFilter);
    }

    public static <NodeType> INodeFilter<NodeType> getInfoNodeFilter() {
        return new INodeFilter<NodeType>(){

            @Override
            public boolean qualifies(NodeType NodeType2) {
                return NodeType2 instanceof CProximityNode;
            }
        };
    }

    public static <NodeType> INodeFilter<NodeType> getNegatedFilter(final INodeFilter<NodeType> iNodeFilter) {
        Preconditions.checkNotNull(iNodeFilter, "Error: Filter argument can't be null");
        return new INodeFilter<NodeType>(){

            @Override
            public boolean qualifies(NodeType NodeType2) {
                return !iNodeFilter.qualifies(NodeType2);
            }
        };
    }

    public static <NodeType extends ISelectableNode> INodeFilter<NodeType> getSelectedFilter() {
        return new INodeFilter<NodeType>(){

            @Override
            public boolean qualifies(NodeType NodeType2) {
                return NodeType2.isSelected();
            }
        };
    }

    public static <NodeType> INodeFilter<NodeType> getTrueFilter() {
        return new INodeFilter<NodeType>(){

            @Override
            public boolean qualifies(NodeType NodeType2) {
                return true;
            }
        };
    }
}

