/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.helpers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.zygraph.functions.IteratorFunctions;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.IEdgeCallback;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.IEdgeIterableGraph;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.IIterableGraph;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.INodeCallback;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.INodeFilter;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.ISelectableGraph;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.ISelectableNode;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.IViewableGraph;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.IViewableNode;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.IZoomableGraph;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.StandardFilters;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLineContent;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import com.google.security.zynamics.zylib.types.common.IFilteredItemCallback;
import com.google.security.zynamics.zylib.types.common.IIterableCollection;
import com.google.security.zynamics.zylib.types.common.IterationMode;
import com.google.security.zynamics.zylib.types.graphs.GraphAlgorithms;
import com.google.security.zynamics.zylib.types.graphs.IGraphNode;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import com.google.security.zynamics.zylib.types.lists.IFilledList;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.AbstractZyGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.IZyNodeRealizer;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GraphHelpers {
    public static <NodeType> boolean any(IIterableGraph<NodeType> iIterableGraph, final INodeFilter<NodeType> iNodeFilter) {
        final ArrayList arrayList = new ArrayList();
        iIterableGraph.iterate(new INodeCallback<NodeType>(){

            @Override
            public IterationMode next(NodeType NodeType2) {
                if (iNodeFilter.qualifies(NodeType2)) {
                    arrayList.add(NodeType2);
                    return IterationMode.STOP;
                }
                return IterationMode.CONTINUE;
            }
        });
        return arrayList.size() != 0;
    }

    public static <NodeType extends IGraphNode<NodeType> & ISelectableNode> boolean areAllChildrenDeselected(NodeType NodeType2) {
        INodeFilter iNodeFilter = StandardFilters.getSelectedFilter();
        return GraphAlgorithms.collectChildren(NodeType2, iNodeFilter).size() == 0;
    }

    public static <NodeType extends IGraphNode<NodeType> & ISelectableNode> boolean areAllParentsDeselected(NodeType NodeType2) {
        INodeFilter iNodeFilter = StandardFilters.getSelectedFilter();
        return GraphAlgorithms.collectParents(NodeType2, iNodeFilter).size() == 0;
    }

    public static <NodeType extends IViewableNode> Rectangle2D calculateBoundingBox(Collection<NodeType> collection) {
        Preconditions.checkNotNull(collection, "Node list argument can't be null");
        Preconditions.checkArgument(collection.size() != 0, "Node list argument can't be empty");
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        for (IViewableNode iViewableNode : collection) {
            iViewableNode.calcUnionRect(double_);
        }
        return double_;
    }

    public static <NodeType extends IGraphNode<NodeType> & ISelectableNode> void expandSelectionDown(ISelectableGraph<NodeType> iSelectableGraph) {
        Preconditions.checkNotNull(iSelectableGraph, "Error: Graph argument can't be null");
        final ArrayList arrayList = new ArrayList();
        final INodeFilter iNodeFilter = StandardFilters.getDeselectedFilter();
        iSelectableGraph.iterateSelected(new INodeCallback<NodeType>(){

            @Override
            public IterationMode next(NodeType NodeType2) {
                arrayList.addAll(GraphAlgorithms.collectChildren(NodeType2, iNodeFilter));
                return IterationMode.CONTINUE;
            }
        });
        iSelectableGraph.selectNodes(arrayList, true);
    }

    public static <NodeType extends IGraphNode<NodeType> & ISelectableNode> void expandSelectionUp(ISelectableGraph<NodeType> iSelectableGraph) {
        Preconditions.checkNotNull(iSelectableGraph, "Error: Graph argument can't be null");
        final ArrayList arrayList = new ArrayList();
        final INodeFilter iNodeFilter = StandardFilters.getDeselectedFilter();
        iSelectableGraph.iterateSelected(new INodeCallback<NodeType>(){

            @Override
            public IterationMode next(NodeType NodeType2) {
                arrayList.addAll(GraphAlgorithms.collectParents(NodeType2, iNodeFilter));
                return IterationMode.CONTINUE;
            }
        });
        iSelectableGraph.selectNodes(arrayList, true);
    }

    public static <NodeType> List<NodeType> filter(IIterableCollection<INodeCallback<NodeType>> iIterableCollection, final ICollectionFilter<NodeType> iCollectionFilter) {
        final ArrayList arrayList = new ArrayList();
        iIterableCollection.iterate(new INodeCallback<NodeType>(){

            @Override
            public IterationMode next(NodeType NodeType2) {
                if (iCollectionFilter.qualifies(NodeType2)) {
                    arrayList.add(NodeType2);
                }
                return IterationMode.CONTINUE;
            }
        });
        return arrayList;
    }

    public static <EdgeType> List<EdgeType> getEdges(IEdgeIterableGraph<EdgeType> iEdgeIterableGraph) {
        INodeFilter iNodeFilter = StandardFilters.getTrueFilter();
        return GraphHelpers.getEdges(iEdgeIterableGraph, iNodeFilter);
    }

    public static <EdgeType> List<EdgeType> getEdges(IEdgeIterableGraph<EdgeType> iEdgeIterableGraph, final INodeFilter<EdgeType> iNodeFilter) {
        Preconditions.checkNotNull(iEdgeIterableGraph, "Error: Graph argument can't be null");
        Preconditions.checkNotNull(iNodeFilter, "Error: Filter argument can't be null");
        final ArrayList arrayList = new ArrayList();
        iEdgeIterableGraph.iterateEdges(new IEdgeCallback<EdgeType>(){

            @Override
            public IterationMode nextEdge(EdgeType EdgeType2) {
                if (iNodeFilter.qualifies(EdgeType2)) {
                    arrayList.add(EdgeType2);
                }
                return IterationMode.CONTINUE;
            }
        });
        return arrayList;
    }

    public static <NodeType extends ISelectableNode> List<NodeType> getInvisibleNodes(IViewableGraph<NodeType> iViewableGraph) {
        final ArrayList arrayList = new ArrayList();
        iViewableGraph.iterateInvisible(new INodeCallback<NodeType>(){

            @Override
            public IterationMode next(NodeType NodeType2) {
                arrayList.add(NodeType2);
                return IterationMode.CONTINUE;
            }
        });
        return arrayList;
    }

    public static <NodeType> List<NodeType> getNodes(IIterableGraph<NodeType> iIterableGraph) {
        INodeFilter iNodeFilter = StandardFilters.getTrueFilter();
        return GraphHelpers.getNodes(iIterableGraph, iNodeFilter);
    }

    public static <NodeType> List<NodeType> getNodes(IIterableGraph<NodeType> iIterableGraph, final INodeFilter<NodeType> iNodeFilter) {
        Preconditions.checkNotNull(iIterableGraph, "Error: Graph argument can't be null");
        Preconditions.checkNotNull(iNodeFilter, "Error: Filter argument can't be null");
        final ArrayList arrayList = new ArrayList();
        iIterableGraph.iterate(new INodeCallback<NodeType>(){

            @Override
            public IterationMode next(NodeType NodeType2) {
                if (iNodeFilter.qualifies(NodeType2)) {
                    arrayList.add(NodeType2);
                }
                return IterationMode.CONTINUE;
            }
        });
        return arrayList;
    }

    public static <NodeType extends IGraphNode<NodeType> & ISelectableNode> Collection<NodeType> getPredecessorsOfSelection(ISelectableGraph<NodeType> iSelectableGraph) {
        return GraphAlgorithms.getPredecessors(GraphHelpers.getSelectedNodes(iSelectableGraph));
    }

    public static <NodeType extends ZyGraphNode<?>> String getSelectedContent(AbstractZyGraph<NodeType, ?> abstractZyGraph) {
        final StringBuilder stringBuilder = new StringBuilder();
        IteratorFunctions.iterateSelected(abstractZyGraph, new INodeCallback<NodeType>(){

            @Override
            public IterationMode next(NodeType NodeType2) {
                IZyNodeRealizer iZyNodeRealizer = ((ZyGraphNode)NodeType2).getRealizer();
                ZyLabelContent zyLabelContent = iZyNodeRealizer.getNodeContent();
                for (ZyLineContent zyLineContent : zyLabelContent) {
                    stringBuilder.append(zyLineContent.getText());
                    stringBuilder.append("\n");
                }
                stringBuilder.append("\n");
                return IterationMode.CONTINUE;
            }
        });
        return stringBuilder.toString();
    }

    @Deprecated
    public static <NodeType extends ISelectableNode> IFilledList<NodeType> getSelectedNodes(ISelectableGraph<NodeType> iSelectableGraph) {
        Preconditions.checkNotNull(iSelectableGraph, "Error: Graph argument can't be null");
        final FilledList filledList = new FilledList();
        iSelectableGraph.iterateSelected(new INodeCallback<NodeType>(){

            @Override
            public IterationMode next(NodeType NodeType2) {
                filledList.add(NodeType2);
                return IterationMode.CONTINUE;
            }
        });
        return filledList;
    }

    public static <NodeType extends IGraphNode<NodeType> & ISelectableNode> Collection<NodeType> getSuccessors(NodeType NodeType2) {
        ArrayList<NodeType> arrayList = new ArrayList<NodeType>();
        arrayList.add(NodeType2);
        return GraphAlgorithms.getSuccessors(arrayList);
    }

    public static <NodeType extends IGraphNode<NodeType> & ISelectableNode> Collection<NodeType> getSuccessorsOfSelection(ISelectableGraph<NodeType> iSelectableGraph) {
        return GraphAlgorithms.getSuccessors(GraphHelpers.getSelectedNodes(iSelectableGraph));
    }

    public static <NodeType extends ISelectableNode> List<NodeType> getUnselectedNodes(IIterableGraph<NodeType> iIterableGraph) {
        Preconditions.checkNotNull(iIterableGraph, "Error: Graph argument can't be null");
        final ArrayList arrayList = new ArrayList();
        iIterableGraph.iterate(new INodeCallback<NodeType>(){

            @Override
            public IterationMode next(NodeType NodeType2) {
                if (!NodeType2.isSelected()) {
                    arrayList.add(NodeType2);
                }
                return IterationMode.CONTINUE;
            }
        });
        return arrayList;
    }

    public static <NodeType extends ISelectableNode> Set<NodeType> getVisibleNodes(IViewableGraph<NodeType> iViewableGraph) {
        final HashSet hashSet = new HashSet();
        iViewableGraph.iterateVisible(new INodeCallback<NodeType>(){

            @Override
            public IterationMode next(NodeType NodeType2) {
                hashSet.add(NodeType2);
                return IterationMode.CONTINUE;
            }
        });
        return hashSet;
    }

    public static <ItemType, CollectionType extends IIterableCollection<INodeCallback<ItemType>>> void iterate(CollectionType CollectionType, final IFilteredItemCallback<ItemType> iFilteredItemCallback) {
        CollectionType.iterate(new INodeCallback<ItemType>(){

            @Override
            public IterationMode next(ItemType ItemType) {
                if (iFilteredItemCallback.qualifies(ItemType)) {
                    return iFilteredItemCallback.next(ItemType);
                }
                return IterationMode.CONTINUE;
            }
        });
    }

    public static <NodeType extends IGraphNode<NodeType> & ISelectableNode> void selectPredecessors(ISelectableGraph<NodeType> iSelectableGraph, NodeType NodeType2) {
        iSelectableGraph.selectNodes(GraphAlgorithms.getPredecessors(NodeType2), true);
    }

    public static <NodeType extends IGraphNode<NodeType> & ISelectableNode> void selectPredecessorsOfSelection(ISelectableGraph<NodeType> iSelectableGraph) {
        iSelectableGraph.selectNodes(GraphHelpers.getPredecessorsOfSelection(iSelectableGraph), true);
    }

    public static <NodeType extends IGraphNode<NodeType> & ISelectableNode, GraphType extends ISelectableGraph<NodeType>> void selectSuccessors(GraphType GraphType2, NodeType NodeType2) {
        GraphType2.selectNodes(GraphAlgorithms.getSuccessors(NodeType2), true);
    }

    public static <NodeType extends IGraphNode<NodeType> & ISelectableNode> void selectSuccessorsOfSelection(ISelectableGraph<NodeType> iSelectableGraph) {
        iSelectableGraph.selectNodes(GraphHelpers.getSuccessorsOfSelection(iSelectableGraph), true);
    }

    public static <NodeType extends IGraphNode<NodeType> & ISelectableNode> void shrinkSelectionDown(ISelectableGraph<NodeType> iSelectableGraph) {
        final ArrayList arrayList = new ArrayList();
        iSelectableGraph.iterateSelected(new INodeCallback<NodeType>(){

            @Override
            public IterationMode next(NodeType NodeType2) {
                if (GraphHelpers.areAllParentsDeselected(NodeType2) && !arrayList.contains(NodeType2)) {
                    arrayList.add(NodeType2);
                }
                return IterationMode.CONTINUE;
            }
        });
        iSelectableGraph.selectNodes(arrayList, false);
    }

    public static <NodeType extends IGraphNode<NodeType> & ISelectableNode> void shrinkSelectionUp(ISelectableGraph<NodeType> iSelectableGraph) {
        final ArrayList arrayList = new ArrayList();
        iSelectableGraph.iterateSelected(new INodeCallback<NodeType>(){

            @Override
            public IterationMode next(NodeType NodeType2) {
                if (GraphHelpers.areAllChildrenDeselected(NodeType2) && !arrayList.contains(NodeType2)) {
                    arrayList.add(NodeType2);
                }
                return IterationMode.CONTINUE;
            }
        });
        iSelectableGraph.selectNodes(arrayList, false);
    }

    public static <NodeType extends ISelectableNode, GraphType extends ISelectableGraph<NodeType> & IZoomableGraph<NodeType>> void zoomToSelected(GraphType GraphType2) {
        IFilledList<NodeType> iFilledList = GraphHelpers.getSelectedNodes(GraphType2);
        if (iFilledList.size() == 0) {
            throw new IllegalStateException("Error: There are no selected nodes");
        }
        ((IZoomableGraph<NodeType>)GraphType2).zoomToNodes(iFilledList);
    }
}

