/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.helpers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.general.ClipboardHelpers;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLineContent;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.IZyNodeRealizer;

public final class ClipboardCopier {
    public static void copyToClipboard(ZyGraphNode<?> zyGraphNode) {
        Preconditions.checkNotNull(zyGraphNode, "Error: Node argument can not be null");
        IZyNodeRealizer iZyNodeRealizer = zyGraphNode.getRealizer();
        ZyLabelContent zyLabelContent = iZyNodeRealizer.getNodeContent();
        if (zyLabelContent.isSelectable()) {
            ZyLabelContent zyLabelContent2 = zyLabelContent;
            StringBuilder stringBuilder = new StringBuilder();
            for (ZyLineContent zyLineContent : zyLabelContent2) {
                stringBuilder.append(zyLineContent.getText());
                stringBuilder.append("\n");
            }
            ClipboardHelpers.copyToClipboard(stringBuilder.toString());
        }
    }

    public static void copyToClipboard(ZyGraphNode<?> zyGraphNode, int n2) {
        Preconditions.checkNotNull(zyGraphNode, "Error: Node argument can not be null");
        IZyNodeRealizer iZyNodeRealizer = zyGraphNode.getRealizer();
        ZyLabelContent zyLabelContent = iZyNodeRealizer.getNodeContent();
        Preconditions.checkArgument(n2 >= 0 && n2 < zyLabelContent.getLineCount(), "Error: Line argument is out of bounds");
        if (zyLabelContent.isSelectable()) {
            ZyLabelContent zyLabelContent2 = zyLabelContent;
            ClipboardHelpers.copyToClipboard(zyLabelContent2.getLineContent(n2).getText());
        }
    }
}

