/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.edges;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.zygraph.edges.CBend;
import com.google.security.zynamics.zylib.gui.zygraph.edges.EdgeType;
import com.google.security.zynamics.zylib.gui.zygraph.edges.IViewEdge;
import com.google.security.zynamics.zylib.gui.zygraph.edges.IViewEdgeListener;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class CViewEdge<NodeType>
implements IViewEdge<NodeType> {
    private final NodeType m_sourceNode;
    private final NodeType m_targetNode;
    private EdgeType m_type;
    private double m_x1;
    private double m_y1;
    private double m_x2;
    private double m_y2;
    private Color m_color;
    private boolean m_visible;
    private boolean m_selected;
    private int m_id;
    private final List<CBend> m_paths;
    protected final ListenerProvider<IViewEdgeListener> m_listeners = new ListenerProvider();

    public CViewEdge(int n2, NodeType NodeType2, NodeType NodeType3, EdgeType edgeType, double d2, double d3, double d4, double d5, Color color, boolean bl2, boolean bl3, List<CBend> list) {
        this.m_sourceNode = Preconditions.checkNotNull(NodeType2, "Error: Source node argument can't be null");
        this.m_targetNode = Preconditions.checkNotNull(NodeType3, "Error: Target node argument can't be null");
        this.m_id = n2;
        this.m_type = edgeType;
        this.m_x1 = d2;
        this.m_y1 = d3;
        this.m_x2 = d4;
        this.m_y2 = d5;
        this.m_color = color;
        this.m_visible = bl3;
        this.m_selected = bl2;
        this.m_paths = list;
    }

    @Override
    public void addBend(double d2, double d3) {
        CBend cBend = new CBend(d2, d3);
        this.m_paths.add(cBend);
        for (IViewEdgeListener iViewEdgeListener : this.m_listeners) {
            try {
                iViewEdgeListener.addedBend(this, cBend);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void addListener(IViewEdgeListener iViewEdgeListener) {
        this.m_listeners.addListener(iViewEdgeListener);
    }

    @Override
    public void clearBends() {
        this.m_paths.clear();
        for (IViewEdgeListener iViewEdgeListener : this.m_listeners) {
            try {
                iViewEdgeListener.clearedBends(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public int getBendCount() {
        return this.m_paths.size();
    }

    @Override
    public List<CBend> getBends() {
        return new ArrayList<CBend>(this.m_paths);
    }

    @Override
    public Color getColor() {
        return this.m_color;
    }

    @Override
    public int getId() {
        return this.m_id;
    }

    @Override
    public NodeType getSource() {
        return this.m_sourceNode;
    }

    @Override
    public NodeType getTarget() {
        return this.m_targetNode;
    }

    @Override
    public EdgeType getType() {
        return this.m_type;
    }

    @Override
    public double getX1() {
        return this.m_x1;
    }

    @Override
    public double getX2() {
        return this.m_x2;
    }

    @Override
    public double getY1() {
        return this.m_y1;
    }

    @Override
    public double getY2() {
        return this.m_y2;
    }

    @Override
    public void insertBend(int n2, double d2, double d3) {
        CBend cBend = new CBend(d2, d3);
        this.m_paths.add(n2, cBend);
        for (IViewEdgeListener iViewEdgeListener : this.m_listeners) {
            try {
                iViewEdgeListener.insertedBend(this, n2, cBend);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public boolean isSelected() {
        return this.m_selected;
    }

    @Override
    public boolean isVisible() {
        return this.m_visible;
    }

    public void removeAllListeners() {
        ArrayList<IViewEdgeListener> arrayList = new ArrayList<IViewEdgeListener>();
        for (IViewEdgeListener iViewEdgeListener : this.m_listeners) {
            arrayList.add(iViewEdgeListener);
        }
        for (IViewEdgeListener iViewEdgeListener : arrayList) {
            this.removeListener(iViewEdgeListener);
        }
    }

    @Override
    public void removeBend(int n2) {
        CBend cBend = this.m_paths.get(n2);
        this.m_paths.remove(n2);
        for (IViewEdgeListener iViewEdgeListener : this.m_listeners) {
            iViewEdgeListener.removedBend(this, n2, cBend);
        }
    }

    @Override
    public void removeListener(IViewEdgeListener iViewEdgeListener) {
        this.m_listeners.removeListener(iViewEdgeListener);
    }

    @Override
    public void setColor(Color color) {
        Preconditions.checkNotNull(color, "Error: Color argument can not be null");
        if (this.m_color.equals(color)) {
            return;
        }
        this.m_color = color;
        for (IViewEdgeListener iViewEdgeListener : this.m_listeners) {
            iViewEdgeListener.changedColor(this, color);
        }
    }

    @Override
    public void setEdgeType(EdgeType edgeType) {
        Preconditions.checkNotNull(edgeType, "Error: Type argument can't be null");
        if (edgeType == this.m_type) {
            return;
        }
        this.m_type = edgeType;
        for (IViewEdgeListener iViewEdgeListener : this.m_listeners) {
            iViewEdgeListener.changedType(this, edgeType);
        }
    }

    @Override
    public void setId(int n2) {
        this.m_id = n2;
    }

    @Override
    public void setSelected(boolean bl2) {
        if (this.m_selected == bl2) {
            return;
        }
        this.m_selected = bl2;
        for (IViewEdgeListener iViewEdgeListener : this.m_listeners) {
            iViewEdgeListener.changedSelection(this, bl2);
        }
    }

    @Override
    public void setVisible(boolean bl2) {
        if (this.m_visible == bl2) {
            return;
        }
        this.m_visible = bl2;
        for (IViewEdgeListener iViewEdgeListener : this.m_listeners) {
            iViewEdgeListener.changedVisibility(this, this.m_visible);
        }
    }

    @Override
    public void setX1(double d2) {
        if (Double.compare(this.m_x1, d2) == 0) {
            return;
        }
        this.m_x1 = d2;
        for (IViewEdgeListener iViewEdgeListener : this.m_listeners) {
            iViewEdgeListener.changedSourceX(this, d2);
        }
    }

    @Override
    public void setX2(double d2) {
        if (Double.compare(this.m_x2, d2) == 0) {
            return;
        }
        this.m_x2 = d2;
        for (IViewEdgeListener iViewEdgeListener : this.m_listeners) {
            iViewEdgeListener.changedTargetX(this, d2);
        }
    }

    @Override
    public void setY1(double d2) {
        if (Double.compare(this.m_y1, d2) == 0) {
            return;
        }
        this.m_y1 = d2;
        for (IViewEdgeListener iViewEdgeListener : this.m_listeners) {
            iViewEdgeListener.changedSourceY(this, d2);
        }
    }

    @Override
    public void setY2(double d2) {
        if (Double.compare(this.m_y2, d2) == 0) {
            return;
        }
        this.m_y2 = d2;
        for (IViewEdgeListener iViewEdgeListener : this.m_listeners) {
            iViewEdgeListener.changedTargetY(this, d2);
        }
    }
}

