/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.tables;

import com.google.security.zynamics.zylib.general.comparators.LexicalComparator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

@Deprecated
public class CTableSorter
extends AbstractTableModel {
    private static final long serialVersionUID = -6803591209710987100L;
    public static final int DESCENDING = -1;
    public static final int NOT_SORTED = 0;
    public static final int ASCENDING = 1;
    public static final Directive EMPTY_DIRECTIVE = new Directive(-1, 0);
    public static final Comparator<Object> COMPARABLE_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object object, Object object2) {
            return ((Comparable)object).compareTo(object2);
        }
    };
    protected TableModel tableModel;
    protected Row[] viewToModel;
    protected int[] modelToView;
    protected JTableHeader tableHeader;
    protected MouseListener mouseListener;
    protected TableModelListener tableModelListener;
    protected Map<Class, Comparator> columnComparators = new HashMap<Class, Comparator>();
    protected HashMap<Integer, Comparator> primaryColumnComparator = new HashMap();
    protected List<Directive> sortingColumns = new ArrayList<Directive>();

    public CTableSorter() {
        this.mouseListener = new MouseHandler();
        this.tableModelListener = new TableModelHandler();
    }

    public CTableSorter(TableModel tableModel) {
        this();
        this.setTableModel(tableModel);
    }

    public CTableSorter(TableModel tableModel, JTableHeader jTableHeader) {
        this();
        this.setTableHeader(jTableHeader);
        this.setTableModel(tableModel);
    }

    private Directive getDirective(int n2) {
        for (int i2 = 0; i2 < this.sortingColumns.size(); ++i2) {
            Directive directive = this.sortingColumns.get(i2);
            if (directive.column != n2) continue;
            return directive;
        }
        return EMPTY_DIRECTIVE;
    }

    private Row[] getViewToModel() {
        if (this.viewToModel == null) {
            int n2 = this.tableModel.getRowCount();
            this.viewToModel = new Row[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.viewToModel[i2] = new Row(i2);
            }
            if (this.isSorting()) {
                Arrays.sort(this.viewToModel);
            }
        }
        return this.viewToModel;
    }

    private void sortingStatusChanged() {
        this.clearSortingState();
        this.fireTableDataChanged();
        if (this.tableHeader != null) {
            this.tableHeader.repaint();
        }
    }

    protected void cancelSorting() {
        this.sortingColumns.clear();
        this.sortingStatusChanged();
    }

    protected void clearSortingState() {
        this.viewToModel = null;
        this.modelToView = null;
    }

    protected Comparator<Object> getComparator(int n2) {
        Class<?> clazz = this.tableModel.getColumnClass(n2);
        Comparator comparator = this.primaryColumnComparator.get(n2);
        if (comparator != null) {
            return comparator;
        }
        comparator = this.columnComparators.get(clazz);
        if (comparator != null) {
            return comparator;
        }
        if (clazz.equals(String.class)) {
            return new LexicalComparator();
        }
        if (Comparable.class.isAssignableFrom(clazz)) {
            return COMPARABLE_COMPARATOR;
        }
        return new LexicalComparator();
    }

    protected Icon getHeaderRendererIcon(int n2, int n3) {
        Directive directive = this.getDirective(n2);
        if (directive == EMPTY_DIRECTIVE) {
            return null;
        }
        return new Arrow(directive.direction == -1, n3, this.sortingColumns.indexOf(directive));
    }

    protected int[] getModelToView() {
        if (this.modelToView == null) {
            int n2 = this.getViewToModel().length;
            this.modelToView = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.modelToView[this.modelIndex((int)i2)] = i2;
            }
        }
        return this.modelToView;
    }

    public Class getColumnClass(int n2) {
        return this.tableModel.getColumnClass(n2);
    }

    @Override
    public int getColumnCount() {
        return this.tableModel == null ? 0 : this.tableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int n2) {
        return this.tableModel.getColumnName(n2);
    }

    @Override
    public int getRowCount() {
        return this.tableModel == null ? 0 : this.tableModel.getRowCount();
    }

    public int getSortingStatus(int n2) {
        return this.getDirective((int)n2).direction;
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        return this.tableModel.getValueAt(this.modelIndex(n2), n3);
    }

    @Override
    public boolean isCellEditable(int n2, int n3) {
        return this.tableModel.isCellEditable(this.modelIndex(n2), n3);
    }

    public boolean isSorting() {
        return this.sortingColumns.size() != 0;
    }

    public int modelIndex(int n2) {
        if (n2 >= 0) {
            return this.getViewToModel()[n2].modelIndex;
        }
        return 0;
    }

    public void setColumnComparator(Class clazz, Comparator<Object> comparator) {
        if (comparator == null) {
            this.columnComparators.remove(clazz);
        } else {
            this.columnComparators.put(clazz, comparator);
        }
    }

    public void setColumnComparator(int n2, Comparator comparator) {
        if (comparator != null) {
            this.primaryColumnComparator.put(n2, comparator);
        }
    }

    public void setSortingStatus(int n2, int n3) {
        Directive directive = this.getDirective(n2);
        if (directive != EMPTY_DIRECTIVE) {
            this.sortingColumns.remove(directive);
        }
        if (n3 != 0) {
            this.sortingColumns.add(new Directive(n2, n3));
        }
        this.sortingStatusChanged();
    }

    public void setTableHeader(JTableHeader jTableHeader) {
        if (this.tableHeader != null) {
            this.tableHeader.removeMouseListener(this.mouseListener);
            TableCellRenderer tableCellRenderer = this.tableHeader.getDefaultRenderer();
            if (tableCellRenderer instanceof SortableHeaderRenderer) {
                this.tableHeader.setDefaultRenderer(((SortableHeaderRenderer)tableCellRenderer).tableCellRenderer);
            }
        }
        this.tableHeader = jTableHeader;
        if (this.tableHeader != null) {
            this.tableHeader.addMouseListener(this.mouseListener);
            this.tableHeader.setDefaultRenderer(new SortableHeaderRenderer(this.tableHeader.getDefaultRenderer()));
        }
    }

    public void setTableModel(TableModel tableModel) {
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this.tableModelListener);
        }
        this.tableModel = tableModel;
        if (this.tableModel != null) {
            this.tableModel.addTableModelListener(this.tableModelListener);
        }
        this.clearSortingState();
        this.fireTableStructureChanged();
    }

    @Override
    public void setValueAt(Object object, int n2, int n3) {
        this.tableModel.setValueAt(object, this.modelIndex(n2), n3);
    }

    public int viewIndex(int n2) {
        if (n2 >= 0) {
            return this.getModelToView()[n2];
        }
        return 0;
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (!CTableSorter.this.isSorting()) {
                CTableSorter.this.clearSortingState();
                CTableSorter.this.fireTableChanged(tableModelEvent);
                return;
            }
            if (tableModelEvent.getFirstRow() == -1) {
                CTableSorter.this.cancelSorting();
                CTableSorter.this.fireTableChanged(tableModelEvent);
                return;
            }
            int n2 = tableModelEvent.getColumn();
            if (tableModelEvent.getFirstRow() == tableModelEvent.getLastRow() && n2 != -1 && CTableSorter.this.getSortingStatus(n2) == 0 && CTableSorter.this.modelToView != null) {
                int n3 = CTableSorter.this.getModelToView()[tableModelEvent.getFirstRow()];
                CTableSorter.this.fireTableChanged(new TableModelEvent(CTableSorter.this, n3, n3, n2, tableModelEvent.getType()));
                return;
            }
            CTableSorter.this.clearSortingState();
            CTableSorter.this.fireTableDataChanged();
        }
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer {
        protected TableCellRenderer tableCellRenderer;

        public SortableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.tableCellRenderer = tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            Component component = this.tableCellRenderer.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                jLabel.setHorizontalTextPosition(2);
                int n4 = jTable.convertColumnIndexToModel(n3);
                jLabel.setIcon(CTableSorter.this.getHeaderRendererIcon(n4, jLabel.getFont().getSize()));
            }
            return component;
        }
    }

    private class Row
    implements Comparable<Object> {
        protected int modelIndex;

        public Row(int n2) {
            this.modelIndex = n2;
        }

        @Override
        public int compareTo(Object object) {
            int n2 = this.modelIndex;
            int n3 = ((Row)object).modelIndex;
            Iterator<Directive> iterator = CTableSorter.this.sortingColumns.iterator();
            while (iterator.hasNext()) {
                Directive directive;
                Directive directive2 = directive = iterator.next();
                int n4 = directive2.column;
                Object object2 = CTableSorter.this.tableModel.getValueAt(n2, n4);
                Object object3 = CTableSorter.this.tableModel.getValueAt(n3, n4);
                int n5 = 0;
                n5 = object2 == null && object3 == null ? 0 : (object2 == null ? -1 : (object3 == null ? 1 : CTableSorter.this.getComparator(n4).compare(object2, object3)));
                if (n5 == 0) continue;
                return directive2.direction == -1 ? -n5 : n5;
            }
            return 0;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n2;
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
            int n3 = tableColumnModel.getColumn(n2 = tableColumnModel.getColumnIndexAtX(mouseEvent.getX())).getModelIndex();
            if (n3 != -1) {
                int n4 = CTableSorter.this.getSortingStatus(n3);
                if (!mouseEvent.isControlDown()) {
                    CTableSorter.this.cancelSorting();
                }
                n4 += mouseEvent.isShiftDown() ? -1 : 1;
                n4 = (n4 + 4) % 3 - 1;
                CTableSorter.this.setSortingStatus(n3, n4);
            }
        }
    }

    private static class Directive {
        protected int column;
        protected int direction;

        public Directive(int n2, int n3) {
            this.column = n2;
            this.direction = n3;
        }
    }

    private static class Arrow
    implements Icon {
        private final boolean descending;
        private final int size;
        private final int priority;

        public Arrow(boolean bl2, int n2, int n3) {
            this.descending = bl2;
            this.size = n2;
            this.priority = n3;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            Color color = component == null ? Color.GRAY : component.getBackground();
            int n4 = (int)((double)(this.size / 2) * Math.pow(0.8, this.priority));
            int n5 = this.descending ? n4 : -n4;
            n3 = n3 + 5 * this.size / 6 + (this.descending ? -n5 : 0);
            int n6 = this.descending ? 1 : -1;
            graphics.translate(n2, n3);
            graphics.setColor(color.darker());
            graphics.drawLine(n4 / 2, n5, 0, 0);
            graphics.drawLine(n4 / 2, n5 + n6, 0, n6);
            graphics.setColor(color.brighter());
            graphics.drawLine(n4 / 2, n5, n4, 0);
            graphics.drawLine(n4 / 2, n5 + n6, n4, n6);
            if (this.descending) {
                graphics.setColor(color.darker().darker());
            } else {
                graphics.setColor(color.brighter().brighter());
            }
            graphics.drawLine(n4, 0, 0, 0);
            graphics.setColor(color);
            graphics.translate(-n2, -n3);
        }
    }
}

