/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.scripting.console;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CEndlessProgressDialog;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.IEndlessProgressListener;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.IEndlessProgressModel;
import com.google.security.zynamics.zylib.gui.scripting.AbstractScriptPanel;
import com.google.security.zynamics.zylib.gui.scripting.ConsoleWriter;
import com.google.security.zynamics.zylib.gui.scripting.IScriptConsole;
import com.google.security.zynamics.zylib.gui.scripting.InitStringFactory;
import com.google.security.zynamics.zylib.gui.scripting.console.ConsoleCodeDocument;
import com.google.security.zynamics.zylib.io.FileUtils;
import java.awt.BorderLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;

public class ConsolePane
extends AbstractScriptPanel {
    private static final long serialVersionUID = 3114171042368746418L;
    private final KeyListener m_KeyListener = new InterpreterKeyListener();
    private int m_HistoryPosition = 0;
    private final ArrayList<String> m_LineHistory = new ArrayList();
    private String m_SavedTypedLine = "";
    private final TabCompletionManager m_tabCompletion = new TabCompletionManager();
    private static final boolean m_IsMultilineInput = false;
    private int m_LastAutoCompleteChunkLength = 0;
    private String m_CurrentPrompt;
    private String consoleName;
    private String currentLanguage;
    private IScriptConsole console;
    private ArrayList<Pair<String, Object>> realBindings;
    private ScriptEngine engine;
    private String buffered = "";
    private final TreeSet<String> candidates;
    private String m_libraryPath;

    public ConsolePane() {
        super(new BorderLayout());
        this.updateDocument();
        this.candidates = new TreeSet<String>(this.getDocument().getTabCompletionWords());
        this.getInputPane().addKeyListener(this.m_KeyListener);
        this.getDocument().setInputKeyListener(this.m_KeyListener);
        this.getOutputPane().setFont(GuiHelper.getMonospacedFont());
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    private void executeInitializer() {
        if (this.m_libraryPath == null) {
            return;
        }
        List<String> list = this.engine.getFactory().getExtensions();
        for (String string : list) {
            String string2 = this.m_libraryPath + File.separator + "init." + string;
            if (!FileUtils.exists(string2)) continue;
            try {
                this.engine.eval(FileUtils.readTextfile(string2));
                this.getOutputPane().setText(this.console.getOutput());
            }
            catch (ScriptException scriptException) {
                this.getOutputPane().setText(scriptException.getLocalizedMessage());
            }
            catch (IOException iOException) {
                this.getOutputPane().setText(iOException.getLocalizedMessage());
            }
        }
    }

    private int getCurrentInputLine() {
        return this.getDocument().getLineStartOffset(this.getInputPane().getCaretPosition());
    }

    private String getCurrentLine() {
        int n2 = this.getInputPane().getCaretPosition();
        String string = null;
        int n3 = this.m_CurrentPrompt.length();
        string = n3 < (string = this.getDocument().getCurrentLine(n2).trim()).length() ? string.substring(n3, string.length()) : "";
        return string;
    }

    private ConsoleCodeDocument getDocument() {
        return (ConsoleCodeDocument)this.getInputPane().getDocument();
    }

    private int getLastInputLine() {
        return this.getDocument().getLineStartOffset(this.getInputPane().getText().length());
    }

    private void goToLastLine() {
        this.getInputPane().setCaretPosition(this.getInputPane().getText().length());
    }

    private void interpreterNewLine(boolean bl2) {
        int n2;
        int n3 = this.getInputPane().getCaretPosition();
        if (n3 == 0) {
            n2 = 0;
        } else {
            this.getDocument().insertChar(n3, "\n");
            n2 = n3 + 1;
        }
        this.m_CurrentPrompt = bl2 ? "... " : ">>> ";
        this.getDocument().insertPrompt(n2, this.m_CurrentPrompt);
        this.getInputPane().setCaretPosition(n2 + this.m_CurrentPrompt.length());
    }

    private void setCurrentLine(String string) {
        this.goToLastLine();
        this.getDocument().setCurrentLine(this.getInputPane().getCaretPosition(), this.m_CurrentPrompt.length(), string);
    }

    @Override
    protected void initConsole() {
        this.currentLanguage = this.getSelectedLanguage();
        this.console = new ConsoleWriter(new StringWriter());
        this.buffered = InitStringFactory.getInitString(this.currentLanguage, this.consoleName, this.m_libraryPath);
        this.realBindings = this.getBindings();
        if (this.consoleName != null) {
            this.realBindings.add(new Pair<String, IScriptConsole>(this.consoleName, this.console));
        }
        if (this.currentLanguage == null) {
            return;
        }
        this.engine = this.getManager().getEngineByName(this.currentLanguage);
        Preconditions.checkNotNull(this.engine, "Error: Unknown scripting language");
        this.engine.getContext().setWriter(this.console.getWriter());
        for (Pair<String, Object> pair : this.realBindings) {
            this.engine.put(pair.first(), pair.second());
        }
        this.executeInitializer();
    }

    @Override
    protected void updateDocument() {
        this.getInputPane().setDocument(new ConsoleCodeDocument());
        this.interpreterNewLine(false);
    }

    public void setConsoleName(String string) {
        this.consoleName = string;
        this.initConsole();
        this.updateDocument();
    }

    public void setLibraryPath(String string) {
        this.m_libraryPath = string;
        this.initConsole();
        this.updateDocument();
    }

    private class TabCompletionManager {
        private int m_completionIndex = 0;

        private TabCompletionManager() {
        }

        private String getCompletionCandidate(String[] stringArray, String string, int n2) {
            boolean bl2 = false;
            for (String string2 : stringArray) {
                if (!string2.startsWith(string)) continue;
                bl2 = true;
                if (n2 == 0) {
                    ++this.m_completionIndex;
                    return string2;
                }
                --n2;
            }
            if (bl2) {
                return this.getCompletionCandidate(stringArray, string, n2);
            }
            return null;
        }

        public String getCompletion(String string) {
            return this.getCompletionCandidate(ConsolePane.this.candidates.toArray(new String[0]), string, this.m_completionIndex);
        }

        public void reset() {
            this.m_completionIndex = 0;
        }
    }

    private class InterpreterKeyListener
    extends KeyAdapter {
        private InterpreterKeyListener() {
        }

        private void execute() {
            InternalScriptRunner internalScriptRunner = new InternalScriptRunner();
            CEndlessProgressDialog cEndlessProgressDialog = new CEndlessProgressDialog(null, ConsolePane.this.getProgressWindowTitle(), "Running script", internalScriptRunner);
            internalScriptRunner.run();
            cEndlessProgressDialog.setVisible(true);
            if (internalScriptRunner.quitProperly()) {
                ConsolePane.this.getOutputPane().setText(ConsolePane.this.console.getOutput());
            }
        }

        private void handleBackspace(KeyEvent keyEvent) {
            if (ConsolePane.this.getInputPane().getSelectionStart() == ConsolePane.this.getInputPane().getSelectionEnd() && ConsolePane.this.getDocument().getCaretOffsetInLine(ConsolePane.this.getInputPane().getCaretPosition()) <= ConsolePane.this.m_CurrentPrompt.length()) {
                keyEvent.consume();
            }
        }

        private void handleDownKey(KeyEvent keyEvent) {
            if (ConsolePane.this.m_HistoryPosition < ConsolePane.this.m_LineHistory.size() - 1) {
                ConsolePane.this.setCurrentLine((String)ConsolePane.this.m_LineHistory.get(++ConsolePane.this.m_HistoryPosition));
            } else if (ConsolePane.this.m_HistoryPosition == ConsolePane.this.m_LineHistory.size() - 1) {
                ConsolePane.this.m_HistoryPosition++;
                ConsolePane.this.setCurrentLine(ConsolePane.this.m_SavedTypedLine);
            }
            keyEvent.consume();
        }

        private void handleEnter(KeyEvent keyEvent) {
            ConsolePane.this.goToLastLine();
            String string = ConsolePane.this.getCurrentLine();
            ConsolePane.this.buffered = ConsolePane.this.buffered + (string + "\n");
            ConsolePane.this.m_SavedTypedLine = "";
            if (keyEvent.isControlDown()) {
                this.execute();
                ConsolePane.this.buffered = InitStringFactory.getInitString(ConsolePane.this.currentLanguage, ConsolePane.this.consoleName, ConsolePane.this.m_libraryPath);
                ConsolePane.this.getOutputDocument().flip();
                if (string.trim().length() > 0) {
                    ConsolePane.this.m_LineHistory.add(string);
                }
                ConsolePane.this.m_HistoryPosition = ConsolePane.this.m_LineHistory.size();
                ConsolePane.this.interpreterNewLine(false);
            } else {
                if (string.trim().length() > 0) {
                    ConsolePane.this.m_LineHistory.add(string);
                }
                ConsolePane.this.m_HistoryPosition = ConsolePane.this.m_LineHistory.size();
                ConsolePane.this.interpreterNewLine(true);
                ConsolePane.this.getOutputDocument().flip();
            }
            ConsolePane.this.getDocument().flushRemainingText(ConsolePane.this.getInputPane().getText().length());
            keyEvent.consume();
        }

        private void handleTabKey(KeyEvent keyEvent) {
            String string;
            int n2 = ConsolePane.this.getInputPane().getCaretPosition() - ConsolePane.this.m_LastAutoCompleteChunkLength;
            String string2 = ConsolePane.this.getDocument().getWord(n2);
            if (string2.length() > 0 && (string = ConsolePane.this.m_tabCompletion.getCompletion(string2)) != null) {
                String string3 = string.substring(string2.length(), string.length());
                try {
                    ConsolePane.this.getDocument().remove(n2, ConsolePane.this.m_LastAutoCompleteChunkLength);
                    ConsolePane.this.getDocument().insertString(n2, string3, null);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
                ConsolePane.this.m_LastAutoCompleteChunkLength = string3.length();
                keyEvent.consume();
            }
        }

        private void handleUpKey(KeyEvent keyEvent) {
            if (ConsolePane.this.m_HistoryPosition > 0) {
                if (ConsolePane.this.m_HistoryPosition == ConsolePane.this.m_LineHistory.size()) {
                    ConsolePane.this.goToLastLine();
                    ConsolePane.this.m_SavedTypedLine = ConsolePane.this.getCurrentLine();
                }
                ConsolePane.this.setCurrentLine((String)ConsolePane.this.m_LineHistory.get(--ConsolePane.this.m_HistoryPosition));
            } else {
                ConsolePane.this.m_HistoryPosition = 0;
            }
            keyEvent.consume();
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n2;
            int n3 = ConsolePane.this.getLastInputLine();
            if (n3 != (n2 = ConsolePane.this.getCurrentInputLine())) {
                ConsolePane.this.goToLastLine();
            }
            if (keyEvent.getKeyCode() == 10) {
                this.handleEnter(keyEvent);
            } else if (keyEvent.getModifiers() == 0) {
                if (keyEvent.getKeyCode() == 38) {
                    this.handleUpKey(keyEvent);
                } else if (keyEvent.getKeyCode() == 40) {
                    this.handleDownKey(keyEvent);
                } else if (keyEvent.getKeyCode() == 9) {
                    this.handleTabKey(keyEvent);
                } else if (keyEvent.getKeyCode() == 8) {
                    this.handleBackspace(keyEvent);
                }
                if (keyEvent.getKeyCode() != 9) {
                    ConsolePane.this.m_tabCompletion.reset();
                    ConsolePane.this.m_LastAutoCompleteChunkLength = 0;
                }
            }
        }

        private class InternalScriptRunner
        implements IEndlessProgressModel {
            private final ListenerProvider<IEndlessProgressListener> listeners = new ListenerProvider();
            private Thread m_thread;
            private boolean quitProperly = true;

            private InternalScriptRunner() {
            }

            @Override
            public void addProgressListener(IEndlessProgressListener iEndlessProgressListener) {
                this.listeners.addListener(iEndlessProgressListener);
            }

            @Override
            public void closeRequested() {
                this.m_thread.stop();
                for (IEndlessProgressListener iEndlessProgressListener : this.listeners) {
                    iEndlessProgressListener.finished();
                }
            }

            public boolean quitProperly() {
                return this.quitProperly;
            }

            @Override
            public void removeProgressListener(IEndlessProgressListener iEndlessProgressListener) {
                this.listeners.removeListener(iEndlessProgressListener);
            }

            public void run() {
                this.m_thread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            ConsolePane.this.engine.eval(ConsolePane.this.buffered);
                        }
                        catch (ScriptException scriptException) {
                            ConsolePane.this.getOutputPane().setText(scriptException.getLocalizedMessage());
                            InternalScriptRunner.this.quitProperly = false;
                        }
                        for (IEndlessProgressListener iEndlessProgressListener : InternalScriptRunner.this.listeners) {
                            iEndlessProgressListener.finished();
                        }
                    }
                };
                this.m_thread.start();
            }
        }
    }
}

