/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.scripting.console;

import com.google.security.zynamics.zylib.gui.scripting.SyntaxDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;

public class ConsoleHelpers {
    private final SyntaxDocument document;
    private final MutableAttributeSet normal;

    public ConsoleHelpers(SyntaxDocument syntaxDocument, MutableAttributeSet mutableAttributeSet) {
        this.document = syntaxDocument;
        this.normal = mutableAttributeSet;
    }

    public int getCaretOffsetInLine(int n2) {
        return n2 - this.document.getParagraphElement(n2).getStartOffset();
    }

    public String getCurrentLine(int n2) {
        Element element = this.document.getParagraphElement(n2);
        String string = "";
        try {
            string = this.document.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
        }
        catch (BadLocationException badLocationException) {
            System.out.println("Bad location!");
            badLocationException.printStackTrace();
        }
        return string;
    }

    public int getLineStartOffset(int n2) {
        return this.document.getParagraphElement(n2).getStartOffset();
    }

    public MutableAttributeSet getNormal() {
        return this.normal;
    }

    public String getWord(int n2) {
        String string;
        int n3 = n2;
        Element element = this.document.getParagraphElement(n3);
        try {
            string = this.document.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
        }
        catch (Exception exception) {
            return "";
        }
        int n4 = string.length();
        if (n4 == 0) {
            return "";
        }
        int n5 = 0;
        if (element.getStartOffset() > 0) {
            n3 -= element.getStartOffset();
        }
        for (n5 = n3 - 1; n5 >= 0; --n5) {
            char c2 = string.charAt(n5);
            if (!this.document.isDelimiter("" + c2) && n5 != 0) continue;
            return string.substring(n5 + 1, n3).trim();
        }
        return "";
    }
}

