/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.scripting.console;

import com.google.security.zynamics.zylib.gui.scripting.CodeDocumentPython;
import com.google.security.zynamics.zylib.gui.scripting.console.ConsoleHelpers;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class ConsoleCodeDocument
extends CodeDocumentPython {
    private static final long serialVersionUID = -4854242616532427400L;
    private final SimpleAttributeSet pythonPromptAttr = new SimpleAttributeSet();
    private KeyListener inputKeyListener;
    private String remainingTextString = null;
    private AttributeSet remainingTextAttr = null;
    private final ConsoleHelpers helpers = new ConsoleHelpers(this, this.normal);

    public ConsoleCodeDocument() {
        super(false);
        this.putProperty("__EndOfLine__", "\n");
        StyleConstants.setForeground(this.pythonPromptAttr, Color.LIGHT_GRAY);
        StyleConstants.setBold(this.pythonPromptAttr, true);
        StyleConstants.setFontSize(this.pythonPromptAttr, 13);
    }

    public void flushRemainingText(int n2) {
        if (this.remainingTextString == null) {
            return;
        }
        try {
            this.insertString(n2, this.remainingTextString, this.remainingTextAttr);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.remainingTextString = null;
        this.remainingTextAttr = null;
    }

    public int getCaretOffsetInLine(int n2) {
        return this.helpers.getCaretOffsetInLine(n2);
    }

    public String getCurrentLine(int n2) {
        return this.helpers.getCurrentLine(n2);
    }

    public int getLineStartOffset(int n2) {
        return this.helpers.getLineStartOffset(n2);
    }

    public String getWord(int n2) {
        return this.helpers.getWord(n2);
    }

    public void insertChar(int n2, String string) {
        if (n2 < 0) {
            return;
        }
        try {
            super.insertString(n2, string, this.normal);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void insertPrompt(int n2, String string) {
        try {
            super.insertString(n2, string, this.pythonPromptAttr);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void insertString(int n2, String string, AttributeSet attributeSet) {
        if (n2 < 0) {
            return;
        }
        if (string.length() > 1) {
            for (int i2 = 0; i2 < string.length(); ++i2) {
                if (string.charAt(i2) == '\n') {
                    this.remainingTextString = string.substring(i2 + 1);
                    this.remainingTextAttr = attributeSet;
                    this.inputKeyListener.keyPressed(new KeyEvent(new Container(), 401, 0L, 0, 10, '\n'));
                    break;
                }
                this.insertChar(n2 + i2, "" + string.charAt(i2));
            }
        } else if (string.length() == 1) {
            this.insertChar(n2, string);
        }
    }

    public void setCurrentLine(int n2, int n3, String string) {
        Element element = this.getParagraphElement(n2);
        int n4 = element.getStartOffset();
        int n5 = element.getEndOffset();
        try {
            this.remove(n4 + n3, n5 - (n4 + n3 + 1));
            super.insertString(n4 + n3, string, this.normal);
        }
        catch (BadLocationException badLocationException) {
            System.out.println("Bad location!");
            badLocationException.printStackTrace();
        }
    }

    public void setInputKeyListener(KeyListener keyListener) {
        this.inputKeyListener = keyListener;
    }
}

