/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.scripting;

import com.google.security.zynamics.zylib.resources.Constants;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;

public abstract class ScriptingMenuBar
extends JMenuBar {
    private static final int CTRL_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private final CutAction cutAction = new CutAction();
    private final CopyAction copyAction = new CopyAction();
    private final PasteAction pasteAction = new PasteAction();
    private final ExecuteAgainAction executeAgainAction = new ExecuteAgainAction();
    private File lastExecutedFile = null;

    protected ScriptingMenuBar() {
        JMenu jMenu = new JMenu("File");
        jMenu.addSeparator();
        jMenu.add(new ExecuteAction());
        jMenu.add(this.executeAgainAction);
        jMenu.addSeparator();
        jMenu.add(new NewConsoleTabAction());
        jMenu.add(new CloseTabAction());
        this.add(jMenu);
        JMenu jMenu2 = new JMenu("Edit");
        jMenu2.addSeparator();
        jMenu2.add(this.cutAction);
        jMenu2.add(this.copyAction);
        jMenu2.add(this.pasteAction);
        this.add(jMenu2);
    }

    protected abstract void closeTabMenuClicked();

    protected abstract void copyMenuClicked();

    protected abstract void cutMenuClicked();

    protected abstract void executeAgainMenuClicked();

    protected abstract void executeMenuClicked();

    protected File getLastExecutedScriptFile() {
        return this.lastExecutedFile;
    }

    protected abstract void newConsoleTabMenuClicked();

    protected abstract void pasteMenuClicked();

    protected void setLastExecutedScriptFile(File file) {
        this.lastExecutedFile = file;
        this.executeAgainAction.setFile(file);
    }

    public void updateGui(boolean bl2) {
        this.cutAction.setEnabled(bl2);
        this.copyAction.setEnabled(bl2);
        this.pasteAction.setEnabled(bl2);
    }

    private class PasteAction
    extends AbstractAction {
        public PasteAction() {
            super("Paste");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, CTRL_MASK));
            this.putValue("SmallIcon", new ImageIcon(Constants.class.getResource("page_white_paste.png")));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ScriptingMenuBar.this.pasteMenuClicked();
        }
    }

    private class NewConsoleTabAction
    extends AbstractAction {
        public NewConsoleTabAction() {
            super("Open new console tab");
            this.putValue("SmallIcon", new ImageIcon(Constants.class.getResource("application_xp_terminal.png")));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ScriptingMenuBar.this.newConsoleTabMenuClicked();
        }
    }

    private class ExecuteAgainAction
    extends AbstractAction {
        public ExecuteAgainAction() {
            super(String.format("Execute last script file again (%s)", "-"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, CTRL_MASK | 1));
            this.setFile(null);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ScriptingMenuBar.this.executeAgainMenuClicked();
        }

        public void setFile(File file) {
            if (file != null) {
                this.putValue("Name", String.format("Execute last script file again (%s)", file.getAbsolutePath()));
            } else {
                this.putValue("Name", String.format("Execute last script file again (%s)", "-"));
            }
            this.setEnabled(file != null);
        }
    }

    private class ExecuteAction
    extends AbstractAction {
        public ExecuteAction() {
            super("Execute script file");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, CTRL_MASK));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ScriptingMenuBar.this.executeMenuClicked();
        }
    }

    private class CutAction
    extends AbstractAction {
        public CutAction() {
            super("Cut");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, CTRL_MASK));
            this.putValue("SmallIcon", new ImageIcon(Constants.class.getResource("cut.png")));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ScriptingMenuBar.this.cutMenuClicked();
        }
    }

    private class CopyAction
    extends AbstractAction {
        public CopyAction() {
            super("Copy");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, CTRL_MASK));
            this.putValue("SmallIcon", new ImageIcon(Constants.class.getResource("page_white_copy.png")));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ScriptingMenuBar.this.copyMenuClicked();
        }
    }

    private class CloseTabAction
    extends AbstractAction {
        public CloseTabAction() {
            super("Close active tab");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(81, CTRL_MASK));
            this.putValue("SmallIcon", new ImageIcon(Constants.class.getResource("folder_delete.png")));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ScriptingMenuBar.this.closeTabMenuClicked();
        }
    }
}

