/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.scripting;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.scripting.IScriptConsole;
import com.google.security.zynamics.zylib.io.FileUtils;
import java.io.File;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public class ScriptRunner {
    private static final ScriptEngineManager manager = new ScriptEngineManager();

    public static boolean canRun(File file) {
        return manager.getEngineByExtension(FileUtils.getFileExtension(file)) != null;
    }

    public static void runPythonScript(String string, List<Pair<String, Object>> list) {
        ScriptEngine scriptEngine = manager.getEngineByName("python");
        ScriptRunner.runScript(scriptEngine, string, list);
    }

    public static void runScript(File file, List<Pair<String, Object>> list) {
        ScriptEngine scriptEngine = manager.getEngineByExtension(FileUtils.getFileExtension(file));
        Preconditions.checkNotNull(scriptEngine, "Error: Script %s has an unknown extension.", (Object)file.getAbsolutePath());
        String string = FileUtils.readTextfile(file);
        ScriptRunner.runScript(scriptEngine, string, list);
    }

    public static void runScript(ScriptEngine scriptEngine, File file, List<Pair<String, Object>> list) {
        Preconditions.checkNotNull(scriptEngine, "Error: Script %s has an unknown extension.", (Object)file.getAbsolutePath());
        String string = FileUtils.readTextfile(file);
        ScriptRunner.runScript(scriptEngine, string, list);
    }

    public static Object runScript(ScriptEngine scriptEngine, String string, List<Pair<String, Object>> list) {
        for (Pair<String, Object> pair : list) {
            scriptEngine.put(pair.first(), pair.second());
        }
        return scriptEngine.eval(string);
    }

    public static void runScript(String string, String string2, List<Pair<String, Object>> list, IScriptConsole iScriptConsole) {
        ScriptEngine scriptEngine = manager.getEngineByName(string);
        Preconditions.checkNotNull(scriptEngine, "Error: Unknown scripting language");
        scriptEngine.getContext().setWriter(iScriptConsole.getWriter());
        ScriptRunner.runScript(scriptEngine, string2, list);
    }
}

