/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.license;

import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CEndlessHelperThread;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CEndlessProgressDialog;
import com.google.security.zynamics.zylib.io.StreamUtils;
import java.awt.Window;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;

public class UpdateCheckHelper {
    public static final String UPDATE_CHECK_BASE_URL = "https://www.zynamics.com/updates";

    private UpdateCheckHelper() {
    }

    public static void checkForUpdatesWithUi(Window window, String string, String string2) {
        UpdateCheckHelper.checkForUpdatesWithUi(window, string, string2, "stable");
    }

    public static void checkForUpdatesWithUi(Window window, String string, String string2, String string3) {
        URL uRL;
        try {
            uRL = new URL(String.format("%s/%s/%s", UPDATE_CHECK_BASE_URL, string.toLowerCase(), string3.toLowerCase()));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Malformed URL template", malformedURLException);
        }
        final ArrayList arrayList = new ArrayList();
        CEndlessHelperThread cEndlessHelperThread = new CEndlessHelperThread(){

            @Override
            protected void runExpensiveCommand() {
                long l2 = new Date().getTime();
                arrayList.addAll(StreamUtils.readLinesFromReader(new InputStreamReader(uRL.openStream(), StandardCharsets.UTF_8)));
                long l3 = new Date().getTime() - l2;
                if (l3 < 400L) {
                    Thread.sleep(400L - l3);
                }
            }
        };
        CEndlessProgressDialog.show(window, System.getProperty(CMessageBox.DEFAULT_WINDOW_TITLE_PROPERTY), "Checking for updates...", cEndlessHelperThread);
        Exception exception = cEndlessHelperThread.getException();
        if (exception instanceof FileNotFoundException) {
            CMessageBox.showWarning(window, "Could not check for updates. The update site is unavailable.");
            return;
        }
        if (arrayList.isEmpty()) {
            CMessageBox.showWarning(window, "Could not check for updates. The update site returned no data.");
            return;
        }
        if (arrayList.size() < 2 || !((String)arrayList.get(1)).matches("\\d{4}-\\d\\d-\\d\\d")) {
            CMessageBox.showWarning(window, "Could not check for updates. Could not parse the response.");
            return;
        }
        String string4 = (String)arrayList.get(0);
        int n2 = UpdateCheckHelper.versionCompare(string2, string4);
        if (n2 < 0) {
            CMessageBox.showInformation(window, String.format("A newer version (%s) is available.", string4));
            return;
        }
        CMessageBox.showInformation(window, String.format("Your version of zynamics %s is up to date.", string));
    }

    private static int versionCompare(String string, String string2) {
        String[] stringArray = string.trim().split("\\.|-|\\s+");
        String[] stringArray2 = string2.trim().split("\\.|-|\\s+");
        int n2 = 0;
        for (int i2 = 0; n2 == 0 && i2 < Math.min(stringArray.length, stringArray2.length); ++i2) {
            try {
                n2 = Integer.parseInt(stringArray[i2]) - Integer.parseInt(stringArray2[i2]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                n2 = stringArray[i2].compareToIgnoreCase(stringArray2[i2]);
            }
        }
        return n2 < -1 ? -1 : (n2 > 1 ? 1 : n2);
    }
}

