/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.jtree;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeHelpers {
    private static void expandAll(JTree jTree, TreePath treePath, boolean bl2) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (treeNode.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode2 = enumeration.nextElement();
                TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                TreeHelpers.expandAll(jTree, treePath2, bl2);
            }
        }
        if (bl2) {
            jTree.expandPath(treePath);
        } else {
            jTree.collapsePath(treePath);
        }
    }

    private static boolean isDescendant(TreePath treePath, TreePath treePath2) {
        int n2;
        int n3 = treePath.getPathCount();
        if (n3 <= (n2 = treePath2.getPathCount())) {
            return false;
        }
        while (n3 != n2) {
            treePath = treePath.getParentPath();
            --n3;
        }
        return treePath.equals(treePath2);
    }

    public static boolean contains(JTree jTree, TreeNode treeNode) {
        return TreeHelpers.isAncestor(treeNode, (TreeNode)jTree.getModel().getRoot());
    }

    public static void expandAll(JTree jTree, boolean bl2) {
        TreeNode treeNode = (TreeNode)jTree.getModel().getRoot();
        TreeHelpers.expandAll(jTree, new TreePath(treeNode), bl2);
    }

    public static String getExpansionState(JTree jTree, int n2) {
        TreePath treePath = jTree.getPathForRow(n2);
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = jTree.getRowCount();
        for (int i2 = n2; i2 < n3; ++i2) {
            TreePath treePath2 = jTree.getPathForRow(i2);
            if (i2 != n2 && !TreeHelpers.isDescendant(treePath2, treePath)) break;
            if (!jTree.isExpanded(treePath2)) continue;
            stringBuffer.append(",");
            stringBuffer.append(String.valueOf(i2 - n2));
        }
        return stringBuffer.toString();
    }

    public static List<DefaultMutableTreeNode> getLastExpandedNodes(JTree jTree) {
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        int n2 = jTree.getRowCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            TreePath treePath = jTree.getPathForRow(i2);
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            try {
                defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Cast failed! JTree must contain DefaultMuteableTreeNode or derived instances.");
            }
            if (!defaultMutableTreeNode.isLeaf() && jTree.isExpanded(treePath)) continue;
            arrayList.add((DefaultMutableTreeNode)defaultMutableTreeNode.getParent());
        }
        return arrayList;
    }

    public static Object getNodeAt(JTree jTree, int n2, int n3) {
        TreePath treePath = jTree.getPathForLocation(n2, n3);
        return treePath != null ? treePath.getLastPathComponent() : null;
    }

    public static boolean isAncestor(TreeNode treeNode, TreeNode treeNode2) {
        if (treeNode2 == treeNode) {
            return true;
        }
        for (int i2 = 0; i2 < treeNode2.getChildCount(); ++i2) {
            if (!TreeHelpers.isAncestor(treeNode, treeNode2.getChildAt(i2))) continue;
            return true;
        }
        return false;
    }

    public static void restoreExpansionState(JTree jTree, int n2, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            int n3 = n2 + Integer.parseInt(stringTokenizer.nextToken());
            jTree.expandRow(n3);
        }
    }
}

