/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.imagecombobox;

import com.google.security.zynamics.zylib.gui.imagecombobox.ImageElement;
import java.awt.Component;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;

public class JImageComboBox
extends JComboBox<ImageElement> {
    public JImageComboBox(ImageElement[] imageElementArray) {
        super(imageElementArray);
        this.setRenderer(new ComboBoxRenderer(0));
    }

    public JImageComboBox(ImageElement[] imageElementArray, int n2) {
        super(imageElementArray);
        if (n2 != 2 && n2 != 0 && n2 != 4) {
            throw new IllegalArgumentException("Erorr: Label alignment in invalid.");
        }
        this.setRenderer(new ComboBoxRenderer(n2));
    }

    private static class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        private static final long serialVersionUID = 2728401247866641230L;
        private Font uhOhFont;

        public ComboBoxRenderer(int n2) {
            this.setOpaque(true);
            this.setHorizontalAlignment(n2);
            this.setVerticalAlignment(0);
            if (n2 == 2) {
                this.setBorder(new EmptyBorder(0, 5, 0, 0));
            }
        }

        protected void setUhOhText(String string, Font font) {
            if (this.uhOhFont == null) {
                this.uhOhFont = font.deriveFont(2);
            }
            this.setFont(this.uhOhFont);
            this.setText(string);
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n2, boolean bl2, boolean bl3) {
            ImageElement imageElement = (ImageElement)object;
            if (bl2) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (imageElement == null) {
                return this;
            }
            ImageIcon imageIcon = imageElement.getIcon();
            String string = imageElement.getObject().toString();
            this.setIcon(imageIcon);
            if (imageIcon != null) {
                this.setText(string);
                this.setFont(jList.getFont());
            } else {
                this.setUhOhText(string + " (no image available)", jList.getFont());
            }
            return this;
        }
    }
}

