/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.errordialog;

import com.google.security.zynamics.zylib.general.StackTrace;
import com.google.security.zynamics.zylib.gui.CDialogEscaper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;

public abstract class ErrorDialog
extends JDialog {
    private static final long serialVersionUID = -2246347447228688878L;
    private final String m_description;
    private final Throwable m_exception;
    private final String m_message;

    public ErrorDialog(Window window, String string, String string2) {
        this(window, string, string2, null);
    }

    public ErrorDialog(Window window, String string, String string2, Throwable throwable) {
        super(window, Dialog.ModalityType.APPLICATION_MODAL);
        this.m_message = string;
        this.m_description = string2;
        this.m_exception = throwable;
        new CDialogEscaper(this);
        this.setLayout(new BorderLayout());
        this.createGui();
        this.setMinimumSize(new Dimension(600, 400));
        this.setSize(600, 400);
    }

    private void createGui() {
        JComponent jComponent;
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JTextField jTextField = new JTextField();
        jTextField.setEditable(false);
        jTextField.setText(this.m_message);
        jTextField.setBackground(Color.WHITE);
        jPanel2.add(jTextField);
        jPanel2.setBorder(new TitledBorder("Error Message"));
        jPanel.add((Component)jPanel2, "North");
        JTabbedPane jTabbedPane = new JTabbedPane();
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setText(this.m_description);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTabbedPane.addTab("Description", jTextArea);
        if (this.m_exception != null) {
            jComponent = new JTextArea();
            ((JTextComponent)jComponent).setEditable(false);
            ((JTextComponent)jComponent).setText(StackTrace.toString(this.m_exception.getStackTrace()));
            jTabbedPane.addTab("Stack Trace", new JScrollPane(jComponent));
        }
        this.add((Component)jPanel, "North");
        this.add(jTabbedPane);
        jComponent = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        JButton jButton = new JButton(new SendAction());
        jButton.setMinimumSize(new Dimension(180, jButton.getHeight()));
        JButton jButton2 = new JButton(new ReportAction());
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jComponent.add((Component)jPanel3, "West");
        JPanel jPanel4 = new JPanel();
        JButton jButton3 = new JButton(new CloseButtonListener());
        this.getRootPane().setDefaultButton(jButton3);
        jPanel4.add(jButton3);
        jComponent.add((Component)jPanel4, "East");
        this.add((Component)jComponent, "South");
    }

    protected ImageIcon createImageIcon(String string, String string2) {
        URL uRL = this.getClass().getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL, string2);
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }

    protected abstract void report();

    protected abstract void send(String var1, String var2, Throwable var3);

    private class SendAction
    extends AbstractAction {
        private static final long serialVersionUID = -6488875605584243902L;

        private SendAction() {
            super("Send");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ErrorDialog.this.send(ErrorDialog.this.m_description, ErrorDialog.this.m_message, ErrorDialog.this.m_exception);
        }
    }

    private class ReportAction
    extends AbstractAction {
        private static final long serialVersionUID = -5953309819908682475L;

        private ReportAction() {
            super("Report");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ErrorDialog.this.report();
        }
    }

    private class CloseButtonListener
    extends AbstractAction {
        private static final long serialVersionUID = 2709310936594698502L;

        private CloseButtonListener() {
            super("Close");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ErrorDialog.this.dispose();
        }
    }
}

