/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.UrlLabel;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class UrlLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    private static MouseListener linker = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            UrlLabel urlLabel = (UrlLabel)mouseEvent.getSource();
            if (urlLabel.url == null) {
                return;
            }
            try {
                Desktop.getDesktop().browse(urlLabel.url.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                System.out.println(uRISyntaxException);
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
        }
    };
    private URL url;

    public UrlLabel(String string) {
        super(string);
        this.setForeground(Color.BLUE);
        this.addMouseListener(linker);
    }

    public UrlLabel(String string, String string2) {
        this(string);
        this.setToolTipText(string2);
    }

    public UrlLabel(String string, String string2, URL uRL) {
        this(string, uRL);
        this.setToolTipText(string2);
    }

    public UrlLabel(String string, URL uRL) {
        this(string);
        this.url = uRL;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Border border = this.getBorder();
        int n2 = 0;
        int n3 = this.getWidth();
        if (border != null) {
            Insets insets = border.getBorderInsets(this);
            n3 -= insets.right;
            n3 -= insets.left;
            n2 += insets.left;
        }
        graphics.drawLine(n2, this.getHeight() - 2, n3, this.getHeight() - 2);
    }

    public void setUrl(URL uRL) {
        this.url = uRL;
    }
}

