/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.ProgressDialogs;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CProgressPanel;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.IProgressDescription;
import com.google.security.zynamics.zylib.types.common.ICancelableCommand;
import com.google.security.zynamics.zylib.types.common.ICommand;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.CountDownLatch;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class CUnlimitedProgressDialog
extends JDialog
implements IProgressDescription {
    private static final long serialVersionUID = 1009536934858788904L;
    private final ICommand m_command;
    private final InternalWindowListener m_windowListener = new InternalWindowListener();
    private final CProgressPanel m_progressPanel;
    private Exception m_exception;
    private final boolean m_isCancelable;

    private CUnlimitedProgressDialog(Window window, String string, String string2, ICommand iCommand, boolean bl2) {
        super(window, string, Dialog.ModalityType.DOCUMENT_MODAL);
        Preconditions.checkNotNull(iCommand, "Error: Comand can't be null.");
        this.m_isCancelable = bl2;
        this.addWindowListener(this.m_windowListener);
        this.setDefaultCloseOperation(0);
        this.m_command = iCommand;
        this.m_progressPanel = CUnlimitedProgressDialog.createProgressPanel(string2, bl2, this.m_windowListener);
        this.m_progressPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.m_progressPanel.start();
        this.setSubDescription("Please wait...");
        this.add(this.m_progressPanel);
        this.setSize(400, this.getPreferredSize().height);
        this.setMinimumSize(new Dimension(400, this.getPreferredSize().height));
        this.setMaximumSize(new Dimension(Math.max(400, this.getPreferredSize().width), this.getPreferredSize().height));
        this.pack();
        this.setSubDescription("Please wait...");
        if (window != null) {
            GuiHelper.centerChildToParent(window, this, true);
        } else {
            GuiHelper.centerOnScreen(this);
        }
    }

    public CUnlimitedProgressDialog(Window window, String string, String string2, ICancelableCommand iCancelableCommand) {
        this(window, string, string2, iCancelableCommand, true);
    }

    public CUnlimitedProgressDialog(Window window, String string, String string2, ICommand iCommand) {
        this(window, string, string2, iCommand, false);
    }

    private static CProgressPanel createProgressPanel(String string, boolean bl2, InternalWindowListener internalWindowListener) {
        if (bl2) {
            return new CProgressPanel(string, true, true, internalWindowListener);
        }
        return new CProgressPanel(string, true, true, true, false);
    }

    private void setException(Exception exception) {
        if (this.m_exception == null) {
            this.m_exception = exception;
        }
    }

    public Exception getException() {
        return this.m_exception;
    }

    @Override
    public synchronized void setDescription(String string) {
        this.m_progressPanel.setText(string);
    }

    @Override
    public synchronized void setSubDescription(String string) {
        this.m_progressPanel.setSubText(string);
    }

    @Override
    public void setVisible(boolean bl2) {
        if (bl2 && !this.isVisible()) {
            this.m_exception = null;
            CountDownLatch countDownLatch = new CountDownLatch(2);
            Thread thread = new Thread(new InternalCommandThread(countDownLatch));
            thread.start();
            super.setVisible(bl2);
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        } else if (!bl2 && this.isVisible()) {
            super.setVisible(false);
        }
    }

    public boolean wasCanceled() {
        return this.m_isCancelable && ((ICancelableCommand)this.m_command).wasCanceled();
    }

    private class InternalWindowListener
    extends WindowAdapter
    implements ActionListener {
        private InternalWindowListener() {
        }

        private void cancel() {
            try {
                if (CUnlimitedProgressDialog.this.m_isCancelable) {
                    CUnlimitedProgressDialog.this.setDescription("Canceling...");
                    ((ICancelableCommand)CUnlimitedProgressDialog.this.m_command).cancel();
                }
            }
            catch (Exception exception) {
                CUnlimitedProgressDialog.this.setException(exception);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.cancel();
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            this.cancel();
        }
    }

    private class InternalCommandThread
    implements Runnable {
        private final CountDownLatch m_countDownLatch;

        public InternalCommandThread(CountDownLatch countDownLatch) {
            this.m_countDownLatch = countDownLatch;
        }

        @Override
        public void run() {
            try {
                CUnlimitedProgressDialog.this.m_command.execute();
            }
            catch (Exception exception) {
                CUnlimitedProgressDialog.this.setException(exception);
            }
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CUnlimitedProgressDialog.super.dispose();
                        CUnlimitedProgressDialog.super.setVisible(false);
                        InternalCommandThread.this.m_countDownLatch.countDown();
                    }
                });
            }
            catch (Exception exception) {
                CUnlimitedProgressDialog.this.setException(exception);
            }
            finally {
                this.m_countDownLatch.countDown();
            }
        }
    }
}

