/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.ProgressDialogs;

import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CProgressPanel;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CStandardHelperThread;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.IStandardProgressListener;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.IStandardProgressModel;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.border.EmptyBorder;

public class CStandardProgressDialog
extends JDialog {
    private static final long serialVersionUID = 7140381762236285546L;
    private boolean m_finished = false;
    private final IStandardProgressModel m_progressModel;
    private final InternalListener m_internalListener = new InternalListener();
    private final CProgressPanel m_progressPanel;

    public CStandardProgressDialog(Window window, String string, String string2, IStandardProgressModel iStandardProgressModel) {
        super(window, string, Dialog.ModalityType.DOCUMENT_MODAL);
        this.m_progressModel = iStandardProgressModel;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new InternalWindowListener());
        iStandardProgressModel.addProgressListener(this.m_internalListener);
        this.m_progressPanel = new CProgressPanel(string2, false, false);
        this.m_progressPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.add(this.m_progressPanel);
        this.pack();
        if (window != null) {
            GuiHelper.centerChildToParent(window, this, true);
        } else {
            GuiHelper.centerOnScreen(this);
        }
    }

    public static void show(Window window, String string, String string2, CStandardHelperThread cStandardHelperThread) {
        CStandardProgressDialog cStandardProgressDialog = new CStandardProgressDialog(window, string, string2, cStandardHelperThread);
        cStandardHelperThread.start();
        cStandardProgressDialog.setVisible(true);
    }

    public void setDescription(String string) {
        this.m_progressPanel.setText(string);
    }

    public void setSubDescription(String string) {
        this.m_progressPanel.setSubText(string);
        if (this.getParent() != null) {
            GuiHelper.centerChildToParent(this.getParent(), this, true);
        } else {
            GuiHelper.centerOnScreen(this);
        }
    }

    @Override
    public void setVisible(boolean bl2) {
        if (!this.m_finished) {
            try {
                super.setVisible(bl2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class InternalWindowListener
    extends WindowAdapter {
        private InternalWindowListener() {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            CStandardProgressDialog.this.m_progressModel.closeRequested();
        }
    }

    private class InternalListener
    implements IStandardProgressListener {
        private InternalListener() {
        }

        @Override
        public void changedDescription(String string) {
            CStandardProgressDialog.this.setSubDescription(string);
        }

        @Override
        public void changedMaximum(int n2) {
            CStandardProgressDialog.this.m_progressPanel.setMaximum(n2);
        }

        @Override
        public void finished() {
            CStandardProgressDialog.this.m_finished = true;
            CStandardProgressDialog.this.m_progressModel.removeProgressListener(this);
            CStandardProgressDialog.this.dispose();
        }

        @Override
        public void next() {
            CStandardProgressDialog.this.m_progressPanel.next();
        }

        @Override
        public void reset() {
            CStandardProgressDialog.this.m_progressPanel.reset();
        }
    }
}

