/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.ProgressDialogs;

import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.IStandardDescriptionUpdater;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.IStandardProgressListener;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.IStandardProgressModel;

public abstract class CStandardHelperThread
extends Thread
implements IStandardDescriptionUpdater,
IStandardProgressModel {
    private final ListenerProvider<IStandardProgressListener> m_listeners = new ListenerProvider();
    private Exception m_exception;

    private void notifyListeners() {
        for (IStandardProgressListener iStandardProgressListener : this.m_listeners) {
            iStandardProgressListener.finished();
        }
    }

    protected void finish() {
        this.notifyListeners();
        this.stop();
    }

    protected abstract void runExpensiveCommand();

    @Override
    public final void addProgressListener(IStandardProgressListener iStandardProgressListener) {
        this.m_listeners.addListener(iStandardProgressListener);
    }

    @Override
    public void closeRequested() {
    }

    public Exception getException() {
        return this.m_exception;
    }

    @Override
    public void next() {
        for (IStandardProgressListener iStandardProgressListener : this.m_listeners) {
            iStandardProgressListener.next();
        }
    }

    @Override
    public final void removeProgressListener(IStandardProgressListener iStandardProgressListener) {
        this.m_listeners.removeListener(iStandardProgressListener);
    }

    @Override
    public void reset() {
        for (IStandardProgressListener iStandardProgressListener : this.m_listeners) {
            iStandardProgressListener.reset();
        }
    }

    @Override
    public final void run() {
        try {
            this.runExpensiveCommand();
        }
        catch (Exception exception) {
            this.m_exception = exception;
        }
        finally {
            this.notifyListeners();
        }
    }

    @Override
    public void setDescription(String string) {
        for (IStandardProgressListener iStandardProgressListener : this.m_listeners) {
            iStandardProgressListener.changedDescription(string);
        }
    }

    @Override
    public void setMaximum(int n2) {
        for (IStandardProgressListener iStandardProgressListener : this.m_listeners) {
            iStandardProgressListener.changedMaximum(n2);
        }
    }
}

