/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.ProgressDialogs;

import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.IEndlessDescriptionUpdater;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.IEndlessProgressListener;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.IEndlessProgressModel;

public abstract class CEndlessHelperThread
extends Thread
implements IEndlessDescriptionUpdater,
IEndlessProgressModel {
    private final ListenerProvider<IEndlessProgressListener> m_listeners = new ListenerProvider();
    private Exception m_exception;

    private void notifyListeners() {
        for (IEndlessProgressListener iEndlessProgressListener : this.m_listeners) {
            iEndlessProgressListener.finished();
        }
    }

    protected void finish() {
        this.notifyListeners();
        this.stop();
    }

    protected abstract void runExpensiveCommand();

    @Override
    public final void addProgressListener(IEndlessProgressListener iEndlessProgressListener) {
        this.m_listeners.addListener(iEndlessProgressListener);
    }

    @Override
    public void closeRequested() {
    }

    public Exception getException() {
        return this.m_exception;
    }

    @Override
    public final void removeProgressListener(IEndlessProgressListener iEndlessProgressListener) {
        this.m_listeners.removeListener(iEndlessProgressListener);
    }

    @Override
    public final void run() {
        try {
            this.runExpensiveCommand();
        }
        catch (Exception exception) {
            this.m_exception = exception;
        }
        finally {
            this.notifyListeners();
        }
    }

    @Override
    public void setDescription(String string) {
        for (IEndlessProgressListener iEndlessProgressListener : this.m_listeners) {
            iEndlessProgressListener.changedDescription(string);
        }
    }

    public void setGeneralDescription(String string) {
        for (IEndlessProgressListener iEndlessProgressListener : this.m_listeners) {
            iEndlessProgressListener.changedGeneralDescription(string);
        }
    }
}

