/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.JStackView;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.JHexPanel.JHexView;
import com.google.security.zynamics.zylib.gui.JStackView.IStackModel;
import com.google.security.zynamics.zylib.gui.JStackView.IStackModelListener;
import com.google.security.zynamics.zylib.gui.JStackView.JStackPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseWheelEvent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public final class JStackView
extends JPanel {
    private static final long serialVersionUID = -7850318708757157383L;
    private final JScrollBar m_scrollbar = new JScrollBar(1, 0, 1, 0, 1);
    private final InternalListener m_listener = new InternalListener();
    private final IStackModel m_model;
    private final JStackPanel m_panel;
    private final JScrollBar m_bottomScrollbar = new JScrollBar(0, 0, 1, 0, 1);

    public JStackView(IStackModel iStackModel) {
        super(new BorderLayout());
        Preconditions.checkNotNull(iStackModel, "Error: Model argument can not be null");
        this.m_model = iStackModel;
        this.m_panel = new JStackPanel(iStackModel);
        this.add(this.m_panel);
        this.setFocusable(true);
        this.initScrollbar();
        this.setPreferredSize(new Dimension(400, 400));
        this.m_model.addListener(this.m_listener);
        this.addComponentListener(this.m_listener);
        this.addMouseWheelListener(new InternalMouseListener());
    }

    private void initScrollbar() {
        this.m_scrollbar.addAdjustmentListener(this.m_listener);
        this.m_bottomScrollbar.addAdjustmentListener(this.m_listener);
        this.add((Component)this.m_scrollbar, "East");
        this.add((Component)this.m_bottomScrollbar, "South");
    }

    private void setCurrentPosition(long l2) {
        int n2 = (int)((l2 - this.m_model.getStartAddress()) / 4L);
        this.m_scrollbar.setValue(n2);
        this.m_panel.repaint();
    }

    private void setHorizontalScrollBarMaximum() {
        int n2 = this.m_panel.getOffsetViewWidth() + 10 + 80;
        int n3 = this.getWidth();
        if (n3 >= n2 || this.m_panel.getCharWidth() == 0) {
            this.m_bottomScrollbar.setValue(0);
            this.m_bottomScrollbar.setEnabled(false);
        } else {
            this.m_bottomScrollbar.setMaximum((n2 - n3) / this.m_panel.getCharWidth() + 1);
            this.m_bottomScrollbar.setEnabled(true);
        }
    }

    private void setScrollBarMaximum() {
        int n2 = this.m_panel.getNumberOfVisibleRows();
        int n3 = this.m_model.getNumberOfEntries();
        int n4 = 2 + n3 - n2;
        if (n4 < 0) {
            n4 = 0;
            this.m_scrollbar.setValue(0);
            this.m_scrollbar.setEnabled(false);
        } else {
            this.m_scrollbar.setEnabled(true);
        }
        this.m_scrollbar.setMaximum(n4);
    }

    public String getValueAt(Point point) {
        return this.m_panel.getValueAt(point);
    }

    public void gotoOffset(long l2) {
        this.setCurrentPosition(l2);
    }

    public void setDefinitionStatus(JHexView.DefinitionStatus definitionStatus) {
        this.m_panel.setDefinitionStatus(definitionStatus);
    }

    @Override
    public void setEnabled(boolean bl2) {
        super.setEnabled(bl2);
        this.m_panel.repaint();
    }

    private class InternalMouseListener
    extends MouseAdapter {
        private InternalMouseListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (!JStackView.this.isEnabled()) {
                return;
            }
            int n2 = mouseWheelEvent.getWheelRotation();
            JStackView.this.m_scrollbar.setValue(JStackView.this.m_scrollbar.getValue() + n2);
        }
    }

    private class InternalListener
    implements IStackModelListener,
    AdjustmentListener,
    ComponentListener {
        private InternalListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (adjustmentEvent.getSource() == JStackView.this.m_scrollbar) {
                JStackView.this.m_panel.setFirstRow(adjustmentEvent.getValue());
            } else {
                JStackView.this.m_panel.setFirstColumn(adjustmentEvent.getValue());
            }
            JStackView.this.m_panel.repaint();
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            JStackView.this.setScrollBarMaximum();
            JStackView.this.setHorizontalScrollBarMaximum();
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void dataChanged() {
            JStackView.this.setScrollBarMaximum();
            JStackView.this.setHorizontalScrollBarMaximum();
            JStackView.this.m_panel.repaint();
        }
    }
}

