/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.JStackView;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.gui.JHexPanel.JHexView;
import com.google.security.zynamics.zylib.gui.JStackView.AddressMode;
import com.google.security.zynamics.zylib.gui.JStackView.IStackModel;
import com.google.security.zynamics.zylib.gui.JStackView.IStackModelListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.Timer;

public final class JStackPanel
extends JPanel {
    private static final int PADDING_OFFSETVIEW = 20;
    private static final int PADDING_LEFT = 10;
    private static final int SIZEOF_DWORD = 4;
    private static final int SIZEOF_QWORD = 8;
    private final IStackModel model;
    private final Font font = GuiHelper.getMonospacedFont();
    private int rowHeight;
    private int charHeight;
    private int charWidth;
    private int offsetViewWidth;
    private boolean firstDraw = true;
    private static final int hexElementWidth = 10;
    private final InternalListener listener = new InternalListener();
    private int firstRow = 0;
    private static final int paddingTop = 16;
    private final Color fontColorOffsets = Color.WHITE;
    private final Color fontColorValues = Color.BLACK;
    private final Color disabledColor = Color.GRAY;
    private final Color bgColorOffset = Color.GRAY;
    private Timer updateTimer;
    private JHexView.DefinitionStatus status = JHexView.DefinitionStatus.UNDEFINED;
    private final AddressMode addressMode = AddressMode.BIT32;
    private int firstColumn = 0;

    public JStackPanel(IStackModel iStackModel) {
        super(new BorderLayout());
        Preconditions.checkNotNull(iStackModel, "Error: Model argument can not be null");
        this.model = iStackModel;
        this.model.addListener(this.listener);
        this.setFocusable(true);
        this.setFont(this.font);
        this.setPreferredSize(new Dimension(400, 400));
    }

    private static int getCharacterWidth(Graphics graphics) {
        return (int)graphics.getFontMetrics().getStringBounds("0", graphics).getWidth();
    }

    private static int getCharHeight(Graphics graphics) {
        return graphics.getFontMetrics().getAscent();
    }

    private static int getRowHeight(Graphics graphics) {
        return graphics.getFontMetrics().getHeight();
    }

    private void calculateSizes(Graphics graphics) {
        this.rowHeight = JStackPanel.getRowHeight(graphics);
        this.charHeight = JStackPanel.getCharHeight(graphics);
        this.charWidth = JStackPanel.getCharacterWidth(graphics);
    }

    private void drawBackground(Graphics graphics) {
        graphics.setColor(this.bgColorOffset);
        graphics.fillRect(-this.firstColumn * this.charWidth, 0, this.offsetViewWidth, this.getHeight());
    }

    private void drawElements(Graphics graphics) {
        if (this.isEnabled()) {
            graphics.setColor(this.fontColorValues);
        } else {
            graphics.setColor(this.disabledColor != this.bgColorOffset ? this.disabledColor : Color.WHITE);
        }
        int n2 = 10 + this.offsetViewWidth - this.charWidth * this.firstColumn;
        int n3 = this.getNumberOfVisibleRows();
        if (this.firstRow + n3 >= this.model.getNumberOfEntries() && (n3 = this.model.getNumberOfEntries() - this.firstRow) < 0) {
            return;
        }
        if (this.model.getStartAddress() == -1L) {
            return;
        }
        long l2 = this.getElementSize();
        if (this.status == JHexView.DefinitionStatus.DEFINED) {
            long l3;
            long l4 = this.model.getStartAddress() + (long)this.firstRow * l2;
            if (!this.model.hasData(l4, l3 = (long)n3 * l2)) {
                this.setDefinitionStatus(JHexView.DefinitionStatus.UNDEFINED);
                this.setEnabled(false);
                if (this.updateTimer != null) {
                    this.updateTimer.setRepeats(false);
                    this.updateTimer.stop();
                }
                this.updateTimer = new Timer(1000, new WaitingForDataAction(l4, l3));
                this.updateTimer.setRepeats(true);
                this.updateTimer.start();
                return;
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                long l5 = l4 + (long)i2 * l2;
                graphics.drawString(this.model.getElement(l5), n2, 16 + i2 * this.rowHeight);
            }
        } else {
            for (int i3 = 0; i3 < n3; ++i3) {
                graphics.drawString(Strings.repeat("?", 2 * this.getElementSize()), n2, 16 + i3 * this.rowHeight);
            }
        }
    }

    private void drawOffsets(Graphics graphics) {
        int n2 = this.getNumberOfVisibleRows();
        String string = this.addressMode == AddressMode.BIT32 ? "%08X" : "%016X";
        long l2 = this.getElementSize();
        long l3 = this.model.getStartAddress() == -1L ? 0L : this.model.getStartAddress();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.firstRow + i2;
            long l4 = l3 + (long)n3 * l2;
            String string2 = String.format(string, l4);
            if (l4 == this.model.getStackPointer()) {
                this.highlightStackPointer(graphics, i2);
            }
            if (this.isEnabled()) {
                graphics.setColor(this.fontColorOffsets);
            } else {
                graphics.setColor(this.disabledColor != this.bgColorOffset ? this.disabledColor : Color.WHITE);
            }
            graphics.drawString(string2, 10 - this.charWidth * this.firstColumn, 16 + i2 * this.rowHeight);
        }
    }

    private int getElementSize() {
        return this.addressMode == AddressMode.BIT32 ? 4 : 8;
    }

    private void highlightStackPointer(Graphics graphics, int n2) {
        graphics.setColor(Color.RED);
        double d2 = graphics.getFontMetrics().getStringBounds(Strings.repeat("0", 2 * this.getElementSize()), graphics).getWidth();
        graphics.fillRect(8 - this.charWidth * this.firstColumn, 16 + n2 * this.rowHeight - this.charHeight, (int)d2 + 4, this.charHeight + 2);
    }

    private void updateOffsetViewWidth() {
        int n2 = this.addressMode == AddressMode.BIT32 ? 8 : 16;
        this.offsetViewWidth = 20 + this.charWidth * n2;
    }

    private void updatePreferredSize() {
        int n2 = this.offsetViewWidth + 10 + 18 * this.charWidth;
        this.setPreferredSize(new Dimension(n2, this.getHeight()));
        this.revalidate();
    }

    protected int getNumberOfVisibleRows() {
        if (this.rowHeight == 0) {
            return 0;
        }
        int n2 = this.getHeight() - 16;
        return n2 / this.rowHeight + (n2 % this.rowHeight == 0 ? 0 : 1);
    }

    protected void setFirstRow(int n2) {
        this.firstRow = n2;
        this.repaint();
    }

    public int getCharWidth() {
        return this.charWidth;
    }

    public int getOffsetViewWidth() {
        return this.offsetViewWidth;
    }

    public String getValueAt(Point point) {
        int n2 = (point.y - 16 + this.rowHeight) / this.rowHeight;
        long l2 = this.getElementSize();
        long l3 = this.model.getStartAddress() + (long)this.firstRow * l2;
        long l4 = l3 + (long)n2 * l2;
        return this.model.hasData(l4, l2) ? this.model.getElement(l4) : null;
    }

    public void gotoOffset(long l2) {
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.calculateSizes(graphics);
        this.updateOffsetViewWidth();
        if (this.firstDraw) {
            this.firstDraw = false;
            this.updatePreferredSize();
        }
        this.drawBackground(graphics);
        this.drawOffsets(graphics);
        this.drawElements(graphics);
    }

    public void setDefinitionStatus(JHexView.DefinitionStatus definitionStatus) {
        Preconditions.checkNotNull(definitionStatus, "Error: Status argument can not be null");
        this.status = definitionStatus;
        this.repaint();
    }

    public void setFirstColumn(int n2) {
        this.firstColumn = n2;
    }

    private class WaitingForDataAction
    extends AbstractAction {
        private static final long serialVersionUID = -610823391617272365L;
        private final long m_startAddress;
        private final long m_numberOfBytes;

        private WaitingForDataAction(long l2, long l3) {
            this.m_startAddress = l2;
            this.m_numberOfBytes = l3;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (JStackPanel.this.model.hasData(this.m_startAddress, this.m_numberOfBytes)) {
                JStackPanel.this.setEnabled(true);
                JStackPanel.this.setDefinitionStatus(JHexView.DefinitionStatus.DEFINED);
                ((Timer)actionEvent.getSource()).stop();
            } else if (!JStackPanel.this.model.keepTrying()) {
                ((Timer)actionEvent.getSource()).stop();
            }
        }
    }

    private class InternalListener
    implements IStackModelListener {
        private InternalListener() {
        }

        @Override
        public void dataChanged() {
            JStackPanel.this.repaint();
        }
    }
}

