/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.JRegisterView;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.JRegisterView.IRegisterModel;
import com.google.security.zynamics.zylib.gui.JRegisterView.IRegistersChangedListener;
import com.google.security.zynamics.zylib.gui.JRegisterView.RegisterInformation;
import com.google.security.zynamics.zylib.gui.JRegisterView.RegisterInformationInternal;
import java.math.BigInteger;
import java.util.HashMap;

public class SimpleRegisterModel
implements IRegisterModel {
    private final HashMap<String, RegisterInformationInternal> registerMap = new HashMap();
    private final RegisterInformationInternal[] registers;

    public SimpleRegisterModel(RegisterInformation[] registerInformationArray) {
        this.registers = new RegisterInformationInternal[registerInformationArray.length];
        this.initializeRegisterInformation(registerInformationArray);
    }

    private void initializeRegisterInformation(RegisterInformation[] registerInformationArray) {
        for (int i2 = 0; i2 < registerInformationArray.length; ++i2) {
            RegisterInformationInternal registerInformationInternal;
            RegisterInformation registerInformation = registerInformationArray[i2];
            Preconditions.checkNotNull(registerInformation.getRegisterName(), "Error: register.getRegisterName() argument can not be null");
            Preconditions.checkArgument(this.registerMap.containsKey(registerInformation.getRegisterName()), "Error: Duplicate register name " + registerInformation.getRegisterName());
            this.registers[i2] = registerInformationInternal = new RegisterInformationInternal(registerInformation.getRegisterName(), registerInformation.getRegisterSize());
            this.registerMap.put(registerInformation.getRegisterName(), registerInformationInternal);
        }
    }

    @Override
    public void addListener(IRegistersChangedListener iRegistersChangedListener) {
    }

    @Override
    public int getNumberOfRegisters() {
        return this.registers.length;
    }

    @Override
    public RegisterInformationInternal[] getRegisterInformation() {
        return this.registers;
    }

    @Override
    public RegisterInformationInternal getRegisterInformation(int n2) {
        return this.registers[n2];
    }

    @Override
    public void setValue(String string, BigInteger bigInteger) {
        Preconditions.checkNotNull(string, "Error: Argument register can't be null");
        Preconditions.checkArgument(this.registerMap.containsKey(string), "Error: Invalid register name");
        RegisterInformationInternal registerInformationInternal = this.registerMap.get(string);
        registerInformationInternal.setValue(bigInteger);
        registerInformationInternal.setModified(true);
    }
}

