/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.JRegisterView;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.gui.JCaret.ICaretListener;
import com.google.security.zynamics.zylib.gui.JCaret.JCaret;
import com.google.security.zynamics.zylib.gui.JRegisterView.IMenuProvider;
import com.google.security.zynamics.zylib.gui.JRegisterView.IRegisterModel;
import com.google.security.zynamics.zylib.gui.JRegisterView.IRegistersChangedListener;
import com.google.security.zynamics.zylib.gui.JRegisterView.RegisterInformationInternal;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.math.BigInteger;
import java.util.Objects;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.Scrollable;

public class JRegisterView
extends JPanel
implements Scrollable {
    private final Font font = GuiHelper.getMonospacedFont();
    private final IRegisterModel registerModel;
    private int longestRegisterName = 0;
    private int highlightedRegister = -1;
    private int charWidth;
    private final Color modifiedColor = Color.RED;
    private final Color textColor = Color.BLACK;
    private static final int paddingLeft = 10;
    private final Color bgColorEdit = new Color(16765152);
    private final Color bgColorHighlight = Color.WHITE;
    private int editedRegister = -1;
    private final JCaret caret = new JCaret();
    private int caretPosition = 0;
    private BigInteger editValue = BigInteger.ZERO;
    private final Color backgroundColor = new Color(0xCCCCFF);
    private final Color disabledColor = Color.GRAY;
    private IMenuProvider menuProvider;
    private final InternalListener listener = new InternalListener();

    public JRegisterView(IRegisterModel iRegisterModel) {
        Preconditions.checkNotNull(iRegisterModel, "Error: Argument registerModel can't be null");
        iRegisterModel.addListener(this.listener);
        this.setFocusable(true);
        this.setOpaque(true);
        this.initializeListeners();
        this.registerModel = iRegisterModel;
        this.updateLongestRegisterName();
        this.setBackground(this.backgroundColor);
        this.updatePreferredSize();
    }

    private void drawCaret(Graphics graphics) {
        if (this.hasFocus() && this.editedRegister != -1) {
            Rectangle rectangle = this.getRegisterBounds(this.editedRegister);
            int n2 = this.font.getSize();
            int n3 = rectangle.x + this.caretPosition * this.charWidth + this.longestRegisterName * this.charWidth + 5 - 1;
            int n4 = rectangle.y;
            this.caret.draw(graphics, n3, n4, n2);
        }
    }

    private void drawHighlightedRegister(Graphics graphics) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.editedRegister != -1) {
            graphics.setColor(this.bgColorEdit);
            Rectangle rectangle = this.getRegisterBounds(this.editedRegister);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else if (this.highlightedRegister != -1) {
            graphics.setColor(this.bgColorHighlight);
            Rectangle rectangle = this.getRegisterBounds(this.highlightedRegister);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private void drawRegisters(Graphics graphics) {
        int n2;
        int n3 = n2 = this.font.getSize() + 5;
        int n4 = this.font.getSize();
        int n5 = 0;
        for (RegisterInformationInternal registerInformationInternal : this.registerModel.getRegisterInformation()) {
            String string;
            if (this.isEnabled()) {
                graphics.setColor(registerInformationInternal.isModified() || n5 == this.editedRegister ? this.modifiedColor : this.textColor);
            } else {
                graphics.setColor(this.disabledColor);
            }
            graphics.drawString(registerInformationInternal.getRegisterName(), 10, n3);
            BigInteger bigInteger = (n5 == this.editedRegister ? this.editValue : registerInformationInternal.getValue()).and(registerInformationInternal.getRegisterSize() == 8 ? BigInteger.valueOf(Long.MAX_VALUE) : BigInteger.valueOf(0xFFFFFFFFL));
            if (registerInformationInternal.getRegisterSize() != 0) {
                String string2 = "%0" + 2 * registerInformationInternal.getRegisterSize() + "X";
                string = String.format(string2, bigInteger);
            } else {
                string = String.valueOf(bigInteger.and(BigInteger.ONE));
            }
            graphics.drawString(string, 15 + this.charWidth * this.longestRegisterName, n3);
            ++n5;
            n3 += n4;
        }
    }

    private void enterEditMode(int n2) {
        this.requestFocusInWindow();
        this.caret.setVisible(true);
        this.editedRegister = n2;
        this.caretPosition = 0;
        this.editValue = this.registerModel.getRegisterInformation(n2).getValue();
        this.repaint();
    }

    private Rectangle getRegisterBounds(int n2) {
        RegisterInformationInternal registerInformationInternal = this.registerModel.getRegisterInformation(n2);
        int n3 = 10;
        int n4 = 7 + n2 * this.font.getSize();
        int n5 = 5 + this.charWidth * (this.longestRegisterName + registerInformationInternal.getRegisterSize() * 2);
        int n6 = this.font.getSize() - 1;
        return new Rectangle(10, n4, n5, n6);
    }

    private int getRegisterNumber(int n2, int n3) {
        int n4 = this.font.getSize();
        if (n3 >= 7 && n3 <= 7 + n4 * this.registerModel.getNumberOfRegisters()) {
            int n5 = (n3 - 7) / n4;
            if ((n5 = Math.min(n5, this.registerModel.getNumberOfRegisters() - 1)) == -1) {
                return -1;
            }
            RegisterInformationInternal registerInformationInternal = this.registerModel.getRegisterInformation(n5);
            int n6 = registerInformationInternal.getRegisterSize() == 0 ? 1 : registerInformationInternal.getRegisterSize() * 2;
            int n7 = 15 + this.charWidth * (this.longestRegisterName + n6);
            if (n2 >= 10 && n2 <= n7) {
                return n5;
            }
        }
        return -1;
    }

    private void initializeListeners() {
        this.addMouseListener(this.listener);
        this.addMouseMotionListener(this.listener);
        this.addKeyListener(this.listener);
        this.addFocusListener(this.listener);
        this.caret.addCaretListener(this.listener);
    }

    private void leaveEditMode(boolean bl2) {
        RegisterInformationInternal registerInformationInternal;
        if (bl2 && !Objects.equals(this.editValue, (registerInformationInternal = this.registerModel.getRegisterInformation(this.editedRegister)).getValue())) {
            this.beginRegisterUpdate();
            this.registerModel.setValue(registerInformationInternal.getRegisterName(), this.editValue);
            this.endRegisterUpdate();
        }
        this.caret.setVisible(false);
        this.editedRegister = -1;
        this.caretPosition = 0;
        this.repaint();
    }

    private void updateLongestRegisterName() {
        this.longestRegisterName = Integer.MIN_VALUE;
        for (RegisterInformationInternal registerInformationInternal : this.registerModel.getRegisterInformation()) {
            if (registerInformationInternal.getRegisterName().length() <= this.longestRegisterName) continue;
            this.longestRegisterName = registerInformationInternal.getRegisterName().length();
        }
    }

    private void updatePreferredSize() {
        int n2 = this.font.getSize() + 5;
        int n3 = this.font.getSize();
        int n4 = n2 + this.registerModel.getNumberOfRegisters() * n3;
        this.setPreferredSize(new Dimension(200, n4));
        this.revalidate();
        this.updateUI();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setFont(this.font);
        this.charWidth = (int)graphics.getFontMetrics().getStringBounds("0", graphics).getWidth();
        if (this.registerModel != null) {
            this.drawHighlightedRegister(graphics);
            this.drawRegisters(graphics);
            if (this.caret.isVisible()) {
                this.drawCaret(graphics);
            }
        }
    }

    public void beginRegisterUpdate() {
        for (RegisterInformationInternal registerInformationInternal : this.registerModel.getRegisterInformation()) {
            registerInformationInternal.setModified(false);
        }
    }

    public void dispose() {
        this.removeMouseListener(this.listener);
        this.removeMouseMotionListener(this.listener);
        this.removeKeyListener(this.listener);
        this.removeFocusListener(this.listener);
        this.caret.removeListener(this.listener);
        this.caret.stop();
    }

    public void endRegisterUpdate() {
        this.repaint();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n2, int n3) {
        return 5 * this.font.getSize();
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n2, int n3) {
        return this.font.getSize();
    }

    @Override
    public void setEnabled(boolean bl2) {
        super.setEnabled(bl2);
        this.repaint();
    }

    public void setMenuProvider(IMenuProvider iMenuProvider) {
        this.menuProvider = iMenuProvider;
    }

    private class InternalListener
    implements ICaretListener,
    IRegistersChangedListener,
    FocusListener,
    KeyListener,
    MouseListener,
    MouseMotionListener {
        private InternalListener() {
        }

        private int hexToValue(char c2) {
            if (c2 >= 'A' && c2 <= 'F') {
                return c2 - 65 + 10;
            }
            if (c2 >= 'a' && c2 <= 'f') {
                return c2 - 97 + 10;
            }
            return c2 - 48;
        }

        private boolean isHexChar(char c2) {
            return c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F' || c2 >= '0' && c2 <= '9';
        }

        @Override
        public void caretStatusChanged(JCaret jCaret) {
            JRegisterView.this.repaint();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (JRegisterView.this.editedRegister != 1) {
                JRegisterView.this.leaveEditMode(false);
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 39) {
                if (JRegisterView.this.caretPosition != 2 * JRegisterView.this.registerModel.getRegisterInformation(JRegisterView.this.editedRegister).getRegisterSize()) {
                    JRegisterView.this.caretPosition++;
                }
                keyEvent.consume();
                JRegisterView.this.caret.setVisible(true);
                JRegisterView.this.repaint();
            } else if (keyEvent.getKeyCode() == 37) {
                if (JRegisterView.this.caretPosition != 0) {
                    JRegisterView.this.caretPosition--;
                }
                keyEvent.consume();
                JRegisterView.this.caret.setVisible(true);
                JRegisterView.this.repaint();
            } else if (keyEvent.getKeyCode() == 10) {
                if (JRegisterView.this.editedRegister == -1) {
                    if (JRegisterView.this.highlightedRegister != -1) {
                        JRegisterView.this.enterEditMode(JRegisterView.this.highlightedRegister);
                    }
                } else {
                    JRegisterView.this.leaveEditMode(true);
                }
                JRegisterView.this.repaint();
            } else if (this.isHexChar(keyEvent.getKeyChar())) {
                int n2 = JRegisterView.this.registerModel.getRegisterInformation(JRegisterView.this.editedRegister).getRegisterSize();
                if (JRegisterView.this.caretPosition == 2 * n2) {
                    return;
                }
                long l2 = this.hexToValue(keyEvent.getKeyChar());
                long l3 = n2 * 8 - 4 - JRegisterView.this.caretPosition * 4;
                long l4 = 15L << (int)l3;
                long l5 = l2 << (int)l3;
                JRegisterView.this.editValue = JRegisterView.this.editValue.and(BigInteger.valueOf(l4 ^ 0xFFFFFFFFFFFFFFFFL)).or(BigInteger.valueOf(l5));
                JRegisterView.this.caretPosition++;
                JRegisterView.this.caret.setVisible(true);
                JRegisterView.this.repaint();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n2 = JRegisterView.this.getRegisterNumber(mouseEvent.getX(), mouseEvent.getY());
            if (mouseEvent.getButton() == 1) {
                if (mouseEvent.getClickCount() == 1) {
                    if (JRegisterView.this.editedRegister != -1 && n2 != JRegisterView.this.editedRegister) {
                        JRegisterView.this.leaveEditMode(false);
                    }
                } else if (mouseEvent.getClickCount() == 2 && n2 != -1 && JRegisterView.this.editedRegister == -1) {
                    RegisterInformationInternal registerInformationInternal = JRegisterView.this.registerModel.getRegisterInformation(n2);
                    if (registerInformationInternal.getRegisterSize() == 0) {
                        JRegisterView.this.registerModel.setValue(registerInformationInternal.getRegisterName(), registerInformationInternal.getValue().xor(BigInteger.ONE));
                    } else {
                        JRegisterView.this.enterEditMode(JRegisterView.this.highlightedRegister);
                    }
                }
            } else if (mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1) {
                JPopupMenu jPopupMenu;
                if (JRegisterView.this.editedRegister != -1 && n2 != JRegisterView.this.editedRegister) {
                    JRegisterView.this.leaveEditMode(false);
                }
                if ((jPopupMenu = JRegisterView.this.menuProvider.getRegisterMenu(n2)) != null) {
                    jPopupMenu.show(JRegisterView.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (JRegisterView.this.editedRegister == -1) {
                JRegisterView.this.highlightedRegister = -1;
                JRegisterView.this.repaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JRegisterView.this.highlightedRegister = JRegisterView.this.getRegisterNumber(mouseEvent.getX(), mouseEvent.getY());
            JRegisterView.this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void registerDataChanged() {
            JRegisterView.this.updatePreferredSize();
            JRegisterView.this.updateLongestRegisterName();
            JRegisterView.this.repaint();
        }
    }
}

