/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.JHexPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.general.Convert;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.gui.JCaret.ICaretListener;
import com.google.security.zynamics.zylib.gui.JCaret.JCaret;
import com.google.security.zynamics.zylib.gui.JHexPanel.ColoredRange;
import com.google.security.zynamics.zylib.gui.JHexPanel.ColoredRangeManager;
import com.google.security.zynamics.zylib.gui.JHexPanel.IColormap;
import com.google.security.zynamics.zylib.gui.JHexPanel.IDataChangedListener;
import com.google.security.zynamics.zylib.gui.JHexPanel.IDataProvider;
import com.google.security.zynamics.zylib.gui.JHexPanel.IHexPanelListener;
import com.google.security.zynamics.zylib.gui.JHexPanel.IMenuCreator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.Timer;

public final class JHexView
extends JComponent {
    private static final long serialVersionUID = -2402458562501988128L;
    private static final int CHARACTERS_PER_BYTE = 2;
    private static final String[] HEX_BYTES = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1A", "1B", "1C", "1D", "1E", "1F", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2A", "2B", "2C", "2D", "2E", "2F", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3A", "3B", "3C", "3D", "3E", "3F", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4A", "4B", "4C", "4D", "4E", "4F", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5A", "5B", "5C", "5D", "5E", "5F", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6A", "6B", "6C", "6D", "6E", "6F", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7A", "7B", "7C", "7D", "7E", "7F", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "8A", "8B", "8C", "8D", "8E", "8F", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "9A", "9B", "9C", "9D", "9E", "9F", "A0", "A1", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "A9", "AA", "AB", "AC", "AD", "AE", "AF", "B0", "B1", "B2", "B3", "B4", "B5", "B6", "B7", "B8", "B9", "BA", "BB", "BC", "BD", "BE", "BF", "C0", "C1", "C2", "C3", "C4", "C5", "C6", "C7", "C8", "C9", "CA", "CB", "CC", "CD", "CE", "CF", "D0", "D1", "D2", "D3", "D4", "D5", "D6", "D7", "D8", "D9", "DA", "DB", "DC", "DD", "DE", "DF", "E0", "E1", "E2", "E3", "E4", "E5", "E6", "E7", "E8", "E9", "EA", "EB", "EC", "ED", "EE", "EF", "F0", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "FA", "FB", "FC", "FD", "FE", "FF"};
    private static final int PADDING_OFFSETVIEW = 20;
    private static final int NIBBLES_PER_BYTE = 2;
    private final ArrayList<IHexPanelListener> listeners = new ArrayList();
    private IDataProvider dataProvider;
    private int bytesPerRow = 16;
    private Font font = GuiHelper.getMonospacedFont();
    private long selectionStart = 0L;
    private long m_selectionLength = 0L;
    private Views activeView = Views.HEX_VIEW;
    private int hexViewWidth = 270;
    private int columnSpacing = 4;
    private int bytesPerColumn = 2;
    private Color bgColorOffset = Color.GRAY;
    private Color bgColorHex = Color.WHITE;
    private Color bgColorAscii = Color.WHITE;
    private Color fontColorOffsets = Color.WHITE;
    private Color fontColorHex1 = Color.BLUE;
    private Color fontColorHex2 = new Color(0x3399FF);
    private Color fontColorAscii = new Color(0x339900);
    private int rowHeight = 12;
    private int charWidth = 8;
    private final JScrollBar scrollbar = new JScrollBar(1, 0, 1, 0, 1);
    private final JScrollBar horizontalScrollbar = new JScrollBar(0, 0, 1, 0, 1);
    private int firstRow = 0;
    private int firstColumn = 0;
    private long baseAddress = 0L;
    private int lastMouseX = 0;
    private int lastMouseY = 0;
    private boolean enabled = false;
    private final Color disabledColor = Color.GRAY;
    private final JCaret caret = new JCaret();
    private static final int paddingHexLeft = 10;
    private static final int paddingAsciiLeft = 10;
    private static final int paddingTop = 16;
    private int charHeight = 8;
    private final Color colorHighlight = Color.LIGHT_GRAY;
    private DefinitionStatus status = DefinitionStatus.UNDEFINED;
    private IMenuCreator menuCreator;
    private AddressMode addressMode = AddressMode.BIT32;
    private int offsetViewWidth;
    private final ColoredRangeManager[] coloredRanges = new ColoredRangeManager[10];
    private Graphics bufferGraphics;
    private BufferedImage img;
    private Timer updateTimer;
    private boolean firstDraw = true;
    private final InternalListener listener = new InternalListener();
    private final LeftAction leftAction = new LeftAction();
    private final RightAction rightAction = new RightAction();
    private final UpAction upAction = new UpAction();
    private final DownAction downAction = new DownAction();
    private final PageUpAction pageUpAction = new PageUpAction();
    private final PageDownAction pageDownAction = new PageDownAction();
    private final TabAction tabAction = new TabAction();
    private int lastHighlightedNibble;
    private IColormap colormap;
    private Color selectionColor = Color.YELLOW;
    private boolean flipBytes = false;

    public JHexView() {
        for (int i2 = 0; i2 < this.coloredRanges.length; ++i2) {
            this.coloredRanges[i2] = new ColoredRangeManager();
        }
        this.setFocusable(true);
        this.setLayout(new BorderLayout());
        this.setFont(this.font);
        this.initListeners();
        this.initHotkeys();
        this.initScrollbar();
        this.img = new BufferedImage(this.getWidth() + 1 - this.scrollbar.getWidth(), this.getHeight() + 1 - this.horizontalScrollbar.getHeight(), 1);
        this.bufferGraphics = this.img.getGraphics();
        this.updateOffsetViewWidth();
        this.setEnabled(false);
    }

    private void calculateSizes() {
        this.rowHeight = this.getRowHeight(this.bufferGraphics);
        this.charHeight = this.getCharHeight(this.bufferGraphics);
        this.charWidth = this.getCharacterWidth(this.bufferGraphics);
    }

    private void changeBy(ActionEvent actionEvent, int n2) {
        if (actionEvent.getModifiers() == 1) {
            if (this.getSelectionStart() + this.getSelectionLength() + (long)n2 < 0L) {
                this.setSelectionLength(-this.getSelectionStart());
            } else if (this.getSelectionStart() + this.getSelectionLength() + (long)n2 < (long)(2 * this.dataProvider.getDataLength())) {
                this.setSelectionLength(this.getSelectionLength() + (long)n2);
            } else {
                this.setSelectionLength((long)(2 * this.dataProvider.getDataLength()) - this.getSelectionStart());
            }
        } else {
            if (this.getSelectionStart() + this.getSelectionLength() + (long)n2 < 0L) {
                this.setSelectionStart(0L);
            } else if (this.getSelectionStart() + this.getSelectionLength() + (long)n2 < (long)(2 * this.dataProvider.getDataLength())) {
                this.setSelectionStart(this.getSelectionStart() + this.getSelectionLength() + (long)n2);
            } else {
                this.setSelectionStart(2 * this.dataProvider.getDataLength());
            }
            this.setSelectionLength(0L);
        }
        long l2 = this.getSelectionStart() + this.getSelectionLength();
        if (l2 < (long)(2 * this.getFirstVisibleByte())) {
            this.scrollToPosition(l2);
        } else if (l2 >= (long)(2 * (this.getFirstVisibleByte() + this.getMaximumVisibleBytes()))) {
            long l3 = l2 - (long)(2 * (this.getFirstVisibleByte() + this.getMaximumVisibleBytes()));
            long l4 = (long)(2 * this.getFirstVisibleByte() + 2 * this.bytesPerRow) + l3;
            this.scrollToPosition(l4);
        }
        this.caret.setVisible(true);
        this.repaint();
    }

    private void drawAsciiPanel(Graphics graphics) {
        int n2;
        int n3;
        if (this.isEnabled()) {
            graphics.setColor(this.fontColorAscii);
        } else {
            graphics.setColor(this.disabledColor != this.bgColorAscii ? this.disabledColor : Color.WHITE);
        }
        int n4 = this.getCharacterWidth(graphics);
        int n5 = n3 = this.getAsciiViewLeft() + 10;
        int n6 = 16;
        byte[] byArray = null;
        if (this.status == DefinitionStatus.DEFINED) {
            n2 = this.getBytesToDraw();
            byArray = this.dataProvider.getData(this.getFirstVisibleOffset(), n2);
        } else {
            n2 = this.getMaximumVisibleBytes();
        }
        long l2 = this.getFirstVisibleOffset();
        int n7 = 0;
        while (n7 < n2) {
            ColoredRange coloredRange = this.findColoredRange(l2);
            if (coloredRange != null && l2 + (long)n2 < coloredRange.getStart()) {
                coloredRange = null;
            }
            if (n7 != 0 && n7 % this.bytesPerRow == 0) {
                n5 = n3;
                n6 += this.rowHeight;
            }
            if (this.status == DefinitionStatus.DEFINED) {
                int n8 = byArray[n7];
                n8 = Convert.isPrintableCharacter((char)n8) ? n8 : 46;
                String string = String.valueOf((char)n8);
                if (this.isEnabled()) {
                    Color color;
                    long l3;
                    long l4 = l3 = this.flipBytes ? (l2 & (long)(-this.bytesPerColumn)) + (long)this.bytesPerColumn - l2 % (long)this.bytesPerColumn - 1L : l2;
                    if (this.isSelectedOffset(l3)) {
                        graphics.setColor(this.selectionColor);
                        graphics.fillRect(n5, n6 - this.charHeight, this.charWidth, this.charHeight + 2);
                        graphics.setColor(this.fontColorAscii);
                    } else if (coloredRange != null && coloredRange.containsOffset(l2)) {
                        color = coloredRange.getBackgroundColor();
                        if (color != null) {
                            graphics.setColor(color);
                        } else {
                            System.out.println("FOO");
                        }
                        graphics.fillRect(n5, n6 - this.charHeight, this.charWidth, this.charHeight + 2);
                        graphics.setColor(coloredRange.getColor());
                    } else if (this.colormap != null && this.colormap.colorize(byArray, n7)) {
                        color = this.colormap.getBackgroundColor(byArray, n7);
                        Color color2 = this.colormap.getForegroundColor(byArray, n7);
                        if (color != null) {
                            graphics.setColor(color);
                            graphics.fillRect(n5, n6 - this.charHeight, this.charWidth, this.charHeight + 2);
                        }
                        if (color2 != null) {
                            graphics.setColor(color2);
                        }
                    } else {
                        graphics.setColor(this.fontColorAscii);
                    }
                } else {
                    graphics.setColor(this.disabledColor != this.bgColorAscii ? this.disabledColor : Color.WHITE);
                }
                graphics.drawString(string, n5, n6);
            } else {
                graphics.drawString("?", n5, n6);
            }
            n5 += n4;
            if (coloredRange != null && coloredRange.getStart() + (long)coloredRange.getSize() <= l2 && (coloredRange = this.findColoredRange(l2)) != null && l2 + (long)n2 < coloredRange.getStart()) {
                coloredRange = null;
            }
            ++n7;
            ++l2;
        }
    }

    private void drawBackground(Graphics graphics) {
        graphics.setColor(this.bgColorOffset);
        graphics.fillRect(-this.firstColumn * this.charWidth, 0, this.offsetViewWidth, this.getHeight());
        graphics.setColor(this.bgColorHex);
        graphics.fillRect(-this.firstColumn * this.charWidth + this.offsetViewWidth, 0, this.hexViewWidth, this.getHeight());
        graphics.setColor(this.bgColorAscii);
        graphics.fillRect(-this.firstColumn * this.charWidth + this.hexViewWidth + this.offsetViewWidth, 0, this.firstColumn * this.charWidth + this.getWidth() - (this.hexViewWidth + this.offsetViewWidth) - this.scrollbar.getWidth(), this.getHeight() - this.horizontalScrollbar.getHeight());
        graphics.setColor(Color.BLACK);
        graphics.drawLine(-this.firstColumn * this.charWidth + this.offsetViewWidth, 0, -this.firstColumn * this.charWidth + this.offsetViewWidth, this.getHeight());
        graphics.drawLine(-this.firstColumn * this.charWidth + this.offsetViewWidth + this.hexViewWidth, 0, -this.firstColumn * this.charWidth + this.offsetViewWidth + this.hexViewWidth, this.getHeight());
    }

    private void drawCaret(Graphics graphics) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.getCurrentOffset() < (long)this.getFirstVisibleByte() || this.getCurrentColumn() > this.getFirstVisibleByte() + this.getMaximumVisibleBytes()) {
            return;
        }
        int n2 = this.getCharacterWidth(graphics);
        if (this.activeView == Views.HEX_VIEW) {
            this.drawCaretHexWindow(graphics, n2, this.rowHeight);
        } else {
            this.drawCaretAsciiWindow(graphics, n2, this.rowHeight);
        }
    }

    private void drawCaretAsciiWindow(Graphics graphics, int n2, int n3) {
        int n4 = this.getCurrentRow() - this.firstRow;
        int n5 = this.getCurrentColumn();
        int n6 = n5 / 2;
        int n7 = 9 + this.offsetViewWidth + this.hexViewWidth;
        int n8 = -this.firstColumn * this.charWidth + n7 + n6 * n2;
        int n9 = 19 - n3 + n3 * n4;
        this.caret.draw(graphics, n8, n9, n3);
    }

    private void drawCaretHexWindow(Graphics graphics, int n2, int n3) {
        int n4 = this.getCurrentRow() - this.firstRow;
        int n5 = this.getCurrentColumn();
        int n6 = 9 + this.offsetViewWidth;
        int n7 = n5 / (2 * this.bytesPerColumn) * this.columnSpacing;
        int n8 = -this.firstColumn * this.charWidth + n6 + n5 * n2 + n7;
        int n9 = 19 - n3 + n3 * n4;
        this.caret.draw(graphics, n8, n9, n3);
    }

    private void drawHexView(Graphics graphics) {
        int n2;
        int n3;
        int n4 = 2 * this.getCharacterWidth(graphics);
        int n5 = n3 = -this.firstColumn * this.charWidth + 10 + this.offsetViewWidth;
        int n6 = 16;
        boolean bl2 = true;
        byte[] byArray = null;
        if (this.status == DefinitionStatus.DEFINED) {
            n2 = this.getBytesToDraw();
            byArray = this.dataProvider.getData(this.getFirstVisibleOffset(), n2);
        } else {
            n2 = this.getMaximumVisibleBytes();
        }
        long l2 = this.getFirstVisibleOffset();
        int n7 = 0;
        while (n7 < n2) {
            ColoredRange coloredRange = this.findColoredRange(l2);
            if (n7 != 0) {
                if (n7 % this.bytesPerRow == 0) {
                    n5 = n3;
                    n6 += this.rowHeight;
                    bl2 = true;
                } else if (n7 % this.bytesPerColumn == 0) {
                    n5 += this.columnSpacing;
                    boolean bl3 = bl2 = !bl2;
                }
            }
            if (this.isEnabled()) {
                if (this.isSelectedOffset(l2)) {
                    graphics.setColor(this.selectionColor);
                    graphics.fillRect(n5, n6 - this.charHeight, 2 * this.charWidth, this.charHeight + 2);
                    graphics.setColor(bl2 ? this.fontColorHex1 : this.fontColorHex2);
                } else if (coloredRange != null && coloredRange.containsOffset(l2)) {
                    Color color = coloredRange.getBackgroundColor();
                    if (color != null) {
                        graphics.setColor(color);
                    }
                    graphics.fillRect(n5, n6 - this.charHeight, 2 * this.charWidth, this.charHeight + 2);
                    if (coloredRange.getColor() != null) {
                        graphics.setColor(coloredRange.getColor());
                    } else {
                        graphics.setColor(bl2 ? this.fontColorHex1 : this.fontColorHex2);
                    }
                } else if (this.colormap != null && this.colormap.colorize(byArray, n7)) {
                    Color color = this.colormap.getBackgroundColor(byArray, n7);
                    Color color2 = this.colormap.getForegroundColor(byArray, n7);
                    if (color != null) {
                        graphics.setColor(color);
                        graphics.fillRect(n5, n6 - this.charHeight, 2 * this.charWidth, this.charHeight + 2);
                    }
                    if (color2 != null) {
                        graphics.setColor(color2);
                    }
                } else {
                    graphics.setColor(bl2 ? this.fontColorHex1 : this.fontColorHex2);
                }
            } else {
                graphics.setColor(this.disabledColor != this.bgColorHex ? this.disabledColor : Color.WHITE);
            }
            if (this.status == DefinitionStatus.DEFINED) {
                int n8 = Math.min(this.dataProvider.getDataLength() - n7, this.bytesPerColumn);
                int n9 = this.flipBytes ? n7 / this.bytesPerColumn * this.bytesPerColumn + (n8 - n7 % n8 - 1) : n7;
                graphics.drawString(HEX_BYTES[byArray[n9] & 0xFF], n5, n6);
            } else {
                graphics.drawString("??", n5, n6);
            }
            n5 += n4;
            ++n7;
            ++l2;
        }
    }

    private void drawMouseOverHighlighting(Graphics graphics) {
        Rectangle rectangle;
        Views views;
        graphics.setColor(this.colorHighlight);
        this.lastHighlightedNibble = this.getNibbleAtCoordinate(this.lastMouseX, this.lastMouseY);
        if (this.lastHighlightedNibble == -1) {
            return;
        }
        Views views2 = views = this.lastMouseX >= this.getAsciiViewLeft() ? Views.ASCII_VIEW : Views.HEX_VIEW;
        if (views == Views.HEX_VIEW) {
            rectangle = this.getNibbleBoundsHex(this.lastHighlightedNibble);
            graphics.fillRect((int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
        } else if (views == Views.ASCII_VIEW) {
            int n2 = 2 * this.lastHighlightedNibble / 2;
            Rectangle rectangle2 = this.getNibbleBoundsHex(n2);
            graphics.fillRect((int)rectangle2.getX(), (int)rectangle2.getY(), (int)rectangle2.getWidth(), (int)rectangle2.getHeight());
            rectangle2 = this.getNibbleBoundsHex(n2 + 1);
            graphics.fillRect((int)rectangle2.getX(), (int)rectangle2.getY(), (int)rectangle2.getWidth(), (int)rectangle2.getHeight());
        }
        rectangle = this.getByteBoundsAscii(this.lastHighlightedNibble);
        graphics.fillRect((int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
    }

    private void drawOffsets(Graphics graphics) {
        if (this.isEnabled()) {
            graphics.setColor(this.fontColorOffsets);
        } else {
            graphics.setColor(this.disabledColor != this.bgColorOffset ? this.disabledColor : Color.WHITE);
        }
        int n2 = -this.firstColumn * this.charWidth + 10;
        int n3 = this.getMaximumVisibleBytes();
        String string = this.addressMode == AddressMode.BIT32 ? "%08X" : "%016X";
        for (int i2 = 0; i2 < n3; i2 += this.bytesPerRow) {
            long l2 = this.baseAddress + (long)(this.firstRow * this.bytesPerRow) + (long)i2;
            String string2 = String.format(string, l2);
            int n4 = i2 / this.bytesPerRow;
            graphics.drawString(string2, n2, 16 + n4 * this.rowHeight);
        }
    }

    private ColoredRange findColoredRange(long l2) {
        for (ColoredRangeManager coloredRangeManager : this.coloredRanges) {
            ColoredRange coloredRange = coloredRangeManager.findRangeWith(l2);
            if (coloredRange == null) continue;
            return coloredRange;
        }
        return null;
    }

    private int getAsciiViewLeft() {
        return this.getHexViewLeft() + this.getHexViewWidth();
    }

    private Rectangle getByteBoundsAscii(int n2) {
        if (n2 < 2 * this.getFirstVisibleByte()) {
            return new Rectangle(-1, -1, -1, -1);
        }
        if (n2 > 2 * this.getFirstVisibleByte() + 2 * this.getMaximumVisibleBytes()) {
            return new Rectangle(-1, -1, -1, -1);
        }
        int n3 = (n2 - 2 * this.getFirstVisibleByte()) / 2;
        int n4 = n3 / this.bytesPerRow;
        int n5 = n3 % this.bytesPerRow;
        int n6 = this.getAsciiViewLeft() + 10 + n5 * this.charWidth;
        int n7 = 16 - this.charHeight + n4 * this.rowHeight;
        return new Rectangle(n6, n7, this.charWidth, this.charHeight);
    }

    private int getBytesToDraw() {
        int n2 = this.getFirstVisibleByte();
        int n3 = this.getMaximumVisibleBytes();
        int n4 = this.dataProvider.getDataLength() - n2;
        return Math.min(n3, n4);
    }

    private int getCharacterWidth(Graphics graphics) {
        return (int)graphics.getFontMetrics().getStringBounds("0", graphics).getWidth();
    }

    private int getCharHeight(Graphics graphics) {
        return graphics.getFontMetrics().getAscent();
    }

    private int getColumnSize() {
        return 2 * this.bytesPerColumn * this.charWidth + this.columnSpacing;
    }

    private int getCurrentColumn() {
        return (int)this.getCurrentNibble() % (2 * this.bytesPerRow);
    }

    private long getCurrentNibble() {
        return this.getSelectionStart() + this.getSelectionLength();
    }

    private int getCurrentRow() {
        return (int)this.getCurrentNibble() / (2 * this.bytesPerRow);
    }

    private int getEarlierBytes() {
        return this.firstRow * this.bytesPerRow;
    }

    private int getFirstVisibleByte() {
        return this.firstRow * this.bytesPerRow;
    }

    private int getHexViewLeft() {
        return -this.firstColumn * this.charWidth + this.offsetViewWidth;
    }

    private int getMaximumVisibleBytes() {
        return this.getNumberOfVisibleRows() * this.bytesPerRow;
    }

    private int getNibbleAtCoordinate(int n2, int n3) {
        if (this.dataProvider == null) {
            return -1;
        }
        if (n2 < this.getHexViewLeft() + 10) {
            return -1;
        }
        if (n3 >= 16 - this.font.getSize()) {
            if (n2 >= this.getHexViewLeft() && n2 < this.getHexViewLeft() + this.getHexViewWidth()) {
                return this.getNibbleAtCoordinatesHex(n2, n3);
            }
            if (n2 >= this.getAsciiViewLeft()) {
                return this.getNibbleAtCoordinatesAscii(n2, n3);
            }
        }
        return -1;
    }

    private int getNibbleAtCoordinatesAscii(int n2, int n3) {
        int n4 = n2 - (this.getAsciiViewLeft() + 10);
        if (n4 < 0) {
            return -1;
        }
        int n5 = (n3 - (16 - this.charHeight)) / this.rowHeight;
        int n6 = 2 * this.getEarlierBytes();
        if (n4 / this.charWidth >= this.bytesPerRow) {
            return -1;
        }
        int n7 = 2 * (n4 / this.charWidth);
        int n8 = n6 + 2 * n5 * this.bytesPerRow + n7;
        if (n8 >= 2 * this.dataProvider.getDataLength()) {
            return -1;
        }
        return n8;
    }

    private int getNibbleAtCoordinatesHex(int n2, int n3) {
        int n4;
        int n5 = n2 - (this.getHexViewLeft() + 10);
        int n6 = n5 / (n4 = this.getColumnSize());
        if (n6 >= this.bytesPerRow / this.bytesPerColumn) {
            return -1;
        }
        int n7 = n5 % n4;
        int n8 = n7 / this.charWidth;
        if (n8 >= 2 * this.bytesPerColumn) {
            return -1;
        }
        int n9 = (n3 - (16 - this.charHeight)) / this.rowHeight;
        int n10 = 2 * this.getEarlierBytes();
        int n11 = n10 + 2 * (n9 * this.bytesPerRow + n6 * this.bytesPerColumn) + n8;
        if (n11 >= 2 * this.dataProvider.getDataLength()) {
            return -1;
        }
        return n11;
    }

    private Rectangle getNibbleBoundsHex(int n2) {
        if (n2 < 2 * this.getFirstVisibleByte()) {
            return new Rectangle(-1, -1, -1, -1);
        }
        if (n2 > 2 * this.getFirstVisibleByte() + 2 * this.getMaximumVisibleBytes()) {
            return new Rectangle(-1, -1, -1, -1);
        }
        int n3 = n2 - 2 * this.getFirstVisibleByte();
        int n4 = this.getColumnSize();
        int n5 = n3 / (2 * this.bytesPerRow);
        int n6 = n3 % (2 * this.bytesPerRow) / (2 * this.bytesPerColumn);
        int n7 = n3 % (2 * this.bytesPerRow) % (2 * this.bytesPerColumn);
        int n8 = this.getHexViewLeft() + 10 + n6 * n4 + n7 * this.charWidth;
        int n9 = 16 - this.charHeight + n5 * this.rowHeight;
        return new Rectangle(n8, n9, this.charWidth, this.charHeight);
    }

    private int getNumberOfVisibleRows() {
        int n2 = this.getHeight() - 16 - this.horizontalScrollbar.getHeight();
        return n2 / this.rowHeight + (n2 % this.rowHeight == 0 ? 0 : 1);
    }

    private int getRowHeight(Graphics graphics) {
        return graphics.getFontMetrics().getHeight();
    }

    private long getSelectionStart() {
        return this.selectionStart;
    }

    private void initHotkeys() {
        this.setFocusTraversalKeys(0, new HashSet());
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(37, 0), "LEFT");
        actionMap.put("LEFT", this.leftAction);
        inputMap.put(KeyStroke.getKeyStroke(37, 64), "shift LEFT");
        actionMap.put("shift LEFT", this.leftAction);
        inputMap.put(KeyStroke.getKeyStroke(39, 0), "RIGHT");
        actionMap.put("RIGHT", this.rightAction);
        inputMap.put(KeyStroke.getKeyStroke(39, 64), "shift RIGHT");
        actionMap.put("shift RIGHT", this.rightAction);
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "UP");
        actionMap.put("UP", this.upAction);
        inputMap.put(KeyStroke.getKeyStroke(38, 64), "shift UP");
        actionMap.put("shift UP", this.upAction);
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "DOWN");
        actionMap.put("DOWN", this.downAction);
        inputMap.put(KeyStroke.getKeyStroke(40, 64), "shift DOWN");
        actionMap.put("shift DOWN", this.downAction);
        inputMap.put(KeyStroke.getKeyStroke(34, 0), "PAGE_DOWN");
        actionMap.put("PAGE_DOWN", this.pageDownAction);
        inputMap.put(KeyStroke.getKeyStroke(34, 64), "shift PAGE_DOWN");
        actionMap.put("shift PAGE_DOWN", this.pageDownAction);
        inputMap.put(KeyStroke.getKeyStroke(33, 0), "PAGE_UP");
        actionMap.put("PAGE_UP", this.pageUpAction);
        inputMap.put(KeyStroke.getKeyStroke(33, 64), "shift PAGE_UP");
        actionMap.put("shift PAGE_UP", this.pageUpAction);
        inputMap.put(KeyStroke.getKeyStroke(9, 0), "TAB");
        actionMap.put("TAB", this.tabAction);
    }

    private void initListeners() {
        this.addMouseListener(this.listener);
        this.addMouseMotionListener(this.listener);
        this.addMouseWheelListener(this.listener);
        this.addFocusListener(this.listener);
        this.addComponentListener(this.listener);
        this.addKeyListener(this.listener);
        this.caret.addCaretListener(this.listener);
    }

    private void initScrollbar() {
        this.scrollbar.addAdjustmentListener(this.listener);
        this.add((Component)this.scrollbar, "East");
        this.horizontalScrollbar.addAdjustmentListener(this.listener);
        this.add((Component)this.horizontalScrollbar, "South");
    }

    private boolean isDataAvailable() {
        return this.dataProvider != null;
    }

    private boolean isInsideAsciiView(int n2, int n3) {
        return n3 >= 16 - this.font.getSize() && n2 >= this.getAsciiViewLeft();
    }

    private boolean isInsideHexView(int n2, int n3) {
        return n3 >= 16 - this.font.getSize() && n2 >= this.getHexViewLeft() && n2 < this.getHexViewLeft() + this.getHexViewWidth();
    }

    private boolean isPositionVisible(long l2) {
        int n2 = this.getFirstVisibleByte();
        int n3 = n2 + this.getMaximumVisibleBytes();
        return l2 >= (long)(2 * n2) && l2 <= (long)(2 * n3);
    }

    private boolean isSelectedOffset(long l2) {
        l2 -= this.baseAddress;
        if (this.getSelectionLength() == 0L) {
            return false;
        }
        if (this.getSelectionLength() > 0L) {
            return l2 >= this.getSelectionStart() / 2L && 2L * l2 < this.getSelectionStart() + this.getSelectionLength();
        }
        return l2 >= (this.getSelectionStart() + this.getSelectionLength()) / 2L && 2L * l2 < this.getSelectionStart();
    }

    private void resetBufferedGraphic() {
        this.bufferGraphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        this.bufferGraphics.setFont(this.font);
    }

    private void scrollToPosition(long l2) {
        this.scrollbar.setValue((int)l2 / (2 * this.bytesPerRow));
    }

    private void setCurrentPosition(long l2) {
        this.selectionStart = l2;
        if (!this.isPositionVisible(this.getSelectionStart())) {
            this.scrollToPosition(this.getSelectionStart());
        }
        for (IHexPanelListener iHexPanelListener : this.listeners) {
            iHexPanelListener.selectionChanged(this.getSelectionStart(), 1L);
        }
    }

    private void setScrollBarMaximum() {
        if (this.dataProvider == null) {
            this.scrollbar.setMaximum(1);
            this.horizontalScrollbar.setMaximum(1);
        } else {
            int n2 = this.getNumberOfVisibleRows();
            int n3 = this.dataProvider.getDataLength() / this.bytesPerRow;
            int n4 = 2 + n3 - n2;
            if (n4 < 0) {
                n4 = 0;
                this.scrollbar.setValue(0);
                this.scrollbar.setEnabled(false);
            } else {
                this.scrollbar.setEnabled(true);
            }
            this.scrollbar.setMaximum(n4);
            int n5 = this.getAsciiViewLeft() + 10 + this.charWidth * this.bytesPerRow;
            int n6 = this.getWidth() - this.scrollbar.getWidth();
            if (n6 >= n5) {
                this.horizontalScrollbar.setValue(0);
                this.horizontalScrollbar.setEnabled(false);
            } else {
                this.horizontalScrollbar.setMaximum((n5 - n6) / this.charWidth + 1);
                this.horizontalScrollbar.setEnabled(true);
            }
        }
    }

    private void setSelectionStart(long l2) {
        this.selectionStart = l2;
        for (IHexPanelListener iHexPanelListener : this.listeners) {
            iHexPanelListener.selectionChanged(this.selectionStart, this.m_selectionLength);
        }
    }

    private void updateHexViewWidth() {
        this.hexViewWidth = 15 + this.getColumnSize() * this.getBytesPerRow() / this.getBytesPerColumn();
    }

    private void updateOffsetViewWidth() {
        int n2 = this.addressMode == AddressMode.BIT32 ? 8 : 16;
        this.offsetViewWidth = 20 + this.charWidth * n2;
    }

    private void updatePreferredSize() {
        int n2 = this.offsetViewWidth + this.hexViewWidth + 18 * this.charWidth + this.scrollbar.getWidth();
        this.setPreferredSize(new Dimension(n2, this.getHeight()));
        this.revalidate();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n2;
        super.paintComponent(graphics);
        this.resetBufferedGraphic();
        this.calculateSizes();
        this.updateOffsetViewWidth();
        if (this.firstDraw) {
            this.firstDraw = false;
            this.updateHexViewWidth();
            this.updatePreferredSize();
        }
        this.drawBackground(this.bufferGraphics);
        this.drawOffsets(this.bufferGraphics);
        if (this.isEnabled()) {
            this.drawMouseOverHighlighting(this.bufferGraphics);
        }
        if (this.status == DefinitionStatus.DEFINED && this.dataProvider != null && (n2 = this.getBytesToDraw()) != 0 && !this.dataProvider.hasData(this.getFirstVisibleOffset(), n2)) {
            this.setDefinitionStatus(DefinitionStatus.UNDEFINED);
            this.setEnabled(false);
            if (this.updateTimer != null) {
                this.updateTimer.setRepeats(false);
                this.updateTimer.stop();
            }
            this.updateTimer = new Timer(1000, new WaitingForDataAction(this.getFirstVisibleOffset(), n2));
            this.updateTimer.setRepeats(true);
            this.updateTimer.start();
            return;
        }
        if (this.isDataAvailable() || this.status == DefinitionStatus.UNDEFINED) {
            this.drawHexView(this.bufferGraphics);
            this.drawAsciiPanel(this.bufferGraphics);
            if (this.caret.isVisible() && this.hasFocus()) {
                this.drawCaret(this.bufferGraphics);
            }
        }
        graphics.drawImage(this.img, 0, 0, this);
    }

    public void addHexListener(IHexPanelListener iHexPanelListener) {
        Preconditions.checkNotNull(iHexPanelListener, "Error: Listener can't be null");
        if (!this.listeners.contains(iHexPanelListener)) {
            this.listeners.add(iHexPanelListener);
        }
    }

    public void colorize(int n2, long l2, int n3, Color color, Color color2) {
        Preconditions.checkArgument(l2 >= 0L, "Error: offset argument must be greater or equal to zero");
        Preconditions.checkArgument(n3 >= 0, "Error: size argument must be greater or equal to zero");
        Preconditions.checkArgument(n2 >= 0 && n2 < this.coloredRanges.length, "Error: level argument must be greater or equal to zero");
        this.coloredRanges[n2].addRange(new ColoredRange(l2, n3, color, color2));
        this.repaint();
    }

    public void dispose() {
        this.removeMouseListener(this.listener);
        this.removeMouseMotionListener(this.listener);
        this.removeMouseWheelListener(this.listener);
        this.removeFocusListener(this.listener);
        this.removeComponentListener(this.listener);
        this.removeKeyListener(this.listener);
        this.caret.removeListener(this.listener);
        this.caret.stop();
    }

    public boolean doFlipBytes() {
        return this.flipBytes;
    }

    public AddressMode getAddressMode() {
        return this.addressMode;
    }

    public Color getBackgroundColorAsciiView() {
        return this.bgColorAscii;
    }

    public Color getBackgroundColorHexView() {
        return this.bgColorHex;
    }

    public Color getBackgroundColorOffsetView() {
        return this.bgColorOffset;
    }

    public long getBaseAddress() {
        return this.baseAddress;
    }

    public int getBytesPerColumn() {
        return this.bytesPerColumn;
    }

    public int getBytesPerRow() {
        return this.bytesPerRow;
    }

    public int getColumnSpacing() {
        return this.columnSpacing;
    }

    public long getCurrentOffset() {
        long l2 = this.baseAddress + this.getCurrentNibble() / 2L;
        return this.flipBytes ? (l2 & (long)(-this.bytesPerColumn)) + (long)this.bytesPerColumn - l2 % (long)this.bytesPerColumn - 1L : l2;
    }

    public IDataProvider getData() {
        return this.dataProvider;
    }

    public DefinitionStatus getDefinitionStatus() {
        return this.status;
    }

    public long getFirstSelectedOffset() {
        if (this.m_selectionLength >= 0L) {
            return (this.baseAddress + this.selectionStart) / 2L;
        }
        return (this.baseAddress + this.selectionStart + this.m_selectionLength) / 2L;
    }

    public long getFirstVisibleOffset() {
        return this.getBaseAddress() + (long)this.getFirstVisibleByte();
    }

    public Color getFontColorAsciiView() {
        return this.fontColorAscii;
    }

    public Color getFontColorHexView1() {
        return this.fontColorHex1;
    }

    public Color getFontColorHexView2() {
        return this.fontColorHex2;
    }

    public Color getFontColorOffsetView() {
        return this.fontColorOffsets;
    }

    public int getFontSize() {
        return this.font.getSize();
    }

    public int getHexViewWidth() {
        return this.hexViewWidth;
    }

    public long getLastOffset() {
        return this.getBaseAddress() + (long)this.dataProvider.getDataLength();
    }

    public long getLastSelectedOffset() {
        if (this.m_selectionLength >= 0L) {
            return (this.baseAddress + this.selectionStart + this.m_selectionLength) / 2L + (this.baseAddress + this.selectionStart + this.m_selectionLength) % 2L;
        }
        return (this.baseAddress + this.selectionStart) / 2L + (this.baseAddress + this.selectionStart) % 2L;
    }

    public long getSelectionLength() {
        return this.m_selectionLength;
    }

    public int getVisibleBytes() {
        int n2 = this.getMaximumVisibleBytes();
        if (this.dataProvider.getDataLength() - this.getFirstVisibleByte() >= n2) {
            return n2;
        }
        return this.dataProvider.getDataLength() - this.getFirstVisibleByte();
    }

    public void gotoOffset(long l2) {
        Preconditions.checkNotNull(this.dataProvider, "Error: No data provider active");
        if (this.getCurrentOffset() == l2) {
            if (!this.isPositionVisible(this.getSelectionStart())) {
                this.scrollToPosition(this.getSelectionStart());
            }
            return;
        }
        long l3 = l2 < this.baseAddress ? l2 : l2 - this.baseAddress;
        if (l3 < 0L || l3 >= (long)this.dataProvider.getDataLength()) {
            throw new IllegalArgumentException("Error: Invalid offset");
        }
        this.setCurrentPosition(2L * l3);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void removeHexListener(IHexPanelListener iHexPanelListener) {
        Preconditions.checkNotNull(iHexPanelListener, "Internal Error: Listener can't be null");
        if (!this.listeners.remove(iHexPanelListener)) {
            throw new IllegalArgumentException("Internal Error: Listener was not listening on object");
        }
    }

    public void setAddressMode(AddressMode addressMode) {
        this.addressMode = Preconditions.checkNotNull(addressMode, "Error: Address mode can't be null");
        this.updateOffsetViewWidth();
        this.updatePreferredSize();
    }

    public void setBackgroundColorAsciiView(Color color) {
        this.bgColorAscii = Preconditions.checkNotNull(color, "Error: Color can't be null");
        this.repaint();
    }

    public void setBackgroundColorHexView(Color color) {
        this.bgColorHex = Preconditions.checkNotNull(color, "Error: Color can't be null");
        this.repaint();
    }

    public void setBackgroundColorOffsetView(Color color) {
        this.bgColorOffset = Preconditions.checkNotNull(color, "Error: Color can't be null");
        this.repaint();
    }

    public void setBaseAddress(long l2) {
        Preconditions.checkArgument(l2 >= 0L, "Error: Base address can't be negative");
        this.baseAddress = l2;
        this.repaint();
    }

    public void setBytesPerColumn(int n2) {
        Preconditions.checkArgument(n2 > 0, "Error: Number of bytes must be positive");
        Preconditions.checkArgument(n2 <= this.bytesPerRow, "Error: Number of bytes can't be more than the number of bytes per row");
        this.bytesPerColumn = n2;
        this.updateHexViewWidth();
        this.updatePreferredSize();
        this.repaint();
    }

    public void setBytesPerRow(int n2) {
        Preconditions.checkArgument(n2 > 0, "Error: Value must be positive");
        this.bytesPerRow = n2;
        this.repaint();
    }

    public void setColormap(IColormap iColormap) {
        this.colormap = Preconditions.checkNotNull(iColormap, "Error: colormap argument can not be null");
        this.repaint();
    }

    public void setColumnSpacing(int n2) {
        Preconditions.checkArgument(n2 > 0, "Error: Spacing must be positive");
        this.columnSpacing = n2;
        this.repaint();
    }

    public void setCurrentOffset(long l2) {
        if (this.dataProvider == null) {
            return;
        }
        Preconditions.checkArgument(l2 >= this.getBaseAddress() || l2 <= this.getBaseAddress() + (long)this.dataProvider.getDataLength(), "Error: Invalid offset");
        this.setCurrentPosition(2L * (l2 - this.baseAddress));
    }

    public void setData(IDataProvider iDataProvider) {
        if (this.dataProvider != null) {
            this.dataProvider.removeListener(this.listener);
        }
        this.dataProvider = iDataProvider;
        if (iDataProvider != null) {
            this.dataProvider.addListener(this.listener);
        }
        this.setCurrentPosition(0L);
        this.setScrollBarMaximum();
        this.repaint();
    }

    public void setDefinitionStatus(DefinitionStatus definitionStatus) {
        this.status = Preconditions.checkNotNull(definitionStatus, "Error: Definition status can't be null");
        this.repaint();
    }

    @Override
    public void setEnabled(boolean bl2) {
        if (bl2 == this.enabled) {
            return;
        }
        this.enabled = bl2;
        this.repaint();
    }

    public void setFlipBytes(boolean bl2) {
        if (this.flipBytes == bl2) {
            return;
        }
        this.flipBytes = bl2;
        this.repaint();
    }

    public void setFontColorAsciiView(Color color) {
        this.fontColorAscii = Preconditions.checkNotNull(color, "Error: Color can't be null");
        this.repaint();
    }

    public void setFontColorHexView1(Color color) {
        this.fontColorHex1 = Preconditions.checkNotNull(color, "Error: Color can't be null");
        this.repaint();
    }

    public void setFontColorHexView2(Color color) {
        this.fontColorHex2 = Preconditions.checkNotNull(color, "Error: Color can't be null");
        this.repaint();
    }

    public void setFontColorOffsetView(Color color) {
        this.fontColorOffsets = Preconditions.checkNotNull(color, "Error: Color can't be null");
        this.repaint();
    }

    public void setFontSize(int n2) {
        Preconditions.checkArgument(n2 > 0, "Error: Font size must be positive");
        this.font = GuiHelper.getMonospacedFont().deriveFont(n2);
        this.setFont(this.font);
        this.firstDraw = true;
        this.repaint();
    }

    public void setHexViewWidth(int n2) {
        Preconditions.checkArgument(n2 > 0, "Error: Width must be positive");
        this.hexViewWidth = n2;
        this.repaint();
    }

    public void setMenuCreator(IMenuCreator iMenuCreator) {
        this.menuCreator = iMenuCreator;
    }

    public void setSelectionColor(Color color) {
        this.selectionColor = Preconditions.checkNotNull(color, "Error: Color can't be null");
        this.repaint();
    }

    public void setSelectionLength(long l2) {
        this.m_selectionLength = l2;
        for (IHexPanelListener iHexPanelListener : this.listeners) {
            iHexPanelListener.selectionChanged(this.selectionStart, this.m_selectionLength);
        }
        this.repaint();
    }

    public void uncolorize(int n2, long l2, int n3) {
        Preconditions.checkArgument(l2 >= 0L, "Error: Offset can't be negative");
        Preconditions.checkArgument(n3 > 0, "Error: Size must be positive");
        Preconditions.checkArgument(n2 >= 0 && n2 < this.coloredRanges.length, "Error: Invalid level");
        this.coloredRanges[n2].removeRange(l2, n3);
        this.repaint();
    }

    public void uncolorizeAll() {
        for (ColoredRangeManager coloredRangeManager : this.coloredRanges) {
            coloredRangeManager.clear();
        }
    }

    public void uncolorizeAll(int n2) {
        this.coloredRanges[n2].clear();
        this.repaint();
    }

    public static enum DefinitionStatus {
        DEFINED,
        UNDEFINED;

    }

    public static enum AddressMode {
        BIT32,
        BIT64;

    }

    private class WaitingForDataAction
    extends AbstractAction {
        private static final long serialVersionUID = -610823391617272365L;
        private final long m_offset;
        private final int m_size;

        private WaitingForDataAction(long l2, int n2) {
            this.m_offset = l2;
            this.m_size = n2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (JHexView.this.dataProvider.hasData(this.m_offset, this.m_size)) {
                JHexView.this.setEnabled(true);
                JHexView.this.setDefinitionStatus(DefinitionStatus.DEFINED);
                ((Timer)actionEvent.getSource()).stop();
            } else if (!JHexView.this.dataProvider.keepTrying()) {
                ((Timer)actionEvent.getSource()).stop();
            }
        }
    }

    private static enum Views {
        HEX_VIEW,
        ASCII_VIEW;

    }

    private class UpAction
    extends AbstractAction {
        private static final long serialVersionUID = -3513103611571283106L;

        private UpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JHexView.this.changeBy(actionEvent, -2 * JHexView.this.bytesPerRow);
        }
    }

    private class TabAction
    extends AbstractAction {
        private static final long serialVersionUID = -3265020583339369531L;

        private TabAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (JHexView.this.activeView == Views.HEX_VIEW) {
                JHexView.this.activeView = Views.ASCII_VIEW;
                JHexView.this.setSelectionStart(JHexView.this.getSelectionStart() - JHexView.this.getSelectionStart() % 2L);
            } else {
                JHexView.this.activeView = Views.HEX_VIEW;
            }
            JHexView.this.caret.setVisible(true);
            JHexView.this.repaint();
        }
    }

    private class RightAction
    extends AbstractAction {
        private static final long serialVersionUID = 3857972387525998636L;

        private RightAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JHexView.this.changeBy(actionEvent, JHexView.this.activeView == Views.HEX_VIEW ? 1 : 2);
        }
    }

    private class PageUpAction
    extends AbstractAction {
        private static final long serialVersionUID = -7424423002191015929L;

        private PageUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JHexView.this.changeBy(actionEvent, -JHexView.this.getNumberOfVisibleRows() * JHexView.this.bytesPerRow * 2);
        }
    }

    private class PageDownAction
    extends AbstractAction {
        private static final long serialVersionUID = 490837791577654025L;

        private PageDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JHexView.this.changeBy(actionEvent, JHexView.this.getNumberOfVisibleRows() * JHexView.this.bytesPerRow * 2);
        }
    }

    private class LeftAction
    extends AbstractAction {
        private static final long serialVersionUID = -9032577023548944503L;

        private LeftAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JHexView.this.changeBy(actionEvent, JHexView.this.activeView == Views.HEX_VIEW ? -1 : -2);
        }
    }

    private class InternalListener
    implements ICaretListener,
    IDataChangedListener,
    AdjustmentListener,
    ComponentListener,
    FocusListener,
    KeyListener,
    MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private InternalListener() {
        }

        private void keyPressedInAsciiView(KeyEvent keyEvent) {
            byte[] byArray = JHexView.this.dataProvider.getData(JHexView.this.getCurrentOffset(), 1);
            if (JHexView.this.getSelectionStart() >= (long)(JHexView.this.dataProvider.getDataLength() * 2)) {
                return;
            }
            byArray[0] = (byte)keyEvent.getKeyChar();
            JHexView.this.dataProvider.setData(JHexView.this.getCurrentOffset(), byArray);
            JHexView.this.setSelectionStart(JHexView.this.getSelectionStart() + 2L);
        }

        private void keyPressedInHexView(KeyEvent keyEvent) {
            byte[] byArray = JHexView.this.dataProvider.getData(JHexView.this.getCurrentOffset(), 1);
            long l2 = JHexView.this.baseAddress + JHexView.this.getSelectionStart();
            if (JHexView.this.getSelectionStart() >= (long)(JHexView.this.dataProvider.getDataLength() * 2)) {
                return;
            }
            int n2 = Character.digit(keyEvent.getKeyChar(), 16);
            if (n2 == -1) {
                return;
            }
            byArray[0] = l2 % 2L == 0L ? (byte)(byArray[0] & 0xF | n2 << 4) : (byte)(byArray[0] & 0xF0 | n2);
            JHexView.this.dataProvider.setData(JHexView.this.getCurrentOffset(), byArray);
            JHexView.this.setSelectionStart(JHexView.this.getSelectionStart() + 1L);
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (adjustmentEvent.getSource() == JHexView.this.scrollbar) {
                JHexView.this.firstRow = adjustmentEvent.getValue();
            } else {
                JHexView.this.firstColumn = adjustmentEvent.getValue();
            }
            JHexView.this.repaint();
        }

        @Override
        public void caretStatusChanged(JCaret jCaret) {
            JHexView.this.repaint();
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            JHexView.this.setScrollBarMaximum();
            int n2 = JHexView.this.getWidth() + 1 - JHexView.this.scrollbar.getWidth();
            int n3 = JHexView.this.getHeight() + 1 - JHexView.this.horizontalScrollbar.getHeight();
            n2 = Math.max(1, n2);
            n3 = Math.max(1, n3);
            JHexView.this.img = new BufferedImage(n2, n3, 1);
            JHexView.this.bufferGraphics = JHexView.this.img.getGraphics();
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void dataChanged() {
            JHexView.this.setScrollBarMaximum();
            JHexView.this.repaint();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            JHexView.this.caret.setVisible(true);
            JHexView.this.repaint();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            JHexView.this.repaint();
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (!JHexView.this.isEnabled()) {
                return;
            }
            if (JHexView.this.activeView == Views.HEX_VIEW) {
                if (JHexView.this.dataProvider.isEditable() && Convert.isHexCharacter(keyEvent.getKeyChar())) {
                    this.keyPressedInHexView(keyEvent);
                }
            } else if (JHexView.this.dataProvider.isEditable() && Convert.isPrintableCharacter(keyEvent.getKeyChar())) {
                this.keyPressedInAsciiView(keyEvent);
            }
            JHexView.this.repaint();
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!JHexView.this.isEnabled()) {
                return;
            }
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            if (n3 < 16 - (JHexView.this.rowHeight - JHexView.this.charHeight)) {
                JHexView.this.scrollToPosition(2 * JHexView.this.getFirstVisibleByte() - 2 * JHexView.this.bytesPerRow);
                if (JHexView.this.getSelectionLength() - (long)(2 * JHexView.this.bytesPerRow) < 0L) {
                    return;
                }
                JHexView.this.setSelectionLength(JHexView.this.getSelectionLength() - (long)(2 * JHexView.this.bytesPerRow));
            } else if (n3 >= JHexView.this.rowHeight * JHexView.this.getNumberOfVisibleRows()) {
                JHexView.this.scrollToPosition(2 * JHexView.this.getFirstVisibleByte() + 2 * JHexView.this.bytesPerRow);
                if (JHexView.this.getSelectionLength() + (long)(2 * JHexView.this.bytesPerRow) > 2L * ((long)JHexView.this.dataProvider.getDataLength() - JHexView.this.getSelectionStart())) {
                    return;
                }
                JHexView.this.setSelectionLength(JHexView.this.getSelectionLength() + (long)(2 * JHexView.this.bytesPerRow));
            } else {
                int n4 = JHexView.this.getNibbleAtCoordinate(n2, n3);
                if (n4 != -1) {
                    JHexView.this.setSelectionLength((long)n4 - JHexView.this.getSelectionStart());
                    JHexView.this.repaint();
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JHexView.this.lastMouseX = mouseEvent.getX();
            JHexView.this.lastMouseY = mouseEvent.getY();
            JHexView.this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Object object;
            int n2;
            int n3;
            int n4;
            if (!JHexView.this.isEnabled()) {
                return;
            }
            if (mouseEvent.getButton() == 1 || mouseEvent.getButton() == 3) {
                JHexView.this.m_selectionLength = 0L;
                JHexView.this.requestFocusInWindow();
                n4 = mouseEvent.getX();
                n3 = mouseEvent.getY();
                n2 = JHexView.this.getNibbleAtCoordinate(n4, n3);
                if (n2 != -1) {
                    JHexView.this.caret.setVisible(true);
                    JHexView.this.setCurrentPosition(n2);
                    if (JHexView.this.isInsideHexView(n4, n3)) {
                        JHexView.this.activeView = Views.HEX_VIEW;
                    } else if (JHexView.this.isInsideAsciiView(n4, n3)) {
                        JHexView.this.activeView = Views.ASCII_VIEW;
                    }
                    JHexView.this.repaint();
                } else {
                    object = JHexView.this.listeners.iterator();
                    while (object.hasNext()) {
                        IHexPanelListener iHexPanelListener = (IHexPanelListener)object.next();
                        iHexPanelListener.selectionChanged(JHexView.this.selectionStart, JHexView.this.m_selectionLength);
                    }
                    JHexView.this.repaint();
                }
            }
            if (mouseEvent.getButton() == 3 && (n2 = JHexView.this.getNibbleAtCoordinate(n4 = mouseEvent.getX(), n3 = mouseEvent.getY())) != -1) {
                JHexView.this.caret.setVisible(true);
                if (JHexView.this.menuCreator != null && (object = JHexView.this.menuCreator.createMenu(JHexView.this.getCurrentOffset())) != null) {
                    ((JPopupMenu)object).show(JHexView.this, n4, n3);
                }
                JHexView.this.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (!JHexView.this.isEnabled()) {
                return;
            }
            int n2 = mouseWheelEvent.getWheelRotation();
            JHexView.this.scrollbar.setValue(JHexView.this.scrollbar.getValue() + n2);
        }
    }

    private class DownAction
    extends AbstractAction {
        private static final long serialVersionUID = -6501310447863685486L;

        private DownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JHexView.this.changeBy(actionEvent, 2 * JHexView.this.bytesPerRow);
        }
    }
}

