/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.LineBorder;

public class JCheckedListbox<T>
extends JList<T> {
    private final boolean[] m_selected;
    private boolean m_selectCompleteLine = true;

    public JCheckedListbox(ListModel<T> listModel) {
        super(listModel);
        this.m_selected = new boolean[listModel.getSize()];
        this.setCellRenderer(new CheckedListboxRenderer());
        this.addMouseListener(new InternalListener());
    }

    public JCheckedListbox(T[] TArray) {
        super(TArray);
        this.m_selected = new boolean[TArray.length];
        this.setCellRenderer(new CheckedListboxRenderer());
        this.addMouseListener(new InternalListener());
    }

    public JCheckedListbox(Vector<T> vector) {
        super(vector);
        this.m_selected = new boolean[vector.size()];
        this.setCellRenderer(new CheckedListboxRenderer());
        this.addMouseListener(new InternalListener());
    }

    public JCheckedListbox(Vector<T> vector, boolean bl2) {
        super(vector);
        this.m_selectCompleteLine = bl2;
        this.m_selected = new boolean[vector.size()];
        this.setCellRenderer(new CheckedListboxRenderer());
        this.addMouseListener(new InternalListener());
    }

    public boolean isChecked(int n2) {
        return this.m_selected[n2];
    }

    public void setChecked(int n2, boolean bl2) {
        this.m_selected[n2] = bl2;
        this.updateUI();
        this.fireSelectionValueChanged(n2, n2, false);
    }

    @Override
    public void updateUI() {
        super.updateUI();
    }

    private class InternalListener
    extends MouseAdapter {
        private InternalListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!JCheckedListbox.this.isEnabled()) {
                return;
            }
            if (mouseEvent.getPoint().x > 20) {
                return;
            }
            int n2 = JCheckedListbox.this.locationToIndex(mouseEvent.getPoint());
            ((JCheckedListbox)JCheckedListbox.this).m_selected[n2] = !JCheckedListbox.this.m_selected[n2];
            JCheckedListbox.this.updateUI();
            JCheckedListbox.this.fireSelectionValueChanged(n2, n2, false);
        }
    }

    private class CheckedListboxRenderer<T>
    extends JPanel
    implements ListCellRenderer<T> {
        private static final long serialVersionUID = 7446207257969469739L;
        private final JCheckBox checkBox;
        private final LineBorder SELECTED_BORDER;
        private final LineBorder UNSELECTED_BORDER;
        private final Color SELECTED_COLOR;
        private final Color UNSELECTED_COLOR;

        public CheckedListboxRenderer() {
            super(new BorderLayout());
            this.checkBox = new JCheckBox();
            this.SELECTED_BORDER = new LineBorder(Color.DARK_GRAY);
            this.UNSELECTED_BORDER = new LineBorder(Color.WHITE);
            this.SELECTED_COLOR = new Color(12439527);
            this.UNSELECTED_COLOR = Color.WHITE;
            this.setBorder(this.UNSELECTED_BORDER);
            this.setBackground(this.UNSELECTED_COLOR);
            this.checkBox.setBackground(this.UNSELECTED_COLOR);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends T> jList, T t2, int n2, boolean bl2, boolean bl3) {
            this.checkBox.setEnabled(JCheckedListbox.this.isEnabled());
            if (JCheckedListbox.this.m_selectCompleteLine) {
                this.setBorder(bl2 ? this.SELECTED_BORDER : this.UNSELECTED_BORDER);
                this.setBackground(bl2 ? this.SELECTED_COLOR : this.UNSELECTED_COLOR);
                this.checkBox.setBackground(bl2 ? this.SELECTED_COLOR : this.UNSELECTED_COLOR);
            }
            this.checkBox.setText(t2.toString());
            this.checkBox.setSelected(JCheckedListbox.this.m_selected[n2]);
            this.checkBox.updateUI();
            this.add((Component)this.checkBox, "West");
            return this;
        }
    }
}

