/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.JCaret;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.JCaret.ICaretListener;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;

public class JCaret {
    private static final int DEFAULT_BLINK_TIME = 600;
    private static final Color DEFAULT_CARET_COLOR = Color.RED;
    private final List<ICaretListener> m_listeners = new ArrayList<ICaretListener>();
    private final Timer m_caretTimer;
    private boolean m_isCaretVisible = false;
    private final Color m_caretColor = Color.RED;
    private final InternalListener m_listener = new InternalListener();

    public JCaret() {
        this(600, DEFAULT_CARET_COLOR);
    }

    public JCaret(Color color) {
        this(600, color);
    }

    public JCaret(int n2) {
        this(n2, DEFAULT_CARET_COLOR);
    }

    public JCaret(int n2, Color color) {
        Preconditions.checkArgument(n2 >= 0, "Error: Blink period can't be negative");
        Preconditions.checkNotNull(color, "Error: Caret color can't be null");
        this.m_caretTimer = new Timer(n2, this.m_listener);
        this.m_caretTimer.setRepeats(true);
        this.m_caretTimer.start();
    }

    private void notifyListeners() {
        for (ICaretListener iCaretListener : this.m_listeners) {
            iCaretListener.caretStatusChanged(this);
        }
    }

    public void addCaretListener(ICaretListener iCaretListener) {
        Preconditions.checkNotNull(iCaretListener, "Error: Listener can't be null");
        if (!this.m_listeners.contains(iCaretListener)) {
            this.m_listeners.add(iCaretListener);
        }
    }

    public void draw(Graphics graphics, int n2, int n3, int n4) {
        Preconditions.checkNotNull(graphics, "Error: Graphics context can't be null");
        if (this.isVisible()) {
            Color color = graphics.getColor();
            graphics.setColor(this.m_caretColor);
            graphics.drawLine(n2, n3, n2, n3 + n4 - 1);
            graphics.setColor(color);
        }
    }

    public boolean isVisible() {
        return this.m_isCaretVisible;
    }

    public void removeListener(ICaretListener iCaretListener) {
        this.m_listeners.remove(iCaretListener);
    }

    public void setVisible(boolean bl2) {
        this.m_isCaretVisible = bl2;
        this.notifyListeners();
    }

    public void stop() {
        this.m_caretTimer.stop();
        this.m_caretTimer.removeActionListener(this.m_listener);
        this.setVisible(false);
    }

    private class InternalListener
    implements ActionListener {
        private InternalListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JCaret.this.m_isCaretVisible = !JCaret.this.m_isCaretVisible;
            JCaret.this.notifyListeners();
        }
    }
}

