/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class GuiHelper
implements WindowStateListener {
    public static final int DEFAULT_FONTSIZE = 13;
    private static final GuiHelper instance = new GuiHelper();
    private Field metacityWindowManager = null;
    private Field awtWindowManager = null;
    private boolean needsWindowFix = false;
    private Font defaultFont = new Font("SansSerif", 0, 13);
    private FontMetrics defaultFontMetrics = null;
    private Font monospacedFont = new Font("Monospaced", 0, 13);
    private FontMetrics monospacedFontMetrics = null;

    private GuiHelper() {
        List<String> list = Arrays.asList("gnome", "gnome-shell", "mate", "cinnamon");
        String string = System.getenv("DESKTOP_SESSION");
        if (string != null && list.contains(string.toLowerCase())) {
            try {
                Class<?> clazz = Class.forName("sun.awt.X11.XWM");
                this.awtWindowManager = clazz.getDeclaredField("awt_wmgr");
                this.awtWindowManager.setAccessible(true);
                Field field = clazz.getDeclaredField("OTHER_WM");
                field.setAccessible(true);
                if (this.awtWindowManager.get(null).equals(field.get(null))) {
                    this.metacityWindowManager = clazz.getDeclaredField("METACITY_WM");
                    this.metacityWindowManager.setAccessible(true);
                    this.needsWindowFix = true;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void windowStateChanged(WindowEvent windowEvent) {
        try {
            this.awtWindowManager.set(null, this.metacityWindowManager.get(null));
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    public static void applyWindowFix(Window window) {
        if (!GuiHelper.instance.needsWindowFix) {
            return;
        }
        window.removeWindowStateListener(instance);
        window.addWindowStateListener(instance);
        instance.windowStateChanged(null);
    }

    public static void centerChildToParent(Component component, Component component2, boolean bl2) {
        int n2 = component.getX() + component.getWidth() / 2 - component2.getWidth() / 2;
        int n3 = component.getY() + component.getHeight() / 2 - component2.getHeight() / 2;
        if (bl2) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = new Dimension(toolkit.getScreenSize());
            if ((double)(n2 + component2.getWidth()) > dimension.getWidth()) {
                n2 = (int)(dimension.getWidth() - (double)component2.getWidth());
            }
            if ((double)(n3 + component2.getHeight()) > dimension.getHeight()) {
                n3 = (int)(dimension.getHeight() - (double)component2.getHeight());
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n3 < 0) {
                n3 = 0;
            }
        }
        component2.setLocation(n2, n3);
    }

    public static void centerOnScreen(Window window) {
        window.setLocationRelativeTo(null);
    }

    public static JComponent findComponentByPredicate(JComponent jComponent, ComponentFilter componentFilter) {
        for (Component component : jComponent.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            if (componentFilter.accept((JComponent)component)) {
                return (JComponent)component;
            }
            JComponent jComponent2 = GuiHelper.findComponentByPredicate((JComponent)component, componentFilter);
            if (jComponent2 == null) continue;
            return jComponent2;
        }
        return null;
    }

    public static void setDefaultFont(Font font) {
        GuiHelper.instance.defaultFont = font;
        GuiHelper.instance.defaultFontMetrics = new JLabel().getFontMetrics(font);
    }

    public static Font getDefaultFont() {
        return GuiHelper.instance.defaultFont;
    }

    public static void setMonospacedFont(Font font) {
        GuiHelper.instance.monospacedFont = font;
        GuiHelper.instance.monospacedFontMetrics = new JLabel().getFontMetrics(font);
    }

    public static Font getMonospacedFont() {
        return GuiHelper.instance.monospacedFont;
    }

    public static FontMetrics getMonospacedFontMetrics() {
        return GuiHelper.instance.monospacedFontMetrics;
    }

    public static interface ComponentFilter {
        public boolean accept(JComponent var1);
    }
}

