/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.ColorPanel;

import com.google.security.zynamics.zylib.general.Convert;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.CColorChooser;
import com.google.security.zynamics.zylib.gui.ColorPanel.IColorPanelListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public class ColorPanel
extends JPanel {
    private final ListenerProvider<IColorPanelListener> m_listeners = new ListenerProvider();
    private boolean m_editable = true;
    private final boolean m_showColorText;
    private final JLabel m_textLabel = new JLabel("");
    private Set<Color> m_defaultColors = null;

    public ColorPanel(Color color) {
        this(color, false, false);
    }

    public ColorPanel(Color color, boolean bl2) {
        this(color, bl2, false);
    }

    public ColorPanel(Color color, boolean bl2, boolean bl3) {
        super(new BorderLayout());
        this.m_editable = bl2;
        this.m_showColorText = bl3;
        this.setColor(color);
        this.setBackground(color);
        this.m_textLabel.setHorizontalAlignment(0);
        this.add((Component)this.m_textLabel, "Center");
        this.setBorder(new LineBorder(Color.BLACK));
        this.setPreferredSize(new Dimension(100, 20));
        this.addMouseListener(new InternalListener());
        this.updateUI();
    }

    public ColorPanel(Color color, boolean bl2, boolean bl3, Set<Color> set) {
        this(color, bl2, bl3);
        this.m_defaultColors = set;
        this.setColor(color);
    }

    private void chooseColor() {
        Color color = CColorChooser.showDialog((Component)this, "Color Chooser", this.getBackground(), this.m_defaultColors == null ? null : this.m_defaultColors.toArray(new Color[0]));
        if (color != null) {
            this.setColor(color);
        }
    }

    private void setTextColor(Color color) {
        if (this.m_showColorText) {
            float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            if ((double)fArray[2] > 0.65) {
                Color color2 = new Color(32, 32, 32);
                this.m_textLabel.setForeground(color2);
            } else {
                Color color3 = new Color(222, 222, 222);
                this.m_textLabel.setForeground(color3);
            }
            this.updateUI();
        }
    }

    public void addListener(IColorPanelListener iColorPanelListener) {
        this.m_listeners.addListener(iColorPanelListener);
    }

    public Color getColor() {
        return this.getBackground();
    }

    public void removeListener(IColorPanelListener iColorPanelListener) {
        this.m_listeners.removeListener(iColorPanelListener);
    }

    public void setColor(Color color) {
        this.setBackground(color);
        if (this.m_showColorText) {
            this.setTextColor(color);
            this.m_textLabel.setText(String.format("#%s (%d, %d, %d)", Convert.colorToHexString(color).toUpperCase(), color.getRed(), color.getGreen(), color.getBlue()));
            this.m_textLabel.updateUI();
        }
        for (IColorPanelListener iColorPanelListener : this.m_listeners) {
            iColorPanelListener.changedColor(this);
        }
    }

    public void setEditable(boolean bl2) {
        this.m_editable = bl2;
    }

    public void setText(String string) {
        if (this.m_showColorText) {
            this.m_textLabel.setText(string);
        }
    }

    private class InternalListener
    extends MouseAdapter {
        private InternalListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (ColorPanel.this.m_editable && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 1) {
                ColorPanel.this.chooseColor();
            }
        }
    }
}

