/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.CodeDisplay;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.text.AttributedString;

public class FormattedCharacterBuffer {
    private char[] charBuffer = new char[0];
    private Font[] perCharFonts = new Font[0];
    private static final Font DEFAULT_FONT = new Font("Monospaced", 0, 12);
    private Color[] perCharForegroundColor = new Color[0];
    private Color defaultForegroundColor = Color.BLACK;
    private Color[] perCharBackgroundColor = new Color[0];
    private Color defaultBackgroundColor = Color.WHITE;
    private int numberOfLinesInBuffer;
    private int numberOfColumnsInBuffer;

    public FormattedCharacterBuffer(int n2, int n3) {
        this.numberOfLinesInBuffer = n2;
        this.numberOfColumnsInBuffer = n3;
        this.charBuffer = new char[this.numberOfLinesInBuffer * this.numberOfColumnsInBuffer];
        this.perCharFonts = new Font[this.numberOfLinesInBuffer * this.numberOfColumnsInBuffer];
        this.perCharForegroundColor = new Color[this.numberOfLinesInBuffer * this.numberOfColumnsInBuffer];
        this.perCharBackgroundColor = new Color[this.numberOfLinesInBuffer * this.numberOfColumnsInBuffer];
        this.clear();
    }

    public void clear() {
        for (int i2 = 0; i2 < this.numberOfLinesInBuffer * this.numberOfColumnsInBuffer; ++i2) {
            this.charBuffer[i2] = 32;
            this.perCharFonts[i2] = DEFAULT_FONT;
            this.perCharForegroundColor[i2] = this.defaultForegroundColor;
            this.perCharBackgroundColor[i2] = this.defaultBackgroundColor;
        }
    }

    public FormattedCharacterBuffer(String string, Font font, Color color, Color color2) {
        this(1, string.length());
        for (int i2 = 0; i2 < this.numberOfLinesInBuffer * this.numberOfColumnsInBuffer; ++i2) {
            this.charBuffer[i2] = string.charAt(i2) == '\n' ? 95 : (int)string.charAt(i2);
            this.perCharFonts[i2] = font;
            this.perCharForegroundColor[i2] = color;
            this.perCharBackgroundColor[i2] = color2;
        }
    }

    public int getNumberOfColumns() {
        return this.numberOfColumnsInBuffer;
    }

    public int getNumberOfLines() {
        return this.numberOfLinesInBuffer;
    }

    public FormattedCharacterBuffer setBackgroundColor(Color color) {
        for (int i2 = 0; i2 < this.numberOfLinesInBuffer * this.numberOfColumnsInBuffer; ++i2) {
            this.perCharBackgroundColor[i2] = color;
        }
        return this;
    }

    public void setAt(int n2, int n3, char c2, Font font, Color color, Color color2) {
        int n4 = n2 * this.numberOfColumnsInBuffer + n3;
        this.charBuffer[n4] = c2;
        this.perCharFonts[n4] = font;
        this.perCharForegroundColor[n4] = color;
        this.perCharBackgroundColor[n4] = color2;
    }

    public boolean copyInto(int n2, int n3, FormattedCharacterBuffer formattedCharacterBuffer) {
        if (n2 + formattedCharacterBuffer.getNumberOfLines() > this.numberOfLinesInBuffer || n3 + formattedCharacterBuffer.getNumberOfColumns() > this.numberOfColumnsInBuffer) {
            return false;
        }
        for (int i2 = 0; i2 < formattedCharacterBuffer.getNumberOfLines(); ++i2) {
            for (int i3 = 0; i3 < formattedCharacterBuffer.getNumberOfColumns(); ++i3) {
                int n4 = i2 * formattedCharacterBuffer.getNumberOfColumns() + i3;
                char c2 = formattedCharacterBuffer.charBuffer[n4];
                Font font = formattedCharacterBuffer.perCharFonts[n4];
                Color color = formattedCharacterBuffer.perCharForegroundColor[n4];
                Color color2 = formattedCharacterBuffer.perCharBackgroundColor[n4];
                this.setAt(n2 + i2, n3 + i3, c2, font, color, color2);
            }
        }
        return true;
    }

    public FormattedCharacterBuffer getLine(int n2) {
        FormattedCharacterBuffer formattedCharacterBuffer = new FormattedCharacterBuffer(1, this.numberOfColumnsInBuffer);
        for (int i2 = 0; i2 < this.getNumberOfColumns(); ++i2) {
            int n3 = n2 * this.getNumberOfColumns() + i2;
            char c2 = this.charBuffer[n3];
            Font font = this.perCharFonts[n3];
            Color color = this.perCharForegroundColor[n3];
            Color color2 = this.perCharBackgroundColor[n3];
            formattedCharacterBuffer.setAt(0, i2, c2, font, color, color2);
        }
        return formattedCharacterBuffer;
    }

    protected void paintBuffer(Graphics2D graphics2D, int n2, int n3, int n4) {
        graphics2D.setFont(this.perCharFonts[0]);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        graphics2D.fillRect(0, 0, this.numberOfColumnsInBuffer * fontMetrics.charWidth('a'), this.numberOfLinesInBuffer * fontMetrics.getHeight());
        for (int i2 = 0; i2 < this.numberOfLinesInBuffer; ++i2) {
            AttributedString attributedString = this.getAttributedStringForLine(i2, n4);
            graphics2D.drawString(attributedString.getIterator(), n2, n3 + fontMetrics.getHeight() * (i2 + 1));
        }
    }

    private AttributedString getAttributedStringForLine(int n2, int n3) {
        String string = new String(this.charBuffer, this.numberOfColumnsInBuffer * n2 + n3, this.numberOfColumnsInBuffer - n3);
        AttributedString attributedString = new AttributedString(string);
        int n4 = n2 * this.numberOfColumnsInBuffer + n3;
        for (int i2 = 0; i2 < this.numberOfColumnsInBuffer - n3; ++i2) {
            attributedString.addAttribute(TextAttribute.FONT, this.perCharFonts[n4 + i2], i2, i2 + 1);
            attributedString.addAttribute(TextAttribute.BACKGROUND, this.perCharBackgroundColor[n4 + i2], i2, i2 + 1);
            attributedString.addAttribute(TextAttribute.FOREGROUND, this.perCharForegroundColor[n4 + i2], i2, i2 + 1);
        }
        return attributedString;
    }

    public String getCharBufferAsString() {
        StringBuilder stringBuilder = new StringBuilder(this.numberOfLinesInBuffer * this.numberOfColumnsInBuffer);
        for (int i2 = 0; i2 < this.numberOfLinesInBuffer; ++i2) {
            stringBuilder.append(this.charBuffer, this.numberOfColumnsInBuffer * i2, this.numberOfColumnsInBuffer);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

