/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.CodeDisplay;

import com.google.security.zynamics.zylib.gui.CodeDisplay.CodeDisplayCoordinate;
import com.google.security.zynamics.zylib.gui.CodeDisplay.CodeDisplayEventListener;
import com.google.security.zynamics.zylib.gui.CodeDisplay.FormattedCharacterBuffer;
import com.google.security.zynamics.zylib.gui.CodeDisplay.ICodeDisplayModel;
import com.google.security.zynamics.zylib.gui.JCaret.ICaretListener;
import com.google.security.zynamics.zylib.gui.JCaret.JCaret;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;

public class CodeDisplay
extends JComponent {
    private FontMetrics fontMetrics;
    private Font textFont;
    private final JScrollBar verticalScrollbar = new JScrollBar(1, 0, 1, 0, 1);
    private final JScrollBar horizontalScrollbar = new JScrollBar(0, 0, 1, 0, 1);
    private final InternalListener listener = new InternalListener();
    private final ICodeDisplayModel codeModel;
    private BufferedImage bufferedImage;
    private Graphics2D bufferedGraphics;
    private int fontCharWidth = 0;
    private int fontLineHeight = 0;
    private final JCaret caret = new JCaret();
    private CodeDisplayCoordinate caretPosition = new CodeDisplayCoordinate(0, 0, 0, 0);
    private int caretX = 0;
    private int caretY = 0;
    private int currentlyVisibleLines = 0;
    private int currentlyVisibleColumns = 0;
    private int currentFirstRow = 0;
    private int currentFirstLine = 0;
    private int currentFirstCharColumn = 0;
    private FormattedCharacterBuffer charBuffer = new FormattedCharacterBuffer(0, 0);
    private List<CodeDisplayEventListener> eventListeners = new ArrayList<CodeDisplayEventListener>();
    private TreeMap<Integer, CodeDisplayCoordinate> yCoordinateToRowAndLine = new TreeMap();

    public static String padRight(String string, int n2) {
        if (n2 == 0) {
            return "";
        }
        return String.format("%1$-" + n2 + "s", string);
    }

    public CodeDisplay(ICodeDisplayModel iCodeDisplayModel) {
        this.codeModel = iCodeDisplayModel;
        this.textFont = new Font("Monospaced", 0, 12);
        this.setFocusable(true);
        this.setLayout(new BorderLayout());
        this.initializeListeners();
        this.initializeScrollbars();
        this.initializeFontMetrics(this.textFont);
        this.currentlyVisibleLines = this.getNumberOfVisibleLines();
        this.currentlyVisibleColumns = this.getNumberOfVisibleColumns();
        this.initializeGraphicsBuffer();
        this.setScrollBarMaximum();
        this.setEnabled(true);
        int n2 = 0;
        CodeDisplayCoordinate codeDisplayCoordinate = new CodeDisplayCoordinate(0, 0, 0, 0);
        for (int i2 = 0; i2 < this.codeModel.getNumberOfColumns(); ++i2) {
            n2 += this.codeModel.getColumnWidthInCharacters(i2);
            codeDisplayCoordinate.setColumn(i2);
            if (!this.codeModel.canHaveCaret(codeDisplayCoordinate)) continue;
            this.setCaretPosition(codeDisplayCoordinate);
            this.caretX = n2;
            this.caretY = 1;
        }
    }

    private void initializeGraphicsBuffer() {
        this.bufferedImage = new BufferedImage((this.codeModel.getTotalWidthInCharacters() + 1) * this.fontCharWidth, (this.currentlyVisibleLines + 10) * this.fontLineHeight, 1);
        this.bufferedGraphics = (Graphics2D)this.bufferedImage.getGraphics();
    }

    private void notifyCaretListeners() {
        for (CodeDisplayEventListener codeDisplayEventListener : this.eventListeners) {
            codeDisplayEventListener.caretChanged(this.caretPosition);
        }
    }

    private void initializeFontMetrics(Font font) {
        BufferedImage bufferedImage = new BufferedImage(10, 10, 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setFont(font);
        this.fontMetrics = graphics2D.getFontMetrics();
        this.fontCharWidth = this.fontMetrics.getMaxAdvance();
        this.fontLineHeight = this.fontMetrics.getHeight();
    }

    private void initializeListeners() {
        this.addMouseListener(this.listener);
        this.addMouseMotionListener(this.listener);
        this.addMouseWheelListener(this.listener);
        this.addFocusListener(this.listener);
        this.addComponentListener(this.listener);
        this.addKeyListener(this.listener);
        this.caret.addCaretListener(this.listener);
    }

    private void initializeScrollbars() {
        this.verticalScrollbar.addAdjustmentListener(this.listener);
        this.add((Component)this.verticalScrollbar, "East");
        this.horizontalScrollbar.addAdjustmentListener(this.listener);
        this.add((Component)this.horizontalScrollbar, "South");
    }

    private int getNumberOfVisibleColumns() {
        int n2 = this.getWidth() - this.verticalScrollbar.getWidth();
        return n2 / this.fontCharWidth + (n2 % this.fontCharWidth == 0 ? 0 : 1);
    }

    private int getNumberOfVisibleLines() {
        int n2 = this.getHeight() - this.horizontalScrollbar.getHeight();
        return n2 / this.fontLineHeight + (n2 % this.fontLineHeight == 0 ? 0 : 1);
    }

    private void setScrollBarMaximum() {
        int n2 = this.codeModel.getNumberOfRows();
        int n3 = n2;
        if (n3 < 0) {
            n3 = 0;
            this.verticalScrollbar.setValue(0);
            this.verticalScrollbar.setEnabled(false);
        } else {
            this.verticalScrollbar.setEnabled(true);
        }
        this.verticalScrollbar.setMaximum(n3);
        int n4 = this.codeModel.getTotalWidthInCharacters();
        int n5 = this.getWidth();
        if ((n5 -= this.verticalScrollbar.getWidth()) >= n4 * this.fontCharWidth) {
            this.horizontalScrollbar.setValue(0);
            this.horizontalScrollbar.setEnabled(false);
        } else {
            this.horizontalScrollbar.setMaximum(n4 + 1);
            this.horizontalScrollbar.setEnabled(true);
        }
    }

    private void updateCharacterBufferFromModel() {
        int n2;
        int n3;
        this.charBuffer.clear();
        this.charBuffer.setBackgroundColor(Color.LIGHT_GRAY.brighter());
        this.currentFirstRow = this.verticalScrollbar.getValue();
        this.currentFirstCharColumn = this.horizontalScrollbar.getValue();
        int n4 = 0;
        if (this.codeModel.hasHeaderRow()) {
            n4 = 1;
            n3 = 0;
            for (n2 = 0; n2 < this.codeModel.getNumberOfColumns(); ++n2) {
                this.charBuffer.copyInto(0, n3, this.codeModel.getHeader(n2));
                n3 += this.codeModel.getColumnWidthInCharacters(n2);
            }
        }
        for (n3 = this.currentFirstRow; n3 < Math.min(this.currentFirstRow + this.currentlyVisibleLines, this.codeModel.getNumberOfRows()); ++n3) {
            int n5 = n2 = n3 == this.currentFirstRow ? this.currentFirstLine : 0;
            while (n2 < this.codeModel.getMaximumLinesForRow(n3)) {
                int n6 = 0;
                for (int i2 = 0; i2 < this.codeModel.getNumberOfColumns(); ++i2) {
                    int n7;
                    FormattedCharacterBuffer formattedCharacterBuffer;
                    if (this.caretPosition.getRow() == n3 && this.caretPosition.getLine() == n2 && this.caretPosition.getColumn() == i2) {
                        this.caretX = n6 + this.caretPosition.getFieldIndex();
                        this.caretY = n4;
                    }
                    if ((formattedCharacterBuffer = this.codeModel.getLineFormatted(n3, i2, n2)) != null) {
                        this.charBuffer.copyInto(n4, n6, formattedCharacterBuffer);
                    }
                    if (!this.yCoordinateToRowAndLine.containsKey(n7 = n4 * this.fontLineHeight + this.fontLineHeight / 2)) {
                        this.yCoordinateToRowAndLine.put(n7, new CodeDisplayCoordinate(n3, n2, 0, 0));
                    } else {
                        CodeDisplayCoordinate codeDisplayCoordinate = this.yCoordinateToRowAndLine.get(n7);
                        codeDisplayCoordinate.setRow(n3);
                        codeDisplayCoordinate.setLine(n2);
                    }
                    n6 += this.codeModel.getColumnWidthInCharacters(i2);
                }
                ++n4;
                ++n2;
            }
        }
        this.setScrollBarMaximum();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.bufferedGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.updateVisibleLinesAndColumns();
        this.updateCharacterBufferFromModel();
        this.currentFirstRow = this.verticalScrollbar.getValue();
        this.currentFirstCharColumn = this.horizontalScrollbar.getValue();
        this.charBuffer.paintBuffer(this.bufferedGraphics, 0, 0, this.currentFirstCharColumn);
        graphics.drawImage(this.bufferedImage, 2, 2, this);
        this.caret.draw(graphics, 2 + this.caretX * this.fontCharWidth, 6 + this.caretY * this.fontLineHeight, this.fontLineHeight - 1);
    }

    void updateVisibleLinesAndColumns() {
        int n2 = this.getNumberOfVisibleLines();
        int n3 = this.getNumberOfVisibleColumns();
        if (this.currentlyVisibleLines != n2 || this.currentlyVisibleColumns != n3) {
            this.currentlyVisibleLines = n2;
            this.currentlyVisibleColumns = n3;
            int n4 = this.codeModel.getTotalWidthInCharacters();
            int n5 = this.currentlyVisibleLines + 1;
            this.charBuffer = new FormattedCharacterBuffer(n5, n4);
            this.bufferedImage = new BufferedImage(n4 * this.fontCharWidth, n5 * this.fontLineHeight, 1);
            this.bufferedGraphics = (Graphics2D)this.bufferedImage.getGraphics();
        }
    }

    void setSelectionStart() {
    }

    private boolean fillColumnAndFieldIndexFromX(int n2, CodeDisplayCoordinate codeDisplayCoordinate) {
        n2 += this.currentFirstCharColumn * this.fontCharWidth;
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < this.codeModel.getNumberOfColumns(); ++i2) {
            int n5 = n3 + this.codeModel.getColumnWidthInCharacters(i2) * this.fontCharWidth;
            if (n2 >= n3 && n2 < n5) {
                n4 = (n2 -= n3) / this.fontCharWidth;
                codeDisplayCoordinate.setColumn(i2);
                codeDisplayCoordinate.setFieldIndex(n4);
                return true;
            }
            n3 = n5;
        }
        return false;
    }

    private boolean fillCoordinateFromXY(int n2, int n3, CodeDisplayCoordinate codeDisplayCoordinate) {
        Map.Entry<Integer, CodeDisplayCoordinate> entry = this.yCoordinateToRowAndLine.floorEntry(n3);
        if (entry == null) {
            codeDisplayCoordinate.setRow(2);
            codeDisplayCoordinate.setColumn(1);
            return true;
        }
        codeDisplayCoordinate.setRow(entry.getValue().getRow());
        codeDisplayCoordinate.setLine(entry.getValue().getLine());
        return this.fillColumnAndFieldIndexFromX(n2, codeDisplayCoordinate);
    }

    public CodeDisplayCoordinate getCaretPosition() {
        return this.caretPosition;
    }

    public void setCaretPosition(CodeDisplayCoordinate codeDisplayCoordinate) {
        this.caretPosition = codeDisplayCoordinate;
    }

    public int rowAtPoint(Point point) {
        CodeDisplayCoordinate codeDisplayCoordinate = new CodeDisplayCoordinate(0, 0, 0, 0);
        this.fillCoordinateFromXY(point.x, point.y, codeDisplayCoordinate);
        return codeDisplayCoordinate.getRow();
    }

    public int columnAtPoint(Point point) {
        CodeDisplayCoordinate codeDisplayCoordinate = new CodeDisplayCoordinate(0, 0, 0, 0);
        this.fillCoordinateFromXY(point.x, point.y, codeDisplayCoordinate);
        return codeDisplayCoordinate.getColumn();
    }

    public int lineAtPoint(Point point) {
        CodeDisplayCoordinate codeDisplayCoordinate = new CodeDisplayCoordinate(0, 0, 0, 0);
        this.fillCoordinateFromXY(point.x, point.y, codeDisplayCoordinate);
        return codeDisplayCoordinate.getLine();
    }

    public void addCaretChangedListener(CodeDisplayEventListener codeDisplayEventListener) {
        this.eventListeners.add(codeDisplayEventListener);
    }

    public void removeCaretChangedListener(CodeDisplayEventListener codeDisplayEventListener) {
        this.eventListeners.remove(codeDisplayEventListener);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.fontCharWidth * this.codeModel.getTotalWidthInCharacters(), this.fontLineHeight * 40);
    }

    private class InternalListener
    extends MouseAdapter
    implements ICaretListener,
    AdjustmentListener,
    ComponentListener,
    FocusListener,
    KeyListener {
        private InternalListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            CodeDisplay.this.repaint();
        }

        @Override
        public void caretStatusChanged(JCaret jCaret) {
            CodeDisplay.this.repaint();
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            CodeDisplay.this.updateVisibleLinesAndColumns();
            CodeDisplay.this.updateCharacterBufferFromModel();
            CodeDisplay.this.setScrollBarMaximum();
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            CodeDisplay.this.repaint();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            CodeDisplay.this.repaint();
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (!keyEvent.isActionKey()) {
                return;
            }
            CodeDisplayCoordinate codeDisplayCoordinate = new CodeDisplayCoordinate(CodeDisplay.this.caretPosition);
            int n2 = codeDisplayCoordinate.getLine();
            int n3 = codeDisplayCoordinate.getRow();
            int n4 = codeDisplayCoordinate.getFieldIndex();
            int n5 = codeDisplayCoordinate.getColumn();
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    if (n2 == 0) {
                        int n6 = n3 - 1;
                        codeDisplayCoordinate.setRow(Math.max(n6, 0));
                        int n7 = CodeDisplay.this.codeModel.getMaximumLinesForRow(n6);
                        if (n7 <= 0) break;
                        codeDisplayCoordinate.setLine(CodeDisplay.this.codeModel.getMaximumLinesForRow(n6) - 1);
                        break;
                    }
                    codeDisplayCoordinate.setLine(n2 - 1);
                    break;
                }
                case 40: {
                    if (n2 == CodeDisplay.this.codeModel.getMaximumLinesForRow(n3) - 1) {
                        codeDisplayCoordinate.setRow(Math.min(n3 + 1, CodeDisplay.this.codeModel.getNumberOfRows()));
                        codeDisplayCoordinate.setLine(0);
                        break;
                    }
                    codeDisplayCoordinate.setLine(n2 + 1);
                    break;
                }
                case 37: {
                    if (n4 == 0) {
                        codeDisplayCoordinate.setColumn(n5 - 1);
                        codeDisplayCoordinate.setFieldIndex(CodeDisplay.this.codeModel.getColumnWidthInCharacters(n5 - 1) - 1);
                        break;
                    }
                    codeDisplayCoordinate.setFieldIndex(n4 - 1);
                    break;
                }
                case 39: {
                    n4 = codeDisplayCoordinate.getFieldIndex();
                    if (n4 == CodeDisplay.this.codeModel.getColumnWidthInCharacters(n5) - 1) {
                        codeDisplayCoordinate.setColumn(n5 + 1);
                        codeDisplayCoordinate.setFieldIndex(0);
                        break;
                    }
                    codeDisplayCoordinate.setFieldIndex(n4 + 1);
                    break;
                }
                case 34: {
                    for (int i2 = 0; i2 < CodeDisplay.this.currentlyVisibleLines - 2; ++i2) {
                        if (codeDisplayCoordinate.getLine() >= CodeDisplay.this.codeModel.getMaximumLinesForRow(n3) - 1) {
                            codeDisplayCoordinate.setRow(Math.min(codeDisplayCoordinate.getRow() + 1, CodeDisplay.this.codeModel.getNumberOfRows()));
                            codeDisplayCoordinate.setLine(0);
                            continue;
                        }
                        codeDisplayCoordinate.setLine(codeDisplayCoordinate.getLine() + 1);
                    }
                    CodeDisplay.this.verticalScrollbar.setValue(codeDisplayCoordinate.getRow());
                    break;
                }
                case 33: {
                    for (int i3 = 0; i3 < CodeDisplay.this.currentlyVisibleLines - 2; ++i3) {
                        if (codeDisplayCoordinate.getLine() == 0) {
                            int n8 = Math.max(codeDisplayCoordinate.getRow() - 1, 0);
                            codeDisplayCoordinate.setRow(Math.max(n8, 0));
                            codeDisplayCoordinate.setLine(CodeDisplay.this.codeModel.getMaximumLinesForRow(n8) - 1);
                            continue;
                        }
                        codeDisplayCoordinate.setLine(Math.max(codeDisplayCoordinate.getLine() - 1, 0));
                    }
                    CodeDisplay.this.verticalScrollbar.setValue(codeDisplayCoordinate.getRow());
                    break;
                }
                case 36: {
                    CodeDisplay.this.codeModel.keyPressedOrTyped(codeDisplayCoordinate, keyEvent);
                    break;
                }
                case 35: {
                    CodeDisplay.this.codeModel.keyPressedOrTyped(codeDisplayCoordinate, keyEvent);
                    break;
                }
                case 8: {
                    CodeDisplay.this.codeModel.keyPressedOrTyped(codeDisplayCoordinate, keyEvent);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (CodeDisplay.this.codeModel.canHaveCaret(codeDisplayCoordinate)) {
                CodeDisplay.this.setCaretPosition(codeDisplayCoordinate);
                CodeDisplay.this.updateCharacterBufferFromModel();
                CodeDisplay.this.notifyCaretListeners();
                CodeDisplay.this.repaint();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (CodeDisplay.this.codeModel.isEditable(CodeDisplay.this.caretPosition)) {
                CodeDisplayCoordinate codeDisplayCoordinate = new CodeDisplayCoordinate(CodeDisplay.this.caretPosition);
                CodeDisplay.this.codeModel.keyPressedOrTyped(CodeDisplay.this.caretPosition, keyEvent);
                if (!codeDisplayCoordinate.equals(CodeDisplay.this.caretPosition)) {
                    CodeDisplay.this.notifyCaretListeners();
                }
                CodeDisplay.this.updateCharacterBufferFromModel();
                CodeDisplay.this.repaint();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            CodeDisplay.this.requestFocusInWindow();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            CodeDisplayCoordinate codeDisplayCoordinate = new CodeDisplayCoordinate(0, 0, 0, 0);
            if (!CodeDisplay.this.fillCoordinateFromXY(mouseEvent.getX(), mouseEvent.getY(), codeDisplayCoordinate)) {
                return;
            }
            if (CodeDisplay.this.codeModel.canHaveCaret(codeDisplayCoordinate)) {
                CodeDisplay.this.setCaretPosition(codeDisplayCoordinate);
                CodeDisplay.this.updateCharacterBufferFromModel();
                CodeDisplay.this.notifyCaretListeners();
                CodeDisplay.this.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            int n2 = mouseWheelEvent.getWheelRotation();
            CodeDisplay.this.verticalScrollbar.setValue(CodeDisplay.this.verticalScrollbar.getValue() + n2);
        }
    }
}

