/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui;

import com.google.common.base.Preconditions;
import javax.swing.JFormattedTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.DocumentFilter;

public class CHexFormatter
extends JFormattedTextField.AbstractFormatter {
    private static final long serialVersionUID = 6996845563062947862L;
    private final HexFilter filter = new HexFilter();
    private int maxSize = Integer.MAX_VALUE;

    public CHexFormatter() {
    }

    public CHexFormatter(int n2) {
        Preconditions.checkArgument(n2 > 0, "Error: Maximum input size must be positive");
        this.maxSize = n2;
    }

    private boolean isValid(String string, int n2) {
        if (this.getFormattedTextField().getText().length() - n2 + string.length() > this.maxSize) {
            this.invalidEdit();
            return false;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (Character.digit(c2, 16) != -1) continue;
            this.invalidEdit();
            return false;
        }
        return true;
    }

    @Override
    protected DocumentFilter getDocumentFilter() {
        return this.filter;
    }

    @Override
    public Object stringToValue(String string) {
        return string;
    }

    @Override
    public String valueToString(Object object) {
        return (String)object;
    }

    private class HexFilter
    extends DocumentFilter {
        private HexFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n2, String string, AttributeSet attributeSet) {
            if (CHexFormatter.this.isValid(string, 0)) {
                super.insertString(filterBypass, n2, string, attributeSet);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n2, int n3, String string, AttributeSet attributeSet) {
            if (CHexFormatter.this.isValid(string, n3)) {
                super.replace(filterBypass, n2, n3, string, attributeSet);
            }
        }
    }
}

