/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import javax.swing.JFormattedTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.DocumentFilter;

public class CFilenameFormatter
extends JFormattedTextField.AbstractFormatter {
    private static final int MAX_CHAR = 255;
    private final FilenameFilter filter = new FilenameFilter();
    private final File m_directory;

    public CFilenameFormatter(File file) {
        Preconditions.checkArgument(file.exists(), "Error: Direcctory must exist.");
        this.m_directory = file;
    }

    private boolean isValid(String string, int n2) {
        if (this.getFormattedTextField().getText().length() - n2 + string.length() > 255 || string.indexOf("\\") > -1 || string.indexOf("/") > -1) {
            this.invalidEdit();
            return false;
        }
        File file = new File(this.m_directory.getPath() + File.separator + string);
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    this.invalidEdit();
                    return false;
                }
                file.delete();
            }
            catch (IOException iOException) {
                this.invalidEdit();
                return false;
            }
        }
        return true;
    }

    @Override
    protected DocumentFilter getDocumentFilter() {
        return this.filter;
    }

    @Override
    public Object stringToValue(String string) {
        return string;
    }

    @Override
    public String valueToString(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    private class FilenameFilter
    extends DocumentFilter {
        private FilenameFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n2, String string, AttributeSet attributeSet) {
            if (CFilenameFormatter.this.isValid(string, 0)) {
                super.insertString(filterBypass, n2, string, attributeSet);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n2, int n3, String string, AttributeSet attributeSet) {
            if (CFilenameFormatter.this.isValid(string, n3)) {
                super.replace(filterBypass, n2, n3, string, attributeSet);
            }
        }
    }
}

