/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.io.FileUtils;
import com.google.security.zynamics.zylib.system.SystemHelpers;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;

public class CFileChooser
extends JFileChooser {
    private final List<FileNameExtensionFilter> fileFilters = new ArrayList<FileNameExtensionFilter>();
    private final JCheckBox checkBox = new JCheckBox();
    private boolean askFileOverwrite = false;

    public CFileChooser() {
        this("");
    }

    public CFileChooser(FileExtension ... fileExtensionArray) {
        Preconditions.checkNotNull(fileExtensionArray, "File extensions can't be null.");
        for (FileExtension fileExtension : fileExtensionArray) {
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter(Arrays.asList(fileExtension.extensions), fileExtension.description);
            this.fileFilters.add(fileNameExtensionFilter);
            this.addChoosableFileFilter(fileNameExtensionFilter);
        }
        if (!this.fileFilters.isEmpty()) {
            this.setFileFilter(0);
        }
    }

    public CFileChooser(List<String> list, String string) {
        this(new FileExtension(Preconditions.checkNotNull(string), Preconditions.checkNotNull(list).toArray(new String[0])));
    }

    public CFileChooser(String string) {
        this(string, "");
    }

    public CFileChooser(String string, String string2) {
        this(Arrays.asList(string), string2);
    }

    private static int showNativeFileDialog(final JFileChooser jFileChooser) {
        FileDialog fileDialog = new FileDialog((Frame)jFileChooser.getParent());
        fileDialog.setDirectory(jFileChooser.getCurrentDirectory().getPath());
        File file = jFileChooser.getSelectedFile();
        fileDialog.setFile(file == null ? "" : file.getPath());
        fileDialog.setFilenameFilter(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return jFileChooser.getFileFilter().accept(new File(file.getPath() + File.pathSeparator + string));
            }
        });
        if (jFileChooser.getDialogType() == 1) {
            fileDialog.setMode(1);
        } else {
            fileDialog.setMode(0);
        }
        if (jFileChooser.getFileSelectionMode() == 1) {
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
        }
        fileDialog.setVisible(true);
        System.setProperty("apple.awt.fileDialogForDirectories", "false");
        if (fileDialog.getFile() == null) {
            return 1;
        }
        String string = fileDialog.getDirectory();
        jFileChooser.setSelectedFile(new File(FileUtils.ensureTrailingSlash(string) + fileDialog.getFile()));
        return 0;
    }

    @Override
    public void approveSelection() {
        if (this.askFileOverwrite && this.getSelectedFile().exists() && CMessageBox.showYesNoQuestion(this, "Overwrite existing file?") == 1) {
            return;
        }
        super.approveSelection();
    }

    public boolean getAskFileOverwrite() {
        return this.askFileOverwrite;
    }

    public boolean isSelectedCheckBox() {
        return this.checkBox.isSelected();
    }

    public void setAskFileOverwrite(boolean bl2) {
        this.askFileOverwrite = bl2;
    }

    public void setCheckBox(String string) {
        Container container;
        this.checkBox.setText(string);
        this.checkBox.setBorder(new EmptyBorder(0, 0, 0, 0));
        final String string2 = this.getApproveButtonText();
        JButton jButton = (JButton)GuiHelper.findComponentByPredicate(this, new GuiHelper.ComponentFilter(){

            @Override
            public boolean accept(JComponent jComponent) {
                if (!(jComponent instanceof JButton)) {
                    return false;
                }
                String string = ((JButton)jComponent).getText();
                if (string == null) {
                    return string2 == null;
                }
                if (string2 == null) {
                    return string == null;
                }
                return ((JButton)jComponent).getText().equals(string2);
            }
        });
        Container container2 = null;
        if (jButton != null && (container = jButton.getParent()) instanceof JComponent) {
            container2 = (JComponent)container;
        }
        if (container2 == null) {
            this.setAccessory(this.checkBox);
            return;
        }
        if (SystemHelpers.isRunningMacOSX()) {
            container2.add((Component)this.checkBox, 0);
            return;
        }
        container = new JPanel(container2.getLayout());
        for (Component component : container2.getComponents()) {
            container.add(component);
        }
        container2.setLayout(new BorderLayout(0, 0));
        container2.add((Component)this.checkBox, "Before");
        container2.add((Component)container, "Center");
    }

    public void setFileFilter(int n2) {
        this.setFileFilter(this.fileFilters.get(n2));
    }

    @Override
    public int showOpenDialog(Component component) {
        if (!SystemHelpers.isRunningMacOSX()) {
            return super.showOpenDialog(component);
        }
        this.setDialogType(0);
        return CFileChooser.showNativeFileDialog(this);
    }

    public static class FileExtension {
        private final String description;
        private final String[] extensions;

        public FileExtension(String string, String ... stringArray) {
            this.description = string;
            this.extensions = stringArray;
        }
    }

    private static class FileNameExtensionFilter
    extends FileFilter {
        private final List<String> fileExtensions;
        private final String fileDescription;

        public FileNameExtensionFilter(List<String> list, String string) {
            this.fileExtensions = list;
            this.fileDescription = string;
        }

        @Override
        public boolean accept(File file) {
            String string;
            boolean bl2 = false;
            String string2 = file.getName().toLowerCase();
            Iterator<String> iterator = this.fileExtensions.iterator();
            while (iterator.hasNext() && !(bl2 = string2.endsWith((string = iterator.next()).toLowerCase()))) {
            }
            return bl2 || file.isDirectory();
        }

        @Override
        public String getDescription() {
            return this.fileDescription;
        }
    }
}

