/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui;

import com.google.security.zynamics.zylib.gui.ColorPanel.ColorPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.colorchooser.DefaultColorSelectionModel;

public class CColorChooser
extends JColorChooser {
    final Color[] m_recentColors;

    public CColorChooser() {
        this(new DefaultColorSelectionModel(Color.WHITE), null);
    }

    public CColorChooser(Color color) {
        this(new DefaultColorSelectionModel(color), null);
    }

    public CColorChooser(Color color, Color[] colorArray) {
        this(new DefaultColorSelectionModel(color), colorArray);
    }

    public CColorChooser(ColorSelectionModel colorSelectionModel) {
        this(colorSelectionModel, null);
    }

    public CColorChooser(ColorSelectionModel colorSelectionModel, Color[] colorArray) {
        super(colorSelectionModel);
        AbstractColorChooserPanel[] abstractColorChooserPanelArray = this.getChooserPanels();
        if (abstractColorChooserPanelArray.length > 0) {
            this.removeChooserPanel(abstractColorChooserPanelArray[0]);
        }
        this.m_recentColors = colorArray;
        if (this.m_recentColors != null) {
            this.addChooserPanel(new RecentColorsColorChooserPanel());
        }
    }

    public static JDialog createDialog(Component component, String string, boolean bl2, CColorChooser cColorChooser, ActionListener actionListener, ActionListener actionListener2) {
        return JColorChooser.createDialog(component, string, bl2, cColorChooser, actionListener, actionListener2);
    }

    public static Color showDialog(Component component, String string, Color color) {
        return CColorChooser.showDialog(component, string, color, null);
    }

    public static Color showDialog(Component component, String string, Color color, Color[] colorArray) {
        CColorChooser cColorChooser = new CColorChooser(color, colorArray);
        SelectedColorActionListener selectedColorActionListener = cColorChooser.new SelectedColorActionListener();
        JDialog jDialog = CColorChooser.createDialog(component, string, true, cColorChooser, (ActionListener)selectedColorActionListener, null);
        jDialog.setVisible(true);
        jDialog.dispose();
        return selectedColorActionListener.getColor();
    }

    class SelectedColorActionListener
    implements ActionListener {
        Color m_color;

        SelectedColorActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.m_color = CColorChooser.this.getColor();
        }

        public Color getColor() {
            return this.m_color;
        }
    }

    class RecentColorsColorChooserPanel
    extends AbstractColorChooserPanel {
        RecentColorsColorChooserPanel() {
        }

        @Override
        protected void buildChooser() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(CColorChooser.this.m_recentColors.length, 1, 1, 1));
            for (final Color color : CColorChooser.this.m_recentColors) {
                ColorPanel colorPanel = new ColorPanel(color, false, true);
                colorPanel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (mouseEvent.getButton() != 1) {
                            return;
                        }
                        RecentColorsColorChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
                    }
                });
                colorPanel.setPreferredSize(new Dimension(200, 25));
                JPanel jPanel2 = new JPanel();
                jPanel2.setBorder(new EmptyBorder(1, 1, 1, 1));
                jPanel2.add((Component)colorPanel, "First");
                jPanel.add(colorPanel);
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 23;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            JPanel jPanel3 = new JPanel(new GridBagLayout());
            jPanel3.add((Component)jPanel, gridBagConstraints);
            JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.add((Component)jPanel3, "North");
            JScrollPane jScrollPane = new JScrollPane(jPanel4);
            jScrollPane.setBorder(null);
            jScrollPane.setHorizontalScrollBarPolicy(30);
            jScrollPane.setVerticalScrollBarPolicy(20);
            this.add((Component)jScrollPane, "Center");
        }

        @Override
        public String getDisplayName() {
            return "Recent Colors";
        }

        @Override
        public Icon getLargeDisplayIcon() {
            return null;
        }

        @Override
        public Icon getSmallDisplayIcon() {
            return null;
        }

        @Override
        public void updateChooser() {
        }
    }
}

