/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gml;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.types.graphs.IDirectedGraph;
import com.google.security.zynamics.zylib.types.graphs.IGraphEdge;
import com.google.security.zynamics.zylib.types.trees.ITree;
import com.google.security.zynamics.zylib.types.trees.ITreeNode;
import java.util.HashMap;
import java.util.Stack;

public final class GmlConverter {
    public static String toGml(IDirectedGraph<?, ? extends IGraphEdge<?>> iDirectedGraph) {
        Preconditions.checkNotNull(iDirectedGraph, "Error: Graph argument can not be null");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("graph\n");
        stringBuilder.append("[\n");
        int n2 = 0;
        HashMap hashMap = new HashMap();
        for (Object object : iDirectedGraph.getNodes()) {
            stringBuilder.append("\tnode\n");
            stringBuilder.append("\t[\n");
            stringBuilder.append("\tid " + n2 + "\n");
            stringBuilder.append("\tlabel \"" + object + "\"\n");
            stringBuilder.append("\t]\n");
            hashMap.put(object, n2);
            ++n2;
        }
        for (IGraphEdge iGraphEdge : iDirectedGraph.getEdges()) {
            stringBuilder.append("\tedge\n");
            stringBuilder.append("\t[\n");
            stringBuilder.append("\tsource " + hashMap.get(iGraphEdge.getSource()) + "\n");
            stringBuilder.append("\ttarget " + hashMap.get(iGraphEdge.getTarget()) + "\n");
            stringBuilder.append("\tgraphics\n");
            stringBuilder.append("\t[\n");
            stringBuilder.append("\t\tfill \"#000000\"\n");
            stringBuilder.append("\t\ttargetArrow \"standard\"\n");
            stringBuilder.append("\t]\n");
            stringBuilder.append("\t]\n");
        }
        stringBuilder.append("]\n");
        return stringBuilder.toString();
    }

    public static String toGml(ITree<?> iTree) {
        Preconditions.checkNotNull(iTree, "Error: Graph argument can not be null");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("graph\n");
        stringBuilder.append("[\n");
        int n2 = 0;
        HashMap<ITreeNode, Integer> hashMap = new HashMap<ITreeNode, Integer>();
        Stack stack = new Stack();
        stack.push(iTree.getRootNode());
        while (!stack.isEmpty()) {
            ITreeNode iTreeNode = (ITreeNode)stack.pop();
            stringBuilder.append("\tnode\n");
            stringBuilder.append("\t[\n");
            stringBuilder.append("\tid " + n2 + "\n");
            stringBuilder.append("\tlabel \"" + iTreeNode + "\"\n");
            stringBuilder.append("\t]\n");
            hashMap.put(iTreeNode, n2);
            ++n2;
            ITreeNode iTreeNode2 = iTreeNode.getParent();
            if (iTreeNode2 != null) {
                stringBuilder.append("\tedge\n");
                stringBuilder.append("\t[\n");
                stringBuilder.append("\tsource " + hashMap.get(iTreeNode2) + "\n");
                stringBuilder.append("\ttarget " + hashMap.get(iTreeNode) + "\n");
                stringBuilder.append("\tgraphics\n");
                stringBuilder.append("\t[\n");
                stringBuilder.append("\t\tfill \"#000000\"\n");
                stringBuilder.append("\t\ttargetArrow \"standard\"\n");
                stringBuilder.append("\t]\n");
                stringBuilder.append("\t]\n");
            }
            for (ITreeNode iTreeNode3 : iTreeNode.getChildren()) {
                stack.push(iTreeNode3);
            }
        }
        stringBuilder.append("]\n");
        return stringBuilder.toString();
    }
}

