/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.general.undo;

import com.google.security.zynamics.zylib.general.undo.IUndoable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UndoStack
implements Iterable<IUndoable> {
    private final List<IUndoable> undoStack = new ArrayList<IUndoable>();
    private int undoPosition = 0;

    public void add(IUndoable iUndoable) {
        int n2 = this.undoStack.size() - this.undoPosition;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.undoStack.remove(this.undoPosition);
        }
        this.undoStack.add(iUndoable);
        ++this.undoPosition;
    }

    public boolean canRedo() {
        return this.undoPosition < this.undoStack.size();
    }

    public boolean canUndo() {
        return this.undoPosition > 0;
    }

    @Override
    public Iterator<IUndoable> iterator() {
        return this.undoStack.iterator();
    }

    public void redo() {
        IUndoable iUndoable = this.undoStack.get(this.undoPosition);
        iUndoable.revertToSnapshot();
        ++this.undoPosition;
    }

    public void undo() {
        IUndoable iUndoable = this.undoStack.get(this.undoPosition - 1);
        iUndoable.undo();
        --this.undoPosition;
    }
}

