/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.general.memmanager;

import com.google.common.base.Preconditions;

public class MemoryChunk
implements Comparable<MemoryChunk> {
    private final long m_address;
    private byte[] m_data;

    public MemoryChunk(long l2, byte[] byArray) {
        Preconditions.checkArgument(l2 >= 0L, "Error: Chunk addresses can't be less than 0");
        Preconditions.checkNotNull(byArray, "Error: Initial data can't be null");
        Preconditions.checkArgument(byArray.length != 0, "Error: Initial data can't be empty");
        this.m_address = l2;
        this.m_data = byArray;
    }

    public MemoryChunk(long l2, int n2) {
        this(l2, new byte[n2]);
    }

    @Override
    public int compareTo(MemoryChunk memoryChunk) {
        return Long.compare(this.m_address, memoryChunk.m_address);
    }

    public void extend(int n2) {
        Preconditions.checkArgument(n2 > 0, "Error: The number of bytes to add must be positive");
        byte[] byArray = new byte[this.m_data.length + n2];
        System.arraycopy(this.m_data, 0, byArray, 0, this.m_data.length);
        this.m_data = byArray;
    }

    public long getAddress() {
        return this.m_address;
    }

    public byte[] getBytes() {
        return this.m_data;
    }

    public int getLength() {
        return this.m_data.length;
    }

    public byte loadByte(long l2) {
        return this.m_data[(int)(l2 - this.m_address)];
    }

    public void print() {
        System.out.printf("%08X: ", this.m_address);
        for (byte by2 : this.m_data) {
            System.out.printf("%02X ", by2);
        }
        System.out.println();
    }

    public void store(long l2, byte[] byArray) {
        System.arraycopy(byArray, 0, this.m_data, (int)(l2 - this.m_address), byArray.length);
    }

    public void storeByte(long l2, byte by2) {
        this.m_data[(int)(l2 - this.m_address)] = by2;
    }
}

