/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.general.memmanager;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.general.memmanager.IMemoryListener;
import com.google.security.zynamics.zylib.general.memmanager.MemoryChunk;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Memory {
    private final LinkedList<MemoryChunk> m_chunks = new LinkedList();
    private final ArrayList<IMemoryListener> m_listeners = new ArrayList();
    private final ReadWriteLock m_readWriteLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_readWriteLock.readLock();
    private final Lock m_writeLock = this.m_readWriteLock.writeLock();

    private byte[] concat(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    private MemoryChunk connectChunks(MemoryChunk memoryChunk, MemoryChunk memoryChunk2) {
        MemoryChunk memoryChunk3;
        Preconditions.checkNotNull(memoryChunk, "Error: First memory chunk can't be null");
        Preconditions.checkNotNull(memoryChunk2, "Error: Second memory chunk can't be null");
        Preconditions.checkArgument(memoryChunk2.getAddress() > memoryChunk.getAddress(), "Error: Second memory chunk must start after the first memory chunk");
        long l2 = memoryChunk.getAddress();
        if (memoryChunk.getAddress() + (long)memoryChunk.getLength() == memoryChunk2.getAddress()) {
            byte[] byArray = this.concat(memoryChunk.getBytes(), memoryChunk2.getBytes());
            memoryChunk3 = new MemoryChunk(l2, byArray);
        } else {
            int n2 = (int)(memoryChunk2.getAddress() - memoryChunk.getAddress()) - memoryChunk.getLength();
            byte[] byArray = new byte[memoryChunk.getLength() + n2 + memoryChunk2.getLength()];
            if (n2 > 0) {
                return null;
            }
            if (n2 < 0) {
                System.arraycopy(memoryChunk.getBytes(), 0, byArray, 0, memoryChunk.getLength());
                System.arraycopy(memoryChunk2.getBytes(), -n2, byArray, memoryChunk.getLength(), memoryChunk2.getLength() + n2);
            }
            memoryChunk3 = new MemoryChunk(l2, byArray);
        }
        this.removeChunk(memoryChunk);
        this.removeChunk(memoryChunk2);
        this.insertChunk(memoryChunk3);
        return memoryChunk3;
    }

    private MemoryChunk findChunk(long l2) {
        Preconditions.checkArgument(l2 >= 0L, "Error: Address can't be less than 0");
        for (MemoryChunk memoryChunk : this.m_chunks) {
            if (l2 < memoryChunk.getAddress() || l2 >= memoryChunk.getAddress() + (long)memoryChunk.getLength()) continue;
            return memoryChunk;
        }
        return null;
    }

    private int findChunkPosition(MemoryChunk memoryChunk) {
        Preconditions.checkNotNull(memoryChunk, "Error: Memory chunk can't be null");
        long l2 = memoryChunk.getAddress();
        for (int i2 = 0; i2 < this.getNumberOfChunks(); ++i2) {
            if (l2 >= this.m_chunks.get(i2).getAddress()) continue;
            return i2;
        }
        return this.m_chunks.size();
    }

    private MemoryChunk findNextChunk(long l2) {
        Preconditions.checkArgument(l2 >= 0L, "Error: Address can't be less than 0");
        for (MemoryChunk memoryChunk : this.m_chunks) {
            if (memoryChunk.getAddress() < l2) continue;
            return memoryChunk;
        }
        return null;
    }

    private void insertChunk(MemoryChunk memoryChunk) {
        Preconditions.checkNotNull(memoryChunk, "Error: Memory chunk can't be null");
        int n2 = this.findChunkPosition(memoryChunk);
        this.m_chunks.add(n2, memoryChunk);
    }

    private void notifyListeners(long l2, int n2) {
        for (IMemoryListener iMemoryListener : this.m_listeners) {
            iMemoryListener.memoryChanged(l2, n2);
        }
    }

    private void removeChunk(MemoryChunk memoryChunk) {
        Preconditions.checkNotNull(memoryChunk, "Error: Memory chunk can't be null");
        this.m_chunks.remove(memoryChunk);
    }

    private void splitChunk(MemoryChunk memoryChunk, long l2) {
        byte[] byArray = memoryChunk.getBytes();
        byte[] byArray2 = new byte[(int)(l2 - memoryChunk.getAddress())];
        byte[] byArray3 = new byte[memoryChunk.getLength() - byArray2.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        System.arraycopy(byArray, byArray.length - byArray3.length, byArray3, 0, byArray3.length);
        MemoryChunk memoryChunk2 = new MemoryChunk(memoryChunk.getAddress(), byArray2);
        MemoryChunk memoryChunk3 = new MemoryChunk(memoryChunk.getAddress() + (long)memoryChunk.getLength() - (long)byArray3.length, byArray3);
        this.removeChunk(memoryChunk);
        this.insertChunk(memoryChunk2);
        this.insertChunk(memoryChunk3);
    }

    public void addMemoryListener(IMemoryListener iMemoryListener) {
        Preconditions.checkNotNull(iMemoryListener, "Error: Listener can't be null");
        this.m_listeners.add(iMemoryListener);
    }

    public void clear() {
        this.m_writeLock.lock();
        this.m_chunks.clear();
        this.m_writeLock.unlock();
        for (IMemoryListener iMemoryListener : this.m_listeners) {
            iMemoryListener.memoryCleared();
        }
    }

    public byte[] getData(long l2, int n2) {
        Preconditions.checkArgument(l2 >= 0L, "Error: Address can't be less than 0");
        Preconditions.checkArgument(n2 > 0, "Error: Length must be positive");
        this.m_readLock.lock();
        MemoryChunk memoryChunk = this.findChunk(l2);
        int n3 = n2;
        long l3 = l2;
        byte[] byArray = new byte[n2];
        int n4 = 0;
        try {
            while (true) {
                int n5;
                if (memoryChunk == null) {
                    throw new IllegalArgumentException("Error: Data is not available");
                }
                if (memoryChunk.getAddress() + (long)memoryChunk.getLength() - l3 >= (long)n3) {
                    n5 = (int)(l3 - memoryChunk.getAddress());
                    System.arraycopy(memoryChunk.getBytes(), n5, byArray, n4, n3);
                    byte[] byArray2 = byArray;
                    return byArray2;
                }
                n5 = (int)(l3 - memoryChunk.getAddress());
                int n6 = memoryChunk.getLength() - n5;
                System.arraycopy(memoryChunk.getBytes(), n5, byArray, n4, n6);
                n4 += n6;
                n3 = (int)((long)n3 - (memoryChunk.getAddress() + (long)memoryChunk.getLength() - l3));
                l3 = memoryChunk.getAddress() + (long)memoryChunk.getLength();
                memoryChunk = this.findChunk(l3);
            }
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    public int getMemorySize() {
        this.m_readLock.lock();
        int n2 = 0;
        for (MemoryChunk memoryChunk : this.m_chunks) {
            n2 += memoryChunk.getLength();
        }
        this.m_readLock.unlock();
        return n2;
    }

    public int getNumberOfChunks() {
        this.m_readLock.lock();
        int n2 = this.m_chunks.size();
        this.m_readLock.unlock();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSectionSize(long l2) {
        this.m_readLock.lock();
        long l3 = this.getSectionStart(l2);
        try {
            if (this.hasData(l3, 1)) {
                MemoryChunk memoryChunk = this.findChunk(l3);
                long l4 = 0L;
                while (true) {
                    if (!this.hasData(memoryChunk.getAddress() + (long)memoryChunk.getLength(), 1)) {
                        long l5 = (int)(l4 + (long)memoryChunk.getLength());
                        return l5;
                    }
                    l4 += (long)memoryChunk.getLength();
                    memoryChunk = this.findChunk(memoryChunk.getAddress() + (long)memoryChunk.getLength());
                }
            }
            if (this.m_chunks.size() == 0) {
                long l6 = 0x100000000L;
                return l6;
            }
            MemoryChunk memoryChunk = new MemoryChunk(l3, 1);
            int n2 = this.findChunkPosition(memoryChunk);
            if (n2 == this.m_chunks.size()) {
                MemoryChunk memoryChunk2 = this.m_chunks.get(n2 - 1);
                long l7 = 0x100000000L - memoryChunk2.getAddress() - (long)memoryChunk2.getLength();
                return l7;
            }
            long l8 = this.m_chunks.get(n2).getAddress() - l3;
            return l8;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSectionStart(long l2) {
        try {
            this.m_readLock.lock();
            MemoryChunk memoryChunk = this.findChunk(l2);
            if (memoryChunk != null) {
                long l3 = memoryChunk.getAddress();
                if (l3 == 0L) {
                    long l4 = 0L;
                    return l4;
                }
                MemoryChunk memoryChunk2 = this.findChunk(l3 - 1L);
                if (memoryChunk2 != null) {
                    long l5 = this.getSectionStart(l3 - 1L);
                    return l5;
                }
                long l6 = l3;
                return l6;
            }
            MemoryChunk memoryChunk3 = new MemoryChunk(l2, 1);
            int n2 = this.findChunkPosition(memoryChunk3);
            if (n2 == 0) {
                long l7 = 0L;
                return l7;
            }
            MemoryChunk memoryChunk4 = this.m_chunks.get(n2 - 1);
            long l8 = memoryChunk4.getAddress() + (long)memoryChunk4.getLength();
            return l8;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    public boolean hasData(long l2, int n2) {
        Preconditions.checkArgument(l2 >= 0L, "Error: Address can't be less than 0");
        Preconditions.checkArgument(n2 > 0, "Error: Length must be positive");
        try {
            this.m_readLock.lock();
            MemoryChunk memoryChunk = this.findChunk(l2);
            int n3 = n2;
            long l3 = l2;
            while (true) {
                if (memoryChunk == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                if (memoryChunk.getAddress() + (long)memoryChunk.getLength() - l3 >= (long)n3) {
                    boolean bl3 = true;
                    return bl3;
                }
                n3 = (int)((long)n3 - (memoryChunk.getAddress() + (long)memoryChunk.getLength() - l3));
                l3 = memoryChunk.getAddress() + (long)memoryChunk.getLength();
                memoryChunk = this.findChunk(l3);
            }
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    public void printMemory() {
        this.m_readLock.lock();
        for (MemoryChunk memoryChunk : this.m_chunks) {
            memoryChunk.print();
        }
        this.m_readLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(long l2, int n2) {
        Preconditions.checkArgument(l2 >= 0L, "Error: Address can't be less than 0");
        Preconditions.checkArgument(n2 > 0, "Error: Length must be positive");
        try {
            this.m_writeLock.lock();
            MemoryChunk memoryChunk = this.findChunk(l2);
            if (memoryChunk == null) {
                MemoryChunk memoryChunk2 = this.findNextChunk(l2);
                if (memoryChunk2 == null) {
                    return;
                }
                if (memoryChunk2.getAddress() >= l2 + (long)n2) {
                    return;
                }
                int n3 = (int)(l2 + (long)n2 - memoryChunk2.getAddress());
                this.remove(memoryChunk2.getAddress(), n3);
            } else if (memoryChunk.getAddress() == l2) {
                if (memoryChunk.getLength() <= n2) {
                    this.removeChunk(memoryChunk);
                    int n4 = n2 - memoryChunk.getLength();
                    if (n4 > 0) {
                        this.remove(l2 + (long)memoryChunk.getLength(), n4);
                    }
                } else {
                    this.splitChunk(memoryChunk, l2 + (long)n2);
                    this.removeChunk(this.findChunk(l2));
                }
            } else if (memoryChunk.getAddress() + (long)memoryChunk.getLength() <= l2 + (long)n2) {
                this.splitChunk(memoryChunk, l2);
                MemoryChunk memoryChunk3 = this.findChunk(l2);
                this.removeChunk(memoryChunk3);
                int n5 = n2 - memoryChunk3.getLength();
                if (n5 > 0) {
                    this.remove(l2 + (long)memoryChunk3.getLength(), n5);
                }
            } else {
                this.splitChunk(memoryChunk, l2);
                MemoryChunk memoryChunk4 = this.findChunk(l2);
                this.splitChunk(memoryChunk4, l2 + (long)n2);
                this.removeChunk(this.findChunk(l2));
            }
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    public void removeMemoryListener(IMemoryListener iMemoryListener) {
        this.m_listeners.remove(iMemoryListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(long l2, byte[] byArray) {
        Preconditions.checkArgument(l2 >= 0L, "Error: Address can't be less than 0");
        Preconditions.checkNotNull(byArray, "Error: Data can't be null");
        try {
            this.m_writeLock.lock();
            this.remove(l2, byArray.length);
            MemoryChunk memoryChunk = new MemoryChunk(l2, byArray);
            this.insertChunk(memoryChunk);
            MemoryChunk memoryChunk2 = this.findChunk(l2 + (long)memoryChunk.getLength());
            if (memoryChunk2 != null) {
                this.connectChunks(memoryChunk, memoryChunk2);
            }
        }
        finally {
            this.m_writeLock.unlock();
        }
        this.notifyListeners(l2, byArray.length);
    }
}

