/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.general;

import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class ListenerProvider<T>
implements Iterable<T> {
    private volatile Collection<WeakReference<T>> m_listeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(T t2) {
        Iterable<Object> iterable;
        Preconditions.checkNotNull(t2, "Internal Error: Listener cannot be null");
        if (this.m_listeners == null) {
            iterable = this;
            synchronized (iterable) {
                if (this.m_listeners == null) {
                    this.m_listeners = new LinkedHashSet<WeakReference<T>>();
                }
            }
        }
        iterable = this.m_listeners;
        synchronized (iterable) {
            if (!this.m_listeners.add(new ComparableReference(t2))) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<T> iterator() {
        ArrayList<WeakReference<T>> arrayList;
        if (this.m_listeners == null) {
            return Collections.emptyIterator();
        }
        Collection<WeakReference<T>> collection = this.m_listeners;
        synchronized (collection) {
            arrayList = new ArrayList<WeakReference<T>>(this.m_listeners);
        }
        collection = new ArrayList<WeakReference<T>>();
        for (WeakReference<T> weakReference : arrayList) {
            Object t2 = weakReference.get();
            if (t2 == null) continue;
            ((ArrayList)collection).add((WeakReference<T>)t2);
        }
        return ((ArrayList)collection).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(T t2) {
        Preconditions.checkNotNull(t2, "Internal Error: Listener cannot be null");
        if (this.m_listeners != null) {
            Collection<WeakReference<T>> collection = this.m_listeners;
            synchronized (collection) {
                if (!this.m_listeners.remove(new ComparableReference(t2))) {
                    // empty if block
                }
            }
        }
    }

    public class ComparableReference
    extends WeakReference<T> {
        public ComparableReference(T t2) {
            super(t2);
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            ComparableReference comparableReference = (ComparableReference)object;
            Object t2 = this.get();
            Object t3 = comparableReference.get();
            if (t2 == null && t3 == null) {
                return true;
            }
            if (t2 == null || t3 == null) {
                return false;
            }
            return t2.equals(t3);
        }

        public int hashCode() {
            Object t2 = this.get();
            return t2 == null ? 0 : t2.hashCode();
        }
    }
}

