/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.general;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import java.awt.Color;
import javax.xml.bind.DatatypeConverter;

public final class Convert {
    private static String[] HEX_ARRAY = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1A", "1B", "1C", "1D", "1E", "1F", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2A", "2B", "2C", "2D", "2E", "2F", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3A", "3B", "3C", "3D", "3E", "3F", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4A", "4B", "4C", "4D", "4E", "4F", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5A", "5B", "5C", "5D", "5E", "5F", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6A", "6B", "6C", "6D", "6E", "6F", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7A", "7B", "7C", "7D", "7E", "7F", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "8A", "8B", "8C", "8D", "8E", "8F", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "9A", "9B", "9C", "9D", "9E", "9F", "A0", "A1", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "A9", "AA", "AB", "AC", "AD", "AE", "AF", "B0", "B1", "B2", "B3", "B4", "B5", "B6", "B7", "B8", "B9", "BA", "BB", "BC", "BD", "BE", "BF", "C0", "C1", "C2", "C3", "C4", "C5", "C6", "C7", "C8", "C9", "CA", "CB", "CC", "CD", "CE", "CF", "D0", "D1", "D2", "D3", "D4", "D5", "D6", "D7", "D8", "D9", "DA", "DB", "DC", "DD", "DE", "DF", "E0", "E1", "E2", "E3", "E4", "E5", "E6", "E7", "E8", "E9", "EA", "EB", "EC", "ED", "EE", "EF", "F0", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "FA", "FB", "FC", "FD", "FE", "FF"};

    public static String asciiToHexString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (byte by2 : string.getBytes()) {
            stringBuffer.append(Convert.byteToHexString(by2));
        }
        return stringBuffer.toString();
    }

    public static String byteToHexString(byte by2) {
        return HEX_ARRAY[by2 & 0xFF];
    }

    public static String colorToHexString(Color color) {
        String string = Integer.toHexString(color.getRGB());
        return string.substring(2);
    }

    public static String decStringToHexString(String string) {
        Preconditions.checkNotNull(string, "Error: Decimal string can't be null");
        return Long.toHexString(Long.valueOf(string, 16));
    }

    public static String hexStringToAsciiString(String string) {
        String string2 = string.length() % 2 == 0 ? string : "0" + string;
        String string3 = "";
        for (int i2 = 0; i2 < string2.length(); i2 += 2) {
            char c2 = string2.charAt(i2);
            char c3 = string2.charAt(i2 + 1);
            if (!Convert.isHexCharacter(c2) || !Convert.isHexCharacter(c3)) {
                throw new IllegalArgumentException("Error: Invalid hex string");
            }
            char c4 = (char)((Character.digit(c2, 16) << 4) + Character.digit(c3, 16));
            string3 = string3 + (Convert.isPrintableCharacter(c4) ? Character.valueOf(c4) : ".");
        }
        return string3;
    }

    public static byte[] hexStringToBytes(String string) {
        return DatatypeConverter.parseHexBinary(string);
    }

    public static long hexStringToLong(String string) {
        Preconditions.checkNotNull(string, "Error: Unicode string can't be null");
        Preconditions.checkArgument(Convert.isHexString(string), String.format("Error: Hex string '%s' is not a vaild hex string", string));
        if (string.length() == 16 && string.charAt(0) >= '\b') {
            String string2 = string.substring(0, string.length() - 8);
            String string3 = string.substring(string.length() - 8);
            return (Long.parseLong(string2, 16) << 32) + Long.parseLong(string3, 16);
        }
        return Long.parseLong(string, 16);
    }

    public static boolean isDecCharacter(char c2) {
        return CharMatcher.inRange('0', '9').apply(Character.valueOf(c2));
    }

    public static boolean isDecString(String string) {
        Preconditions.checkNotNull(string);
        CharMatcher charMatcher = CharMatcher.inRange('0', '9');
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (charMatcher.apply(Character.valueOf(string.charAt(i2)))) continue;
            return false;
        }
        return string.length() != 0;
    }

    public static boolean isHexCharacter(char c2) {
        return Convert.isDecCharacter(c2) || c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F';
    }

    public static boolean isHexString(String string) {
        Preconditions.checkNotNull(string, "Error: String argument can't be null");
        CharMatcher charMatcher = CharMatcher.inRange('0', '9').or(CharMatcher.inRange('a', 'z')).or(CharMatcher.inRange('A', 'F'));
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (charMatcher.apply(Character.valueOf(string.charAt(i2)))) continue;
            return false;
        }
        return string.length() != 0;
    }

    public static boolean isMD5String(String string) {
        Preconditions.checkNotNull(string, "Error: String argument can't be null");
        return string.length() == 32 && Convert.isHexString(string);
    }

    public static boolean isPrintableCharacter(char c2) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c2);
        return !Character.isISOControl(c2) && c2 != '\uffff' && unicodeBlock != null && unicodeBlock != Character.UnicodeBlock.SPECIALS;
    }

    public static boolean isSha1String(String string) {
        Preconditions.checkNotNull(string, "Error: String argument can't be null");
        return string.length() == 40 && Convert.isHexString(string);
    }

    public static String unicodeToHexString(String string) {
        Preconditions.checkNotNull(string, "Error: Unicode string can't be null");
        StringBuffer stringBuffer = new StringBuffer();
        for (byte by2 : string.getBytes()) {
            stringBuffer.append(String.format("%X00", by2));
        }
        return stringBuffer.toString();
    }
}

