/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.general;

import java.util.List;

public final class ByteHelpers {
    public static byte[] combine(List<byte[]> list) {
        int n2 = 0;
        for (byte[] byArray : list) {
            n2 += byArray.length;
        }
        Object object = new byte[n2];
        int n3 = 0;
        for (byte[] byArray : list) {
            System.arraycopy(byArray, 0, object, n3, byArray.length);
            n3 += byArray.length;
        }
        return object;
    }

    public static long readDwordBigEndian(byte[] byArray, int n2) {
        return ((long)byArray[n2 + 0] & 0xFFL) * 256L * 256L * 256L + ((long)byArray[n2 + 1] & 0xFFL) * 256L * 256L + ((long)byArray[n2 + 2] & 0xFFL) * 256L + ((long)byArray[n2 + 3] & 0xFFL);
    }

    public static long readDwordLittleEndian(byte[] byArray, int n2) {
        return ((long)byArray[n2 + 3] & 0xFFL) * 256L * 256L * 256L + ((long)byArray[n2 + 2] & 0xFFL) * 256L * 256L + ((long)byArray[n2 + 1] & 0xFFL) * 256L + ((long)byArray[n2 + 0] & 0xFFL);
    }

    public static long readQwordBigEndian(byte[] byArray, int n2) {
        return ((long)byArray[n2 + 0] & 0xFFL) * 256L * 256L * 256L * 256L * 256L * 256L * 256L + ((long)byArray[n2 + 1] & 0xFFL) * 256L * 256L * 256L * 256L * 256L * 256L + ((long)byArray[n2 + 2] & 0xFFL) * 256L * 256L * 256L * 256L * 256L + ((long)byArray[n2 + 3] & 0xFFL) * 256L * 256L * 256L * 256L + ((long)byArray[n2 + 4] & 0xFFL) * 256L * 256L * 256L + ((long)byArray[n2 + 5] & 0xFFL) * 256L * 256L + ((long)byArray[n2 + 6] & 0xFFL) * 256L + ((long)byArray[n2 + 7] & 0xFFL);
    }

    public static long readQwordLittleEndian(byte[] byArray, int n2) {
        return ((long)byArray[n2 + 7] & 0xFFL) * 256L * 256L * 256L * 256L * 256L * 256L * 256L + ((long)byArray[n2 + 6] & 0xFFL) * 256L * 256L * 256L * 256L * 256L * 256L + ((long)byArray[n2 + 5] & 0xFFL) * 256L * 256L * 256L * 256L * 256L + ((long)byArray[n2 + 4] & 0xFFL) * 256L * 256L * 256L * 256L + ((long)byArray[n2 + 3] & 0xFFL) * 256L * 256L * 256L + ((long)byArray[n2 + 2] & 0xFFL) * 256L * 256L + ((long)byArray[n2 + 1] & 0xFFL) * 256L + ((long)byArray[n2 + 0] & 0xFFL);
    }

    public static long readWordBigEndian(byte[] byArray, int n2) {
        return ((long)byArray[n2 + 0] & 0xFFL) * 256L + ((long)byArray[n2 + 1] & 0xFFL);
    }

    public static long readWordLittleEndian(byte[] byArray, int n2) {
        return ((long)byArray[n2 + 1] & 0xFFL) * 256L + ((long)byArray[n2 + 0] & 0xFFL);
    }

    public static byte[] toArray(List<Byte> list) {
        byte[] byArray = new byte[list.size()];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = list.get(i2);
        }
        return byArray;
    }

    public static byte[] toBigEndianDword(long l2) {
        return new byte[]{(byte)((l2 & 0xFF000000L) >>> 24), (byte)((l2 & 0xFF0000L) >>> 16), (byte)((l2 & 0xFF00L) >>> 8), (byte)(l2 & 0xFFL)};
    }

    public static byte[] toBigEndianWord(long l2) {
        return new byte[]{(byte)((l2 & 0xFF00L) >>> 8), (byte)(l2 & 0xFFL)};
    }

    public static byte[] toLittleEndianDword(long l2) {
        return new byte[]{(byte)(l2 & 0xFFL), (byte)((l2 & 0xFF00L) >>> 8), (byte)((l2 & 0xFF0000L) >>> 16), (byte)((l2 & 0xFF000000L) >>> 24)};
    }

    public static byte[] toLittleEndianWord(long l2) {
        return new byte[]{(byte)(l2 & 0xFFL), (byte)((l2 & 0xFF00L) >>> 8)};
    }
}

