/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.disassembly.ExpressionType;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.Stack;

public class OperandOrderIterator {
    private final Stack<Pair<IOperandTreeNode, Integer>> m_traversalStack = new Stack();
    private final IOperandTreeNode m_root;
    private boolean m_started = false;

    public OperandOrderIterator(IOperandTreeNode iOperandTreeNode) {
        Preconditions.checkNotNull(iOperandTreeNode, "Internal Error: Root node can't be null");
        this.m_root = iOperandTreeNode;
    }

    private void pushLongestPathFrom(IOperandTreeNode iOperandTreeNode) {
        IOperandTreeNode iOperandTreeNode2 = iOperandTreeNode;
        while (true) {
            this.m_traversalStack.push(new Pair<IOperandTreeNode, Integer>(iOperandTreeNode2, 0));
            if (iOperandTreeNode2.getChildren().size() <= 1 || iOperandTreeNode2.getType() == ExpressionType.EXPRESSION_LIST) break;
            iOperandTreeNode2 = iOperandTreeNode2.getChildren().get(0);
        }
    }

    public IOperandTreeNode current() {
        return (IOperandTreeNode)((Pair)this.m_traversalStack.lastElement()).first();
    }

    public boolean next() {
        if (!this.m_started) {
            this.pushLongestPathFrom(this.m_root);
            this.m_started = true;
        } else {
            if (this.m_traversalStack.empty()) {
                throw new RuntimeException("Internal Error: Traversal already finished");
            }
            Pair<IOperandTreeNode, Integer> pair = this.m_traversalStack.pop();
            IOperandTreeNode iOperandTreeNode = pair.first();
            int n2 = pair.second();
            if (n2 < iOperandTreeNode.getChildren().size()) {
                if (pair.first().getChildren().size() > 1) {
                    this.m_traversalStack.add(pair);
                }
                this.pushLongestPathFrom(iOperandTreeNode.getChildren().get(n2));
                return true;
            }
            if (this.m_traversalStack.empty()) {
                return false;
            }
            do {
                Pair<IOperandTreeNode, Integer> pair2;
                if ((pair2 = this.m_traversalStack.pop()).second() >= pair2.first().getChildren().size() - 1) continue;
                this.m_traversalStack.push(new Pair<IOperandTreeNode, Integer>(pair2.first(), pair2.second() + 1));
                return true;
            } while (!this.m_traversalStack.empty());
        }
        return !this.m_traversalStack.empty();
    }
}

