/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.ZyTree;

import com.google.security.zynamics.zylib.ZyTree.IZyTreeNode;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.Stack;

public class PostorderIterator {
    private final Stack<Pair<IZyTreeNode, Integer>> traversalStack = new Stack();
    private final IZyTreeNode m_root;
    private boolean m_started = false;

    public PostorderIterator(IZyTreeNode iZyTreeNode) {
        this.m_root = iZyTreeNode;
    }

    private void pushLongestPathFrom(IZyTreeNode iZyTreeNode) {
        IZyTreeNode iZyTreeNode2 = iZyTreeNode;
        while (true) {
            this.traversalStack.push(new Pair<IZyTreeNode, Integer>(iZyTreeNode2, 0));
            if (iZyTreeNode2.getChildren().size() == 0) break;
            iZyTreeNode2 = iZyTreeNode2.getChildren().get(0);
        }
    }

    public IZyTreeNode current() {
        return (IZyTreeNode)((Pair)this.traversalStack.lastElement()).first();
    }

    public boolean next() {
        if (this.m_started) {
            Pair<IZyTreeNode, Integer> pair;
            int n2;
            if (this.traversalStack.empty()) {
                throw new RuntimeException("Internal Error: Traversal already finished");
            }
            do {
                if (!this.traversalStack.empty()) continue;
                return false;
            } while ((n2 = (pair = this.traversalStack.pop()).second() + 1) > pair.first().getChildren().size());
            if (n2 == pair.first().getChildren().size()) {
                this.traversalStack.push(new Pair<IZyTreeNode, Integer>(pair.first(), n2));
                return true;
            }
            this.traversalStack.push(new Pair<IZyTreeNode, Integer>(pair.first(), n2));
            this.pushLongestPathFrom(pair.first().getChildren().get(n2));
            return true;
        }
        this.pushLongestPathFrom(this.m_root);
        this.m_started = true;
        return !this.traversalStack.empty();
    }
}

