/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.ZyTree;

import com.google.security.zynamics.zylib.ZyTree.IZyTreeNode;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.Stack;

public class InorderIterator {
    private final Stack<Pair<IZyTreeNode, Integer>> traversalStack = new Stack();
    private final IZyTreeNode m_root;
    private boolean m_started = false;

    public InorderIterator(IZyTreeNode iZyTreeNode) {
        this.m_root = iZyTreeNode;
    }

    private void pushLongestPathFrom(IZyTreeNode iZyTreeNode) {
        IZyTreeNode iZyTreeNode2 = iZyTreeNode;
        while (true) {
            this.traversalStack.push(new Pair<IZyTreeNode, Integer>(iZyTreeNode2, 0));
            if (iZyTreeNode2.getChildren().size() == 0) break;
            iZyTreeNode2 = iZyTreeNode2.getChildren().get(0);
        }
    }

    public IZyTreeNode current() {
        return (IZyTreeNode)((Pair)this.traversalStack.lastElement()).first();
    }

    public boolean next() {
        if (!this.m_started) {
            this.pushLongestPathFrom(this.m_root);
            this.m_started = true;
        } else {
            if (this.traversalStack.empty()) {
                throw new RuntimeException("Internal Error: Traversal already finished");
            }
            Pair<IZyTreeNode, Integer> pair = this.traversalStack.pop();
            IZyTreeNode iZyTreeNode = pair.first();
            int n2 = pair.second();
            if (this.traversalStack.empty()) {
                if (n2 == iZyTreeNode.getChildren().size()) {
                    return false;
                }
                if (iZyTreeNode.getChildren().size() == 0) {
                    throw new RuntimeException("Error");
                }
                if (iZyTreeNode.getChildren().size() == 1) {
                    this.pushLongestPathFrom(pair.first().getChildren().get(n2));
                } else {
                    this.traversalStack.push(new Pair<IZyTreeNode, Integer>(pair.first().getChildren().get(n2), 0));
                }
            } else if (n2 == iZyTreeNode.getChildren().size()) {
                Pair<IZyTreeNode, Integer> pair2 = this.traversalStack.pop();
                this.traversalStack.push(new Pair<IZyTreeNode, Integer>(pair2.first(), pair2.second() + 1));
            } else {
                if (iZyTreeNode.getChildren().size() == 0) {
                    throw new RuntimeException("Error");
                }
                if (iZyTreeNode.getChildren().size() == 1) {
                    this.pushLongestPathFrom(pair.first().getChildren().get(n2));
                } else {
                    this.traversalStack.push(new Pair<IZyTreeNode, Integer>(pair.first().getChildren().get(n2), 0));
                }
            }
        }
        return !this.traversalStack.empty();
    }
}

